/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.BreakUtil;

class RowGroupLayoutManager {
    private static Log log = LogFactory.getLog(RowGroupLayoutManager.class);
    private static final MinOptMax MAX_STRETCH = MinOptMax.getInstance(0, 0, Integer.MAX_VALUE);
    private EffRow[] rowGroup;
    private TableLayoutManager tableLM;
    private TableStepper tableStepper;

    RowGroupLayoutManager(TableLayoutManager tableLayoutManager, EffRow[] effRowArray, TableStepper tableStepper) {
        this.tableLM = tableLayoutManager;
        this.rowGroup = effRowArray;
        this.tableStepper = tableStepper;
    }

    public LinkedList getNextKnuthElements(LayoutContext layoutContext, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        this.createElementsForRowGroup(layoutContext, n, n2, linkedList);
        layoutContext.updateKeepWithPreviousPending(this.rowGroup[0].getKeepWithPrevious());
        layoutContext.updateKeepWithNextPending(this.rowGroup[this.rowGroup.length - 1].getKeepWithNext());
        int n3 = 9;
        TableRow tableRow = this.rowGroup[0].getTableRow();
        if (tableRow != null) {
            n3 = tableRow.getBreakBefore();
        }
        layoutContext.setBreakBefore(BreakUtil.compareBreakClasses(n3, this.rowGroup[0].getBreakBefore()));
        int n4 = 9;
        TableRow tableRow2 = this.rowGroup[this.rowGroup.length - 1].getTableRow();
        if (tableRow2 != null) {
            n4 = tableRow2.getBreakAfter();
        }
        layoutContext.setBreakAfter(BreakUtil.compareBreakClasses(n4, this.rowGroup[this.rowGroup.length - 1].getBreakAfter()));
        return linkedList;
    }

    private void createElementsForRowGroup(LayoutContext layoutContext, int n, int n2, LinkedList linkedList) {
        log.debug((Object)("Handling row group with " + this.rowGroup.length + " rows..."));
        for (int i = 0; i < this.rowGroup.length; ++i) {
            EffRow effRow = this.rowGroup[i];
            for (GridUnit gridUnit : effRow.getGridUnits()) {
                if (!gridUnit.isPrimary()) continue;
                PrimaryGridUnit primaryGridUnit = gridUnit.getPrimary();
                primaryGridUnit.createCellLM();
                primaryGridUnit.getCellLM().setParent(this.tableLM);
                int n3 = 0;
                ListIterator listIterator = this.tableLM.getTable().getColumns().listIterator(primaryGridUnit.getColIndex());
                int n4 = primaryGridUnit.getCell().getNumberColumnsSpanned();
                for (int j = 0; j < n4; ++j) {
                    n3 += ((TableColumn)listIterator.next()).getColumnWidth().getValue(this.tableLM);
                }
                LayoutContext layoutContext2 = new LayoutContext(0);
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutContext2.setRefIPD(n3);
                List list = primaryGridUnit.getCellLM().getNextKnuthElements(layoutContext2, n);
                ElementListObserver.observe(list, "table-cell", primaryGridUnit.getCell().getId());
                primaryGridUnit.setElements(list);
            }
        }
        this.computeRowHeights();
        LinkedList linkedList2 = this.tableStepper.getCombinedKnuthElementsForRowGroup(layoutContext, this.rowGroup, n2);
        linkedList.addAll(linkedList2);
    }

    private void computeRowHeights() {
        log.debug((Object)"rowGroup:");
        MinOptMax[] minOptMaxArray = new MinOptMax[this.rowGroup.length];
        for (int i = 0; i < this.rowGroup.length; ++i) {
            MinOptMax minOptMax;
            EffRow effRow = this.rowGroup[i];
            TableRow tableRow = this.rowGroup[i].getTableRow();
            if (tableRow == null) {
                minOptMaxArray[i] = MAX_STRETCH;
                minOptMax = MAX_STRETCH;
            } else {
                LengthRangeProperty lengthRangeProperty = tableRow.getBlockProgressionDimension();
                minOptMaxArray[i] = lengthRangeProperty.toMinOptMax(this.tableLM);
                minOptMax = lengthRangeProperty.toMinOptMax(this.tableLM);
            }
            for (GridUnit gridUnit : effRow.getGridUnits()) {
                if (gridUnit.isEmpty() || gridUnit.getColSpanIndex() != 0 || !gridUnit.isLastGridUnitRowSpan()) continue;
                PrimaryGridUnit primaryGridUnit = gridUnit.getPrimary();
                int n = 0;
                LengthRangeProperty lengthRangeProperty = primaryGridUnit.getCell().getBlockProgressionDimension();
                if (!lengthRangeProperty.getMinimum(this.tableLM).isAuto()) {
                    n = lengthRangeProperty.getMinimum(this.tableLM).getLength().getValue(this.tableLM);
                }
                if (!lengthRangeProperty.getOptimum(this.tableLM).isAuto()) {
                    n = lengthRangeProperty.getOptimum(this.tableLM).getLength().getValue(this.tableLM);
                }
                if (gridUnit.getRowSpanIndex() == 0) {
                    n = Math.max(n, minOptMax.getOpt());
                }
                n = Math.max(n, primaryGridUnit.getContentLength());
                int n2 = primaryGridUnit.getBeforeAfterBorderWidth();
                int n3 = 0;
                CommonBorderPaddingBackground commonBorderPaddingBackground = primaryGridUnit.getCell().getCommonBorderPaddingBackground();
                n3 += commonBorderPaddingBackground.getPaddingBefore(false, primaryGridUnit.getCellLM());
                int n4 = n + (n3 += commonBorderPaddingBackground.getPaddingAfter(false, primaryGridUnit.getCellLM())) + n2;
                for (int j = i - 1; j >= i - gridUnit.getRowSpanIndex(); --j) {
                    n4 -= minOptMaxArray[j].getOpt();
                }
                if (n4 <= minOptMaxArray[i].getMin()) continue;
                minOptMaxArray[i] = minOptMaxArray[i].extendMinimum(n4);
            }
            effRow.setHeight(minOptMaxArray[i]);
            effRow.setExplicitHeight(minOptMax);
        }
    }
}

