/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.RowGroupLayoutManager;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableHeaderFooterPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableRowIterator;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.util.BreakUtil;

public class TableContentLayoutManager
implements PercentBaseContext {
    private static final Log LOG = LogFactory.getLog(TableContentLayoutManager.class);
    private TableLayoutManager tableLM;
    private TableRowIterator bodyIter;
    private TableRowIterator headerIter;
    private TableRowIterator footerIter;
    private LinkedList headerList;
    private LinkedList footerList;
    private int headerNetHeight = 0;
    private int footerNetHeight = 0;
    private int startXOffset;
    private int usedBPD;
    private TableStepper stepper;

    TableContentLayoutManager(TableLayoutManager tableLayoutManager) {
        this.tableLM = tableLayoutManager;
        Table table = this.getTableLM().getTable();
        this.bodyIter = new TableRowIterator(table, 0);
        if (table.getTableHeader() != null) {
            this.headerIter = new TableRowIterator(table, 1);
        }
        if (table.getTableFooter() != null) {
            this.footerIter = new TableRowIterator(table, 2);
        }
        this.stepper = new TableStepper(this);
    }

    TableLayoutManager getTableLM() {
        return this.tableLM;
    }

    boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    ColumnSetup getColumns() {
        return this.getTableLM().getColumns();
    }

    protected int getHeaderNetHeight() {
        return this.headerNetHeight;
    }

    protected int getFooterNetHeight() {
        return this.footerNetHeight;
    }

    protected LinkedList getHeaderElements() {
        return this.headerList;
    }

    protected LinkedList getFooterElements() {
        return this.footerList;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        KnuthBox knuthBox;
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> Columns: " + this.getTableLM().getColumns()));
        }
        KnuthBox knuthBox2 = null;
        KnuthBox knuthBox3 = null;
        KnuthBox knuthBox4 = null;
        if (this.headerIter != null && this.headerList == null) {
            this.headerList = this.getKnuthElementsForRowIterator(this.headerIter, layoutContext, n, 1);
            this.headerNetHeight = ElementListUtils.calcContentLength(this.headerList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> Header: " + this.headerNetHeight + " - " + this.headerList));
            }
            object = new TableHeaderFooterPosition(this.getTableLM(), true, this.headerList);
            knuthBox = new KnuthBox(this.headerNetHeight, (Position)object, false);
            if (this.getTableLM().getTable().omitHeaderAtBreak()) {
                knuthBox2 = knuthBox;
            } else {
                knuthBox3 = knuthBox;
            }
        }
        if (this.footerIter != null && this.footerList == null) {
            this.footerList = this.getKnuthElementsForRowIterator(this.footerIter, layoutContext, n, 2);
            this.footerNetHeight = ElementListUtils.calcContentLength(this.footerList);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> Footer: " + this.footerNetHeight + " - " + this.footerList));
            }
            object = new TableHeaderFooterPosition(this.getTableLM(), false, this.footerList);
            knuthBox4 = knuthBox = new KnuthBox(this.footerNetHeight, (Position)object, false);
        }
        object = this.getKnuthElementsForRowIterator(this.bodyIter, layoutContext, n, 0);
        if (knuthBox2 != null) {
            int n2 = 0;
            if (((LinkedList)object).size() > 0 && ((ListElement)((LinkedList)object).getFirst()).isForcedBreak()) {
                ++n2;
            }
            ((LinkedList)object).add(n2, knuthBox2);
        } else if (knuthBox3 != null) {
            int n3 = ((LinkedList)object).size();
            if (((LinkedList)object).size() > 0 && ((ListElement)((LinkedList)object).getLast()).isForcedBreak()) {
                --n3;
            }
            ((LinkedList)object).add(n3, knuthBox3);
        }
        if (knuthBox4 != null) {
            int n4 = ((LinkedList)object).size();
            if (((LinkedList)object).size() > 0 && ((ListElement)((LinkedList)object).getLast()).isForcedBreak()) {
                --n4;
            }
            ((LinkedList)object).add(n4, knuthBox4);
        }
        return object;
    }

    private LinkedList getKnuthElementsForRowIterator(TableRowIterator tableRowIterator, LayoutContext layoutContext, int n, int n2) {
        int n3;
        Object object;
        Object object2;
        LinkedList linkedList = new LinkedList();
        EffRow[] effRowArray = tableRowIterator.getNextRowGroup();
        layoutContext.clearKeepsPending();
        layoutContext.setBreakBefore(9);
        layoutContext.setBreakAfter(9);
        Keep keep = Keep.KEEP_AUTO;
        int n4 = 9;
        if (effRowArray != null) {
            object2 = new RowGroupLayoutManager(this.getTableLM(), effRowArray, this.stepper);
            object = ((RowGroupLayoutManager)object2).getNextKnuthElements(layoutContext, n, n2);
            keep = keep.compare(layoutContext.getKeepWithPreviousPending());
            n4 = layoutContext.getBreakBefore();
            int n5 = layoutContext.getBreakAfter();
            linkedList.addAll(object);
            while ((effRowArray = tableRowIterator.getNextRowGroup()) != null) {
                ListIterator listIterator;
                ListElement listElement;
                object2 = new RowGroupLayoutManager(this.getTableLM(), effRowArray, this.stepper);
                Keep keep2 = layoutContext.getKeepWithNextPending();
                layoutContext.clearKeepWithNextPending();
                object = ((RowGroupLayoutManager)object2).getNextKnuthElements(layoutContext, n, n2);
                Keep keep3 = keep2.compare(layoutContext.getKeepWithPreviousPending());
                layoutContext.clearKeepWithPreviousPending();
                keep3 = keep3.compare(this.getTableLM().getKeepTogether());
                int n6 = keep3.getPenalty();
                int n7 = keep3.getContext();
                n5 = BreakUtil.compareBreakClasses(n5, layoutContext.getBreakBefore());
                if (n5 != 9) {
                    n6 = -1000;
                    n7 = n5;
                }
                BreakElement breakElement = (listElement = (ListElement)(listIterator = linkedList.listIterator(linkedList.size())).previous()) instanceof KnuthGlue ? (BreakElement)listIterator.previous() : (BreakElement)listElement;
                breakElement.setPenaltyValue(n6);
                breakElement.setBreakClass(n7);
                linkedList.addAll(object);
                n5 = layoutContext.getBreakAfter();
            }
        }
        if ((object = (ListElement)(object2 = linkedList.listIterator(linkedList.size())).previous()) instanceof KnuthGlue) {
            BreakElement breakElement = (BreakElement)object2.previous();
            breakElement.setPenaltyValue(1000);
        } else {
            object2.remove();
        }
        layoutContext.updateKeepWithPreviousPending(keep);
        layoutContext.setBreakBefore(n4);
        int n8 = this.getTableLM().getTable().getWidowContentLimit().getValue();
        if (n8 != 0 && n2 == 0) {
            ElementListUtils.removeLegalBreaks(linkedList, n8);
        }
        if ((n3 = this.getTableLM().getTable().getOrphanContentLimit().getValue()) != 0 && n2 == 0) {
            ElementListUtils.removeLegalBreaksFromEnd(linkedList, n3);
        }
        return linkedList;
    }

    protected int getXOffsetOfGridUnit(PrimaryGridUnit primaryGridUnit) {
        return this.getXOffsetOfGridUnit(primaryGridUnit.getColIndex(), primaryGridUnit.getCell().getNumberColumnsSpanned());
    }

    protected int getXOffsetOfGridUnit(int n, int n2) {
        return this.startXOffset + this.getTableLM().getColumns().getXOffset(n + 1, n2, this.getTableLM());
    }

    void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        Object object;
        this.usedBPD = 0;
        RowPainter rowPainter = new RowPainter(this, layoutContext);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = null;
        List list2 = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        while (positionIterator.hasNext()) {
            object = positionIterator.next();
            if (object instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                object = ((SpaceResolver.SpaceHandlingBreakPosition)object).getOriginalBreakPosition();
            }
            if (object == null) continue;
            if (object2 == null) {
                object2 = object;
            }
            object3 = object;
            if (((Position)object).getIndex() >= 0) {
                object4 = object;
            }
            if (object instanceof TableHeaderFooterPosition) {
                TableHeaderFooterPosition tableHeaderFooterPosition = (TableHeaderFooterPosition)object;
                if (tableHeaderFooterPosition.header) {
                    list = tableHeaderFooterPosition.nestedElements;
                    continue;
                }
                list2 = tableHeaderFooterPosition.nestedElements;
                continue;
            }
            if (object instanceof TableHFPenaltyPosition) continue;
            if (object instanceof TableContentPosition) {
                arrayList.add(object);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ignoring position: " + object));
        }
        if (object3 instanceof TableHFPenaltyPosition) {
            object = (TableHFPenaltyPosition)object3;
            LOG.debug((Object)"Break at penalty!");
            if (((TableHFPenaltyPosition)object).headerElements != null) {
                list = ((TableHFPenaltyPosition)object).headerElements;
            }
            if (((TableHFPenaltyPosition)object).footerElements != null) {
                list2 = ((TableHFPenaltyPosition)object).footerElements;
            }
        }
        if ((object = this.getTableLM().getTable().getMarkers()) != null) {
            this.getTableLM().getCurrentPV().addMarkers((Map<String, Marker>)object, true, this.getTableLM().isFirst((Position)object2), this.getTableLM().isLast((Position)object4));
        }
        if (list != null) {
            this.addHeaderFooterAreas(list, this.tableLM.getTable().getTableHeader(), rowPainter, false);
        }
        if (arrayList.isEmpty()) {
            LOG.error((Object)"tablePositions empty. Please send your FO file to fop-users@xmlgraphics.apache.org");
        } else {
            this.addBodyAreas(arrayList.iterator(), rowPainter, list2 == null);
        }
        if (list2 != null) {
            this.addHeaderFooterAreas(list2, this.tableLM.getTable().getTableFooter(), rowPainter, true);
        }
        this.usedBPD += rowPainter.getAccumulatedBPD();
        if (object != null) {
            this.getTableLM().getCurrentPV().addMarkers((Map<String, Marker>)object, false, this.getTableLM().isFirst((Position)object2), this.getTableLM().isLast((Position)object4));
        }
    }

    private void addHeaderFooterAreas(List list, TablePart tablePart, RowPainter rowPainter, boolean bl) {
        ArrayList<TableContentPosition> arrayList = new ArrayList<TableContentPosition>(list.size());
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(list);
        while (knuthPossPosIter.hasNext()) {
            Position position = (Position)knuthPossPosIter.next();
            if (!(position instanceof TableContentPosition)) continue;
            arrayList.add((TableContentPosition)position);
        }
        this.addTablePartAreas(arrayList, rowPainter, tablePart, true, true, true, bl);
    }

    private void addBodyAreas(Iterator iterator, RowPainter rowPainter, boolean bl) {
        rowPainter.startBody();
        ArrayList<TableContentPosition> arrayList = new ArrayList<TableContentPosition>();
        TableContentPosition tableContentPosition = (TableContentPosition)iterator.next();
        boolean bl2 = tableContentPosition.getFlag(1) && tableContentPosition.getRow().getFlag(0);
        TablePart tablePart = tableContentPosition.getTablePart();
        arrayList.add(tableContentPosition);
        while (iterator.hasNext()) {
            tableContentPosition = (TableContentPosition)iterator.next();
            if (tableContentPosition.getTablePart() != tablePart) {
                this.addTablePartAreas(arrayList, rowPainter, tablePart, bl2, true, false, false);
                bl2 = true;
                arrayList.clear();
                tablePart = tableContentPosition.getTablePart();
            }
            arrayList.add(tableContentPosition);
        }
        boolean bl3 = tableContentPosition.getFlag(2) && tableContentPosition.getRow().getFlag(1);
        this.addTablePartAreas(arrayList, rowPainter, tablePart, bl2, bl3, true, bl);
        rowPainter.endBody();
    }

    private void addTablePartAreas(List list, RowPainter rowPainter, TablePart tablePart, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.getTableLM().getCurrentPV().addMarkers(tablePart.getMarkers(), true, bl, bl2);
        rowPainter.startTablePart(tablePart);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            rowPainter.handleTableContentPosition((TableContentPosition)iterator.next());
        }
        this.getTableLM().getCurrentPV().addMarkers(tablePart.getMarkers(), false, bl, bl2);
        rowPainter.endTablePart(bl3, bl4);
    }

    void setStartXOffset(int n) {
        this.startXOffset = n;
    }

    int getUsedBPD() {
        return this.usedBPD;
    }

    public int getBaseLength(int n, FObj fObj) {
        return this.tableLM.getBaseLength(n, fObj);
    }
}

