/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;

public class TableRowIterator {
    public static final int BODY = 0;
    public static final int HEADER = 1;
    public static final int FOOTER = 2;
    protected Table table;
    private int tablePart;
    private Iterator rowGroupsIter;
    private int rowIndex = 0;

    public TableRowIterator(Table table, int n) {
        this.table = table;
        this.tablePart = n;
        switch (n) {
            case 1: {
                this.rowGroupsIter = table.getTableHeader().getRowGroups().iterator();
                break;
            }
            case 2: {
                this.rowGroupsIter = table.getTableFooter().getRowGroups().iterator();
                break;
            }
            case 0: {
                LinkedList linkedList = new LinkedList();
                FONode.FONodeIterator fONodeIterator = table.getChildNodes();
                while (fONodeIterator.hasNext()) {
                    FONode fONode = fONodeIterator.nextNode();
                    if (!(fONode instanceof TableBody)) continue;
                    linkedList.addAll(((TableBody)fONode).getRowGroups());
                }
                this.rowGroupsIter = linkedList.iterator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised TablePart: " + n);
            }
        }
    }

    EffRow[] getNextRowGroup() {
        if (!this.rowGroupsIter.hasNext()) {
            return null;
        }
        List list = (List)this.rowGroupsIter.next();
        EffRow[] effRowArray = new EffRow[list.size()];
        int n = 0;
        for (List list2 : list) {
            effRowArray[n++] = new EffRow(this.rowIndex++, this.tablePart, list2);
        }
        return effRowArray;
    }
}

