/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.table.ActiveCell;
import org.apache.fop.layoutmgr.table.CellPart;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.util.BreakUtil;

public class TableStepper {
    private static Log log = LogFactory.getLog(TableStepper.class);
    private TableContentLayoutManager tclm;
    private EffRow[] rowGroup;
    private int columnCount;
    private int totalHeight;
    private int previousRowsLength;
    private int activeRowIndex;
    private boolean rowFinished;
    private List activeCells = new LinkedList();
    private List nextActiveCells = new LinkedList();
    private boolean delayingNextRow;
    private int rowFirstStep;
    private boolean rowHeightSmallerThanFirstStep;
    private int nextBreakClass;

    public TableStepper(TableContentLayoutManager tableContentLayoutManager) {
        this.tclm = tableContentLayoutManager;
        this.columnCount = tableContentLayoutManager.getTableLM().getTable().getNumberOfColumns();
    }

    private void setup(EffRow[] effRowArray) {
        this.rowGroup = effRowArray;
        this.previousRowsLength = 0;
        this.activeRowIndex = 0;
        this.activeCells.clear();
        this.nextActiveCells.clear();
        this.delayingNextRow = false;
        this.rowFirstStep = 0;
        this.rowHeightSmallerThanFirstStep = false;
    }

    private void calcTotalHeight() {
        this.totalHeight = 0;
        for (int i = 0; i < this.rowGroup.length; ++i) {
            this.totalHeight += this.rowGroup[i].getHeight().getOpt();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("totalHeight=" + this.totalHeight));
        }
    }

    private int getMaxRemainingHeight() {
        int n = 0;
        for (ActiveCell activeCell : this.activeCells) {
            int n2 = activeCell.getRemainingLength();
            PrimaryGridUnit primaryGridUnit = activeCell.getPrimaryGridUnit();
            for (int i = this.activeRowIndex + 1; i < primaryGridUnit.getRowIndex() - this.rowGroup[0].getIndex() + primaryGridUnit.getCell().getNumberRowsSpanned(); ++i) {
                n2 -= this.rowGroup[i].getHeight().getOpt();
            }
            n = Math.max(n, n2);
        }
        for (int i = this.activeRowIndex + 1; i < this.rowGroup.length; ++i) {
            n += this.rowGroup[i].getHeight().getOpt();
        }
        return n;
    }

    private void activateCells(List list, int n) {
        EffRow effRow = this.rowGroup[n];
        for (int i = 0; i < this.columnCount; ++i) {
            GridUnit gridUnit = effRow.getGridUnit(i);
            if (gridUnit.isEmpty() || !gridUnit.isPrimary()) continue;
            list.add(new ActiveCell((PrimaryGridUnit)gridUnit, effRow, n, this.previousRowsLength, this.getTableLM()));
        }
    }

    public LinkedList getCombinedKnuthElementsForRowGroup(LayoutContext layoutContext, EffRow[] effRowArray, int n) {
        this.setup(effRowArray);
        this.activateCells(this.activeCells, 0);
        this.calcTotalHeight();
        int n2 = 0;
        TableContentPosition tableContentPosition = null;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        int n3 = 0;
        int n4 = this.getFirstStep();
        do {
            Object object;
            int n5 = this.getMaxRemainingHeight();
            int n6 = n4 + n5 - this.totalHeight;
            int n7 = n4 - n2 - Math.max(0, n6);
            n2 += n7 + Math.max(0, -n6);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Next step: " + n4 + " (+" + (n4 - n3) + ")"));
                log.debug((Object)("           max remaining height: " + n5));
                if (n6 >= 0) {
                    log.debug((Object)("           box = " + n7 + " penalty = " + n6));
                } else {
                    log.debug((Object)("           box = " + n7 + " glue = " + -n6));
                }
            }
            LinkedList linkedList2 = new LinkedList();
            ArrayList<CellPart> arrayList = new ArrayList<CellPart>(this.activeCells.size());
            for (ActiveCell activeCell : this.activeCells) {
                object = activeCell.createCellPart();
                arrayList.add((CellPart)object);
                activeCell.addFootnotes(linkedList2);
            }
            TableContentPosition tableContentPosition2 = new TableContentPosition(this.getTableLM(), arrayList, this.rowGroup[this.activeRowIndex]);
            if (this.delayingNextRow) {
                tableContentPosition2.setNewPageRow(this.rowGroup[this.activeRowIndex + 1]);
            }
            if (linkedList.size() == 0) {
                tableContentPosition2.setFlag(1, true);
            }
            tableContentPosition = tableContentPosition2;
            if (linkedList2.isEmpty()) {
                linkedList.add(new KnuthBox(n7, tableContentPosition2, false));
            } else {
                linkedList.add(new KnuthBlockBox(n7, linkedList2, tableContentPosition2, false));
            }
            int n8 = Math.max(0, n6);
            object = new TableHFPenaltyPosition(this.getTableLM());
            if (n == 0) {
                if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                    n8 += this.tclm.getHeaderNetHeight();
                    ((TableHFPenaltyPosition)object).headerElements = this.tclm.getHeaderElements();
                }
                if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                    n8 += this.tclm.getFooterNetHeight();
                    ((TableHFPenaltyPosition)object).footerElements = this.tclm.getFooterElements();
                }
            }
            Keep keep = this.getTableLM().getKeepTogether();
            int n9 = 0;
            for (ActiveCell activeCell : this.activeCells) {
                keep = keep.compare(activeCell.getKeepWithNext());
                n9 = Math.max(n9, activeCell.getPenaltyValue());
            }
            if (!this.rowFinished) {
                keep = keep.compare(this.rowGroup[this.activeRowIndex].getKeepTogether());
            } else if (this.activeRowIndex < this.rowGroup.length - 1) {
                keep = keep.compare(this.rowGroup[this.activeRowIndex].getKeepWithNext());
                keep = keep.compare(this.rowGroup[this.activeRowIndex + 1].getKeepWithPrevious());
                this.nextBreakClass = BreakUtil.compareBreakClasses(this.nextBreakClass, this.rowGroup[this.activeRowIndex].getBreakAfter());
                this.nextBreakClass = BreakUtil.compareBreakClasses(this.nextBreakClass, this.rowGroup[this.activeRowIndex + 1].getBreakBefore());
            }
            int n10 = keep.getPenalty();
            if (this.rowHeightSmallerThanFirstStep) {
                this.rowHeightSmallerThanFirstStep = false;
                n10 = 1000;
            }
            n10 = Math.max(n10, n9);
            int n11 = keep.getContext();
            if (this.nextBreakClass != 9) {
                log.trace((Object)"Forced break encountered");
                n10 = -1000;
                n11 = this.nextBreakClass;
            }
            linkedList.add(new BreakElement((Position)object, n8, n10, n11, layoutContext));
            if (n6 < 0) {
                linkedList.add(new KnuthGlue(-n6, 0, 0, new Position(null), true));
            }
            n3 = n4;
        } while ((n4 = this.getNextStep()) >= 0);
        assert (!linkedList.isEmpty());
        tableContentPosition.setFlag(2, true);
        return linkedList;
    }

    private int getFirstStep() {
        this.computeRowFirstStep(this.activeCells);
        this.signalRowFirstStep();
        int n = this.considerRowLastStep(this.rowFirstStep);
        this.signalNextStep(n);
        return n;
    }

    private int getNextStep() {
        if (this.rowFinished) {
            if (this.activeRowIndex == this.rowGroup.length - 1) {
                return -1;
            }
            this.rowFinished = false;
            this.removeCellsEndingOnCurrentRow();
            log.trace((Object)"Delaying next row");
            this.delayingNextRow = true;
        }
        if (this.delayingNextRow) {
            int n = this.computeMinStep();
            if (n < 0 || n >= this.rowFirstStep || n > this.rowGroup[this.activeRowIndex].getExplicitHeight().getMax()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Step = " + n));
                }
                this.delayingNextRow = false;
                n = this.rowFirstStep;
                this.switchToNextRow();
                this.signalRowFirstStep();
                n = this.considerRowLastStep(n);
            }
            this.signalNextStep(n);
            return n;
        }
        int n = this.computeMinStep();
        n = this.considerRowLastStep(n);
        this.signalNextStep(n);
        return n;
    }

    private void computeRowFirstStep(List list) {
        for (ActiveCell activeCell : list) {
            this.rowFirstStep = Math.max(this.rowFirstStep, activeCell.getFirstStep());
        }
    }

    private int computeMinStep() {
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        for (ActiveCell activeCell : this.activeCells) {
            int n2 = activeCell.getNextStep();
            if (n2 < 0) continue;
            bl = true;
            n = Math.min(n, n2);
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private void signalRowFirstStep() {
        for (ActiveCell activeCell : this.activeCells) {
            activeCell.signalRowFirstStep(this.rowFirstStep);
        }
    }

    private void signalNextStep(int n) {
        this.nextBreakClass = 9;
        for (ActiveCell activeCell : this.activeCells) {
            this.nextBreakClass = BreakUtil.compareBreakClasses(this.nextBreakClass, activeCell.signalNextStep(n));
        }
    }

    private int considerRowLastStep(int n) {
        this.rowFinished = true;
        for (Object object : this.activeCells) {
            if (!((ActiveCell)object).endsOnRow(this.activeRowIndex)) continue;
            this.rowFinished &= ((ActiveCell)object).finishes(n);
        }
        if (this.rowFinished) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Step = " + n));
                log.trace((Object)"Row finished, computing last step");
            }
            int n2 = 0;
            for (ActiveCell activeCell : this.activeCells) {
                if (!activeCell.endsOnRow(this.activeRowIndex)) continue;
                n2 = Math.max(n2, activeCell.getLastStep());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Max step: " + n2));
            }
            for (ActiveCell activeCell : this.activeCells) {
                activeCell.endRow(this.activeRowIndex);
                if (activeCell.endsOnRow(this.activeRowIndex)) continue;
                activeCell.signalRowLastStep(n2);
            }
            if (n2 < n) {
                log.trace((Object)"Row height smaller than first step, produced penalty will be infinite");
                this.rowHeightSmallerThanFirstStep = true;
            }
            n = n2;
            this.prepareNextRow();
        }
        return n;
    }

    private void prepareNextRow() {
        if (this.activeRowIndex < this.rowGroup.length - 1) {
            this.previousRowsLength += this.rowGroup[this.activeRowIndex].getHeight().getOpt();
            this.activateCells(this.nextActiveCells, this.activeRowIndex + 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Computing first step for row " + (this.activeRowIndex + 2)));
            }
            this.computeRowFirstStep(this.nextActiveCells);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Next first step = " + this.rowFirstStep));
            }
        }
    }

    private void removeCellsEndingOnCurrentRow() {
        Iterator iterator = this.activeCells.iterator();
        while (iterator.hasNext()) {
            ActiveCell activeCell = (ActiveCell)iterator.next();
            if (!activeCell.endsOnRow(this.activeRowIndex)) continue;
            iterator.remove();
        }
    }

    private void switchToNextRow() {
        ++this.activeRowIndex;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Switching to row " + (this.activeRowIndex + 1)));
        }
        for (ActiveCell activeCell : this.activeCells) {
            activeCell.nextRowStarts();
        }
        this.activeCells.addAll(this.nextActiveCells);
        this.nextActiveCells.clear();
    }

    private TableLayoutManager getTableLM() {
        return this.tclm.getTableLM();
    }
}

