/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;
import org.apache.fop.pdf.PDFObject;
import org.apache.xmlgraphics.util.io.FlateEncodeOutputStream;

public class FlateFilter
extends PDFFilter {
    public static final int PREDICTION_NONE = 1;
    public static final int PREDICTION_TIFF2 = 2;
    public static final int PREDICTION_PNG_NONE = 10;
    public static final int PREDICTION_PNG_SUB = 11;
    public static final int PREDICTION_PNG_UP = 12;
    public static final int PREDICTION_PNG_AVG = 13;
    public static final int PREDICTION_PNG_PAETH = 14;
    public static final int PREDICTION_PNG_OPT = 15;
    private int predictor = 1;
    private int colors;
    private int bitsPerComponent;
    private int columns;

    public String getName() {
        return "/FlateDecode";
    }

    public PDFObject getDecodeParms() {
        if (this.predictor > 1) {
            PDFDictionary pDFDictionary = new PDFDictionary();
            pDFDictionary.put("Predictor", this.predictor);
            if (this.colors > 1) {
                pDFDictionary.put("Colors", this.colors);
            }
            if (this.bitsPerComponent > 0 && this.bitsPerComponent != 8) {
                pDFDictionary.put("BitsPerComponent", this.bitsPerComponent);
            }
            if (this.columns > 1) {
                pDFDictionary.put("Columns", this.columns);
            }
            return pDFDictionary;
        }
        return null;
    }

    public void setPredictor(int n) throws PDFFilterException {
        this.predictor = n;
    }

    public int getPredictor() {
        return this.predictor;
    }

    public void setColors(int n) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Colors");
        }
        this.colors = n;
    }

    public int getColors() {
        return this.colors;
    }

    public void setBitsPerComponent(int n) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set bitsPerComponent");
        }
        this.bitsPerComponent = n;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public void setColumns(int n) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Columns");
        }
        this.columns = n;
    }

    public int getColumns() {
        return this.columns;
    }

    public OutputStream applyFilter(OutputStream outputStream) throws IOException {
        if (this.isApplied()) {
            return outputStream;
        }
        return new FlateEncodeOutputStream(outputStream);
    }
}

