/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFWArray;

public class PDFCIDFont
extends PDFObject {
    private String basefont;
    private CIDFontType cidtype;
    private Integer dw;
    private PDFWArray w;
    private int[] dw2;
    private PDFWArray w2;
    private PDFCIDSystemInfo systemInfo;
    private PDFCIDFontDescriptor descriptor;
    private PDFCMap cmap;
    private PDFStream cidMap;

    public PDFCIDFont(String string, CIDFontType cIDFontType, int n, int[] nArray, String string2, String string3, int n2, PDFCIDFontDescriptor pDFCIDFontDescriptor) {
        this(string, cIDFontType, n, new PDFWArray(nArray), new PDFCIDSystemInfo(string2, string3, n2), pDFCIDFontDescriptor);
    }

    public PDFCIDFont(String string, CIDFontType cIDFontType, int n, int[] nArray, PDFCIDSystemInfo pDFCIDSystemInfo, PDFCIDFontDescriptor pDFCIDFontDescriptor) {
        this(string, cIDFontType, n, new PDFWArray(nArray), pDFCIDSystemInfo, pDFCIDFontDescriptor);
    }

    public PDFCIDFont(String string, CIDFontType cIDFontType, int n, PDFWArray pDFWArray, PDFCIDSystemInfo pDFCIDSystemInfo, PDFCIDFontDescriptor pDFCIDFontDescriptor) {
        this.basefont = string;
        this.cidtype = cIDFontType;
        this.dw = new Integer(n);
        this.w = pDFWArray;
        this.dw2 = null;
        this.w2 = null;
        this.systemInfo = pDFCIDSystemInfo;
        this.descriptor = pDFCIDFontDescriptor;
        this.cidMap = null;
        this.cmap = null;
    }

    public void setDW(int n) {
        this.dw = new Integer(n);
    }

    public void setW(PDFWArray pDFWArray) {
        this.w = pDFWArray;
    }

    public void setDW2(int[] nArray) {
        this.dw2 = nArray;
    }

    public void setDW2(int n, int n2) {
        this.dw2 = new int[]{n, n2};
    }

    public void setCMAP(PDFCMap pDFCMap) {
        this.cmap = pDFCMap;
    }

    public void setW2(PDFWArray pDFWArray) {
        this.w2 = pDFWArray;
    }

    public void setCIDMap(PDFStream pDFStream) {
        this.cidMap = pDFStream;
    }

    public void setCIDMapIdentity() {
        this.cidMap = null;
    }

    protected String getPDFNameForCIDFontType(CIDFontType cIDFontType) {
        if (cIDFontType == CIDFontType.CIDTYPE0) {
            return cIDFontType.getName();
        }
        if (cIDFontType == CIDFontType.CIDTYPE2) {
            return cIDFontType.getName();
        }
        throw new IllegalArgumentException("Unsupported CID font type: " + cIDFontType.getName());
    }

    public String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<< /Type /Font");
        stringBuffer.append("\n/BaseFont /");
        stringBuffer.append(this.basefont);
        stringBuffer.append(" \n/CIDToGIDMap ");
        if (this.cidMap != null) {
            stringBuffer.append(this.cidMap.referencePDF());
        } else {
            stringBuffer.append("/Identity");
        }
        stringBuffer.append(" \n/Subtype /");
        stringBuffer.append(this.getPDFNameForCIDFontType(this.cidtype));
        stringBuffer.append("\n");
        stringBuffer.append(this.systemInfo.toPDFString());
        stringBuffer.append("\n/FontDescriptor ");
        stringBuffer.append(this.descriptor.referencePDF());
        if (this.cmap != null) {
            stringBuffer.append("\n/ToUnicode ");
            stringBuffer.append(this.cmap.referencePDF());
        }
        if (this.dw != null) {
            stringBuffer.append("\n/DW ");
            stringBuffer.append(this.dw);
        }
        if (this.w != null) {
            stringBuffer.append("\n/W ");
            stringBuffer.append(this.w.toPDFString());
        }
        if (this.dw2 != null) {
            stringBuffer.append("\n/DW2 [");
            stringBuffer.append(this.dw2[0]);
            stringBuffer.append(this.dw2[1]);
            stringBuffer.append("]");
        }
        if (this.w2 != null) {
            stringBuffer.append("\n/W2 ");
            stringBuffer.append(this.w2.toPDFString());
        }
        stringBuffer.append("\n>>");
        return stringBuffer.toString();
    }
}

