/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.List;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;

public class PDFFunction
extends PDFObject {
    protected int functionType = 0;
    protected List domain = null;
    protected List range = null;
    protected List size = null;
    protected int bitsPerSample = 1;
    protected int order = 1;
    protected List encode = null;
    protected List decode = null;
    protected StringBuffer functionDataStream = null;
    protected List filter = null;
    protected List cZero = null;
    protected List cOne = null;
    protected double interpolationExponentN = 1.0;
    protected List functions = null;
    protected List bounds = null;

    public PDFFunction(int n, List list, List list2, List list3, int n2, int n3, List list4, List list5, StringBuffer stringBuffer, List list6) {
        this.functionType = 0;
        this.size = list3;
        this.bitsPerSample = n2;
        this.order = n3;
        this.encode = list4;
        this.decode = list5;
        this.functionDataStream = stringBuffer;
        this.filter = list6;
        this.domain = list;
        this.range = list2;
    }

    public PDFFunction(int n, List list, List list2, List list3, List list4, double d) {
        this.functionType = 2;
        this.cZero = list3;
        this.cOne = list4;
        this.interpolationExponentN = d;
        this.domain = list;
        this.range = list2;
    }

    public PDFFunction(int n, List list, List list2, List list3, List list4, List list5) {
        this.functionType = 3;
        this.functions = list3;
        this.bounds = list4;
        this.encode = list5;
        this.domain = list;
        this.range = list2;
    }

    public PDFFunction(int n, List list, List list2, StringBuffer stringBuffer) {
        this.functionType = 4;
        this.functionDataStream = stringBuffer;
        this.domain = list;
        this.range = list2;
    }

    public byte[] toPDF() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<< \n/FunctionType " + this.functionType + " \n");
        if (this.functionType == 0) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.size != null) {
                stringBuffer.append("/Size [ ");
                n = this.size.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.size.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.encode != null) {
                stringBuffer.append("/Encode [ ");
                n = this.encode.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.encode.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Encode [ ");
                n = this.functions.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append("0 1 ");
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/BitsPerSample " + this.bitsPerSample);
            if (this.order == 1 || this.order == 3) {
                stringBuffer.append(" \n/Order " + this.order + " \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.range.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n = this.decode.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.decode.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.functionDataStream != null) {
                stringBuffer.append("/Length " + (this.functionDataStream.length() + 1) + " \n");
            }
            if (this.filter != null) {
                n = this.filter.size();
                stringBuffer.append("/Filter ");
                if (n == 1) {
                    stringBuffer.append("/" + (String)this.filter.get(0) + " \n");
                } else {
                    stringBuffer.append("[ ");
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append("/" + (String)this.filter.get(0) + " ");
                    }
                    stringBuffer.append("] \n");
                }
            }
            stringBuffer.append(">>");
            if (this.functionDataStream != null) {
                stringBuffer.append("\nstream\n" + this.functionDataStream + "\nendstream");
            }
        } else if (this.functionType == 2) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.range.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.cZero != null) {
                stringBuffer.append("/C0 [ ");
                n = this.cZero.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.cZero.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.cOne != null) {
                stringBuffer.append("/C1 [ ");
                n = this.cOne.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.cOne.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/N " + PDFNumber.doubleOut(new Double(this.interpolationExponentN)) + " \n");
            stringBuffer.append(">>");
        } else if (this.functionType == 3) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.range.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.functions != null) {
                stringBuffer.append("/Functions [ ");
                n2 = this.functions.size();
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(((PDFFunction)this.functions.get(n3)).referencePDF() + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.encode != null) {
                stringBuffer.append("/Encode [ ");
                n = this.encode.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.encode.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Encode [ ");
                n = this.functions.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append("0 1 ");
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/Bounds [ ");
            if (this.bounds != null) {
                n = this.bounds.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.bounds.get(n3)) + " ");
                }
            } else if (this.functions != null) {
                String string = PDFNumber.doubleOut(new Double(1.0 / (double)n2));
                n3 = 0;
                while (n3 + 1 < n2) {
                    stringBuffer.append(string + " ");
                    ++n3;
                }
                string = null;
            }
            stringBuffer.append("]\n>>");
        } else if (this.functionType == 4) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.range.get(n3)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.functionDataStream != null) {
                stringBuffer.append("/Length " + (this.functionDataStream.length() + 1) + " \n");
            }
            stringBuffer.append(">>");
            if (this.functionDataStream != null) {
                stringBuffer.append("\nstream\n{ " + this.functionDataStream + " }\nendstream");
            }
        }
        return PDFFunction.encode(stringBuffer.toString());
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (pDFObject == null) {
            return false;
        }
        if (pDFObject == this) {
            return true;
        }
        if (!(pDFObject instanceof PDFFunction)) {
            return false;
        }
        PDFFunction pDFFunction = (PDFFunction)pDFObject;
        if (this.functionType != pDFFunction.functionType) {
            return false;
        }
        if (this.bitsPerSample != pDFFunction.bitsPerSample) {
            return false;
        }
        if (this.order != pDFFunction.order) {
            return false;
        }
        if (this.interpolationExponentN != pDFFunction.interpolationExponentN) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(pDFFunction.domain) : pDFFunction.domain != null) {
            return false;
        }
        if (this.range != null ? !this.range.equals(pDFFunction.range) : pDFFunction.range != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(pDFFunction.size) : pDFFunction.size != null) {
            return false;
        }
        if (this.encode != null ? !this.encode.equals(pDFFunction.encode) : pDFFunction.encode != null) {
            return false;
        }
        if (this.decode != null ? !this.decode.equals(pDFFunction.decode) : pDFFunction.decode != null) {
            return false;
        }
        if (this.functionDataStream != null ? !this.functionDataStream.equals(pDFFunction.functionDataStream) : pDFFunction.functionDataStream != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(pDFFunction.filter) : pDFFunction.filter != null) {
            return false;
        }
        if (this.cZero != null ? !this.cZero.equals(pDFFunction.cZero) : pDFFunction.cZero != null) {
            return false;
        }
        if (this.cOne != null ? !this.cOne.equals(pDFFunction.cOne) : pDFFunction.cOne != null) {
            return false;
        }
        if (this.functions != null ? !this.functions.equals(pDFFunction.functions) : pDFFunction.functions != null) {
            return false;
        }
        return !(this.bounds != null ? !this.bounds.equals(pDFFunction.bounds) : pDFFunction.bounds != null);
    }
}

