/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Point2D;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFObject;

public class PDFGoTo
extends PDFAction {
    private String pageReference;
    private String destination = null;
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;

    public PDFGoTo(String string) {
        this.setPageReference(string);
    }

    public PDFGoTo(String string, Point2D point2D) {
        this(string);
        this.setPosition(point2D);
    }

    public void setPageReference(String string) {
        this.pageReference = string;
    }

    public void setPosition(Point2D point2D) {
        this.xPosition = (float)point2D.getX();
        this.yPosition = (float)point2D.getY();
    }

    public void setXPosition(float f) {
        this.xPosition = f;
    }

    public void setYPosition(float f) {
        this.yPosition = f;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        String string = this.destination == null ? "/D [" + this.pageReference + " /XYZ " + this.xPosition + " " + this.yPosition + " null]\n" : "/D [" + this.pageReference + " " + this.destination + "]\n";
        return "<< /Type /Action\n/S /GoTo\n" + string + ">>";
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (this == pDFObject) {
            return true;
        }
        if (pDFObject == null || !(pDFObject instanceof PDFGoTo)) {
            return false;
        }
        PDFGoTo pDFGoTo = (PDFGoTo)pDFObject;
        if (pDFGoTo.pageReference == null ? this.pageReference != null : !pDFGoTo.pageReference.equals(this.pageReference)) {
            return false;
        }
        return !(this.destination == null ? pDFGoTo.destination != null || pDFGoTo.xPosition != this.xPosition || pDFGoTo.yPosition != this.yPosition : !this.destination.equals(pDFGoTo.destination));
    }
}

