/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFStream;

public class PDFICCStream
extends PDFStream {
    private ICC_Profile cp = null;
    private PDFDeviceColorSpace pdfColorSpace;

    public void setColorSpace(ICC_Profile iCC_Profile, PDFDeviceColorSpace pDFDeviceColorSpace) {
        this.cp = iCC_Profile;
        this.pdfColorSpace = pDFDeviceColorSpace;
    }

    public ICC_Profile getICCProfile() {
        return this.cp;
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = super.output(outputStream);
        this.cp = null;
        return n;
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.cp.write(outputStream);
    }

    protected void populateStreamDict(Object object) {
        this.put("N", this.cp.getNumComponents());
        if (this.pdfColorSpace != null) {
            this.put("Alternate", new PDFName(this.pdfColorSpace.getName()));
        }
        super.populateStreamDict(object);
    }
}

