/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFXObject;

public class PDFImageXObject
extends PDFXObject {
    private PDFImage pdfimage;

    public PDFImageXObject(int n, PDFImage pDFImage) {
        this.put("Name", new PDFName("Im" + n));
        this.pdfimage = pDFImage;
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = super.output(outputStream);
        this.pdfimage = null;
        return n;
    }

    protected void populateStreamDict(Object object) {
        super.populateStreamDict(object);
        if (this.pdfimage.isPS()) {
            this.populateDictionaryFromPS();
        } else {
            this.populateDictionaryFromImage();
        }
    }

    private void populateDictionaryFromPS() {
        this.getDocumentSafely().getProfile().verifyPSXObjectsAllowed();
        this.put("Subtype", new PDFName("PS"));
    }

    private void populateDictionaryFromImage() {
        Object object;
        Object object2;
        this.put("Subtype", new PDFName("Image"));
        this.put("Width", new Integer(this.pdfimage.getWidth()));
        this.put("Height", new Integer(this.pdfimage.getHeight()));
        this.put("BitsPerComponent", new Integer(this.pdfimage.getBitsPerComponent()));
        PDFICCStream pDFICCStream = this.pdfimage.getICCStream();
        if (pDFICCStream != null) {
            this.put("ColorSpace", new PDFArray((PDFObject)this, new Object[]{new PDFName("ICCBased"), pDFICCStream}));
        } else {
            object2 = this.pdfimage.getColorSpace();
            this.put("ColorSpace", new PDFName(((PDFDeviceColorSpace)object2).getName()));
        }
        if (this.pdfimage.isInverted()) {
            object2 = new Float(0.0f);
            object = new Float(1.0f);
            PDFArray pDFArray = new PDFArray(this);
            int n = this.pdfimage.getColorSpace().getNumComponents();
            for (int i = 0; i < n; ++i) {
                pDFArray.add(object);
                pDFArray.add(object2);
            }
            this.put("Decode", pDFArray);
        }
        if (this.pdfimage.isTransparent()) {
            object2 = this.pdfimage.getTransparentColor();
            object = new PDFArray(this);
            if (this.pdfimage.getColorSpace().isGrayColorSpace()) {
                ((PDFArray)object).add(new Integer(((PDFColor)object2).red255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).red255()));
            } else {
                ((PDFArray)object).add(new Integer(((PDFColor)object2).red255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).red255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).green255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).green255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).blue255()));
                ((PDFArray)object).add(new Integer(((PDFColor)object2).blue255()));
            }
            this.put("Mask", object);
        }
        if ((object2 = this.pdfimage.getSoftMaskReference()) != null) {
            this.put("SMask", object2);
        }
        this.pdfimage.populateXObjectDictionary(this.getDictionary());
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.pdfimage.outputContents(outputStream);
    }

    protected int getSizeHint() throws IOException {
        return 0;
    }

    protected void prepareImplicitFilters() {
        PDFFilter pDFFilter = this.pdfimage.getPDFFilter();
        if (pDFFilter != null) {
            this.getFilterList().ensureFilterInPlace(pDFFilter);
        }
    }

    protected String getDefaultFilterName() {
        return this.pdfimage.getFilterHint();
    }

    protected boolean multipleFiltersAllowed() {
        return this.pdfimage.multipleFiltersAllowed();
    }
}

