/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFProfile;
import org.apache.xmlgraphics.util.DateFormatUtil;

public class PDFInfo
extends PDFObject {
    private String producer;
    private String title = null;
    private String author = null;
    private String subject = null;
    private String keywords = null;
    private Date creationDate = null;
    private Date modDate = null;
    private String creator;

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date date) {
        this.modDate = date;
    }

    public byte[] toPDF() {
        PDFProfile pDFProfile = this.getDocumentSafely().getProfile();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        try {
            byteArrayOutputStream.write(PDFInfo.encode("<<\n"));
            if (this.title != null && this.title.length() > 0) {
                byteArrayOutputStream.write(PDFInfo.encode("/Title "));
                byteArrayOutputStream.write(this.encodeText(this.title));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            } else {
                pDFProfile.verifyTitleAbsent();
            }
            if (this.author != null) {
                byteArrayOutputStream.write(PDFInfo.encode("/Author "));
                byteArrayOutputStream.write(this.encodeText(this.author));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            if (this.subject != null) {
                byteArrayOutputStream.write(PDFInfo.encode("/Subject "));
                byteArrayOutputStream.write(this.encodeText(this.subject));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            if (this.keywords != null) {
                byteArrayOutputStream.write(PDFInfo.encode("/Keywords "));
                byteArrayOutputStream.write(this.encodeText(this.keywords));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            if (this.creator != null) {
                byteArrayOutputStream.write(PDFInfo.encode("/Creator "));
                byteArrayOutputStream.write(this.encodeText(this.creator));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            byteArrayOutputStream.write(PDFInfo.encode("/Producer "));
            byteArrayOutputStream.write(this.encodeText(this.producer));
            byteArrayOutputStream.write(PDFInfo.encode("\n"));
            if (this.creationDate == null) {
                this.creationDate = new Date();
            }
            byteArrayOutputStream.write(PDFInfo.encode("/CreationDate "));
            byteArrayOutputStream.write(this.encodeString(PDFInfo.formatDateTime(this.creationDate)));
            byteArrayOutputStream.write(PDFInfo.encode("\n"));
            if (pDFProfile.isModDateRequired() && this.modDate == null) {
                this.modDate = this.creationDate;
            }
            if (this.modDate != null) {
                byteArrayOutputStream.write(PDFInfo.encode("/ModDate "));
                byteArrayOutputStream.write(this.encodeString(PDFInfo.formatDateTime(this.modDate)));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            if (pDFProfile.isPDFXActive()) {
                byteArrayOutputStream.write(PDFInfo.encode("/GTS_PDFXVersion "));
                byteArrayOutputStream.write(this.encodeString(pDFProfile.getPDFXMode().getName()));
                byteArrayOutputStream.write(PDFInfo.encode("\n"));
            }
            if (pDFProfile.isTrappedEntryRequired()) {
                byteArrayOutputStream.write(PDFInfo.encode("/Trapped /False\n"));
            }
            byteArrayOutputStream.write(PDFInfo.encode(">>"));
        }
        catch (IOException iOException) {
            log.error((Object)"Ignored I/O exception", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static String formatDateTime(Date date, TimeZone timeZone) {
        return DateFormatUtil.formatPDFDate((Date)date, (TimeZone)timeZone);
    }

    protected static String formatDateTime(Date date) {
        return PDFInfo.formatDateTime(date, TimeZone.getDefault());
    }
}

