/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFProfile;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPSerializer;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreAdapter;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreSchema;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;
import org.apache.xmlgraphics.xmp.schemas.pdf.AdobePDFAdapter;
import org.apache.xmlgraphics.xmp.schemas.pdf.AdobePDFSchema;
import org.apache.xmlgraphics.xmp.schemas.pdf.PDFAAdapter;
import org.apache.xmlgraphics.xmp.schemas.pdf.PDFAXMPSchema;
import org.xml.sax.SAXException;

public class PDFMetadata
extends PDFStream {
    private Metadata xmpMetadata;
    private boolean readOnly = true;

    public PDFMetadata(Metadata metadata, boolean bl) {
        if (metadata == null) {
            throw new NullPointerException("The parameter for the XMP Document must not be null");
        }
        this.xmpMetadata = metadata;
        this.readOnly = bl;
    }

    protected String getDefaultFilterName() {
        return "metadata";
    }

    public Metadata getMetadata() {
        return this.xmpMetadata;
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = super.output(outputStream);
        this.xmpMetadata = null;
        return n;
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        try {
            XMPSerializer.writeXMPPacket((Metadata)this.xmpMetadata, (OutputStream)outputStream, (boolean)this.readOnly);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("Error setting up Transformer for XMP stream serialization: " + transformerConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException("Error while serializing XMP stream: " + sAXException.getMessage());
        }
    }

    protected void populateStreamDict(Object object) {
        String string = this.getFilterList().buildFilterDictEntries();
        if (this.getDocumentSafely().getProfile().getPDFAMode().isPDFA1LevelB() && string != null && string.length() > 0) {
            throw new PDFConformanceException("The Filter key is prohibited when PDF/A-1 is active");
        }
        this.put("Type", new PDFName("Metadata"));
        this.put("Subtype", new PDFName("XML"));
        super.populateStreamDict(object);
    }

    public static Metadata createXMPFromPDFDocument(PDFDocument pDFDocument) {
        PDFAAdapter pDFAAdapter;
        Object object;
        Metadata metadata = new Metadata();
        PDFInfo pDFInfo = pDFDocument.getInfo();
        PDFRoot pDFRoot = pDFDocument.getRoot();
        if (pDFInfo.getCreationDate() == null) {
            object = new Date();
            pDFInfo.setCreationDate((Date)object);
        }
        object = DublinCoreSchema.getAdapter((Metadata)metadata);
        if (pDFInfo.getAuthor() != null) {
            object.addCreator(pDFInfo.getAuthor());
        }
        if (pDFInfo.getTitle() != null) {
            object.setTitle(pDFInfo.getTitle());
        }
        if (pDFInfo.getSubject() != null) {
            object.setDescription(null, pDFInfo.getSubject());
        }
        if (pDFRoot.getLanguage() != null) {
            object.addLanguage(pDFRoot.getLanguage());
        }
        object.addDate(pDFInfo.getCreationDate());
        object.setFormat("application/pdf");
        PDFAMode pDFAMode = pDFDocument.getProfile().getPDFAMode();
        if (pDFAMode.isPDFA1LevelB()) {
            pDFAAdapter = PDFAXMPSchema.getAdapter((Metadata)metadata);
            pDFAAdapter.setPart(1);
            if (pDFAMode == PDFAMode.PDFA_1A) {
                pDFAAdapter.setConformance("A");
            } else {
                pDFAAdapter.setConformance("B");
            }
        }
        pDFAAdapter = XMPBasicSchema.getAdapter((Metadata)metadata);
        pDFAAdapter.setCreateDate(pDFInfo.getCreationDate());
        PDFProfile pDFProfile = pDFDocument.getProfile();
        if (pDFInfo.getModDate() != null) {
            pDFAAdapter.setModifyDate(pDFInfo.getModDate());
        } else if (pDFProfile.isModDateRequired()) {
            pDFAAdapter.setModifyDate(pDFInfo.getCreationDate());
        }
        if (pDFInfo.getCreator() != null) {
            pDFAAdapter.setCreatorTool(pDFInfo.getCreator());
        }
        AdobePDFAdapter adobePDFAdapter = AdobePDFSchema.getAdapter((Metadata)metadata);
        if (pDFInfo.getKeywords() != null) {
            adobePDFAdapter.setKeywords(pDFInfo.getKeywords());
        }
        if (pDFInfo.getProducer() != null) {
            adobePDFAdapter.setProducer(pDFInfo.getProducer());
        }
        adobePDFAdapter.setPDFVersion(pDFDocument.getPDFVersionString());
        return metadata;
    }

    public static void updateInfoFromMetadata(Metadata metadata, PDFInfo pDFInfo) {
        DublinCoreAdapter dublinCoreAdapter = DublinCoreSchema.getAdapter((Metadata)metadata);
        pDFInfo.setTitle(dublinCoreAdapter.getTitle());
        String[] stringArray = dublinCoreAdapter.getCreators();
        if (stringArray != null && stringArray.length > 0) {
            pDFInfo.setAuthor(stringArray[0]);
        } else {
            pDFInfo.setAuthor(null);
        }
        pDFInfo.setSubject(dublinCoreAdapter.getDescription());
        AdobePDFAdapter adobePDFAdapter = AdobePDFSchema.getAdapter((Metadata)metadata);
        pDFInfo.setKeywords(adobePDFAdapter.getKeywords());
        pDFInfo.setProducer(adobePDFAdapter.getProducer());
        XMPBasicAdapter xMPBasicAdapter = XMPBasicSchema.getAdapter((Metadata)metadata);
        pDFInfo.setCreator(xMPBasicAdapter.getCreatorTool());
        Date date = xMPBasicAdapter.getCreateDate();
        xMPBasicAdapter.setCreateDate(date);
        pDFInfo.setCreationDate(date);
        date = xMPBasicAdapter.getModifyDate();
        if (date != null) {
            xMPBasicAdapter.setModifyDate(date);
            pDFInfo.setModDate(date);
        }
    }
}

