/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFNumsArray;
import org.apache.fop.pdf.PDFObject;

public class PDFNumberTreeNode
extends PDFDictionary {
    private static final String KIDS = "Kids";
    private static final String NUMS = "Nums";
    private static final String LIMITS = "Limits";

    public void setKids(PDFArray pDFArray) {
        this.put(KIDS, pDFArray);
    }

    public PDFArray getKids() {
        return (PDFArray)this.get(KIDS);
    }

    public void setNums(PDFNumsArray pDFNumsArray) {
        this.put(NUMS, pDFNumsArray);
    }

    public PDFNumsArray getNums() {
        return (PDFNumsArray)this.get(NUMS);
    }

    public void setLowerLimit(Integer n) {
        PDFArray pDFArray = this.prepareLimitsArray();
        pDFArray.set(0, n);
    }

    public Integer getLowerLimit() {
        PDFArray pDFArray = this.prepareLimitsArray();
        return (Integer)pDFArray.get(0);
    }

    public void setUpperLimit(Integer n) {
        PDFArray pDFArray = this.prepareLimitsArray();
        pDFArray.set(1, n);
    }

    public Integer getUpperLimit() {
        PDFArray pDFArray = this.prepareLimitsArray();
        return (Integer)pDFArray.get(1);
    }

    private PDFArray prepareLimitsArray() {
        PDFArray pDFArray = (PDFArray)this.get(LIMITS);
        if (pDFArray == null) {
            pDFArray = new PDFArray((PDFObject)this, new Object[2]);
            this.put(LIMITS, pDFArray);
        }
        if (pDFArray.length() != 2) {
            throw new IllegalStateException("Limits array must have 2 entries");
        }
        return pDFArray;
    }
}

