/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.text.MessageFormat;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;

public class PDFProfile {
    protected PDFAMode pdfAMode = PDFAMode.DISABLED;
    protected PDFXMode pdfXMode = PDFXMode.DISABLED;
    private PDFDocument doc;

    public PDFProfile(PDFDocument pDFDocument) {
        this.doc = pDFDocument;
    }

    protected void validateProfileCombination() {
        if (this.pdfAMode != PDFAMode.DISABLED && this.pdfAMode == PDFAMode.PDFA_1B && this.pdfXMode != PDFXMode.DISABLED && this.pdfXMode != PDFXMode.PDFX_3_2003) {
            throw new PDFConformanceException(this.pdfAMode + " and " + this.pdfXMode + " are not compatible!");
        }
    }

    public PDFDocument getDocument() {
        return this.doc;
    }

    public PDFAMode getPDFAMode() {
        return this.pdfAMode;
    }

    public boolean isPDFAActive() {
        return this.getPDFAMode() != PDFAMode.DISABLED;
    }

    public void setPDFAMode(PDFAMode pDFAMode) {
        if (pDFAMode == null) {
            pDFAMode = PDFAMode.DISABLED;
        }
        this.pdfAMode = pDFAMode;
        this.validateProfileCombination();
    }

    public PDFXMode getPDFXMode() {
        return this.pdfXMode;
    }

    public boolean isPDFXActive() {
        return this.getPDFXMode() != PDFXMode.DISABLED;
    }

    public void setPDFXMode(PDFXMode pDFXMode) {
        if (pDFXMode == null) {
            pDFXMode = PDFXMode.DISABLED;
        }
        this.pdfXMode = pDFXMode;
        this.validateProfileCombination();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPDFAActive() && this.isPDFXActive()) {
            stringBuffer.append("[").append(this.getPDFAMode()).append(",").append(this.getPDFXMode()).append("]");
        } else if (this.isPDFAActive()) {
            stringBuffer.append(this.getPDFAMode());
        } else if (this.isPDFXActive()) {
            stringBuffer.append(this.getPDFXMode());
        } else {
            stringBuffer.append(super.toString());
        }
        return stringBuffer.toString();
    }

    private String format(String string, Object[] objectArray) {
        return MessageFormat.format(string, objectArray);
    }

    private String format(String string, Object object) {
        return this.format(string, new Object[]{object});
    }

    public void verifyEncryptionAllowed() {
        if (this.isPDFAActive()) {
            throw new PDFConformanceException(this.format("{0} doesn't allow encrypted PDFs", this.getPDFAMode()));
        }
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(this.format("{0} doesn't allow encrypted PDFs", this.getPDFXMode()));
        }
    }

    public void verifyPSXObjectsAllowed() {
        if (this.isPDFAActive()) {
            throw new PDFConformanceException(this.format("PostScript XObjects are prohibited when {0} is active. Convert EPS graphics to another format.", this.getPDFAMode()));
        }
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(this.format("PostScript XObjects are prohibited when {0} is active. Convert EPS graphics to another format.", this.getPDFXMode()));
        }
    }

    public void verifyTransparencyAllowed(String string) {
        if (this.isPDFAActive()) {
            throw new PDFConformanceException(MessageFormat.format("{0} does not allow the use of transparency. ({1})", this.getPDFAMode(), string));
        }
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(MessageFormat.format("{0} does not allow the use of transparency. ({1})", this.getPDFXMode(), string));
        }
    }

    public void verifyPDFVersion() {
        if (this.getPDFAMode().isPDFA1LevelB() && !Version.V1_4.equals((Object)this.getDocument().getPDFVersion())) {
            throw new PDFConformanceException(this.format("PDF version must be 1.4 for {0}", this.getPDFAMode()));
        }
        if (this.getPDFXMode() == PDFXMode.PDFX_3_2003 && !Version.V1_4.equals((Object)this.getDocument().getPDFVersion())) {
            throw new PDFConformanceException(this.format("PDF version must be 1.4 for {0}", this.getPDFXMode()));
        }
    }

    public void verifyTaggedPDF() {
        if (this.getPDFAMode().isPDFA1LevelA()) {
            PDFDictionary pDFDictionary = this.getDocument().getRoot().getMarkInfo();
            if (pDFDictionary == null) {
                throw new PDFConformanceException(this.format("{0} requires the MarkInfo dictionary to be present", this.getPDFAMode()));
            }
            if (!Boolean.TRUE.equals(pDFDictionary.get("Marked"))) {
                throw new PDFConformanceException(this.format("{0} requires the {1} dictionary entry to be set", new Object[]{this.getPDFAMode(), "Marked"}));
            }
            if (this.getDocument().getRoot().getStructTreeRoot() == null) {
                throw new PDFConformanceException(this.format("{0} requires the {1} dictionary entry to be set", new Object[]{this.getPDFAMode(), "StructTreeRoot"}));
            }
            if (this.getDocument().getRoot().getLanguage() == null) {
                throw new PDFConformanceException(this.format("{0} requires the {1} dictionary entry to be set", new Object[]{this.getPDFAMode(), "Lang"}));
            }
        }
    }

    public boolean isIDEntryRequired() {
        return this.isPDFAActive() || this.isPDFXActive();
    }

    public boolean isFontEmbeddingRequired() {
        return this.isPDFAActive() || this.isPDFXActive();
    }

    public void verifyTitleAbsent() {
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(this.format("{0} requires the title to be set.", this.getPDFXMode()));
        }
    }

    public boolean isModDateRequired() {
        return this.getPDFXMode() == PDFXMode.PDFX_3_2003;
    }

    public boolean isTrappedEntryRequired() {
        return this.getPDFXMode() == PDFXMode.PDFX_3_2003;
    }

    public boolean isAnnotationAllowed() {
        return !this.isPDFXActive();
    }

    public void verifyAnnotAllowed() {
        if (!this.isAnnotationAllowed()) {
            throw new PDFConformanceException(this.format("{0} does not allow annotations inside the printable area.", this.getPDFXMode()));
        }
    }

    public void verifyActionAllowed() {
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(this.format("{0} does not allow Actions.", this.getPDFXMode()));
        }
    }

    public void verifyEmbeddedFilesAllowed() {
        if (this.isPDFAActive()) {
            throw new PDFConformanceException(this.format("{0} does not allow embedded files.", this.getPDFAMode()));
        }
        if (this.isPDFXActive()) {
            throw new PDFConformanceException(this.format("{0} does not allow embedded files.", this.getPDFXMode()));
        }
    }
}

