/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.pdf.AbstractPDFFontStream;

public class PDFT1Stream
extends AbstractPDFFontStream {
    private PFBData pfb;

    protected int getSizeHint() throws IOException {
        if (this.pfb != null) {
            return this.pfb.getLength();
        }
        return 0;
    }

    public int output(OutputStream outputStream) throws IOException {
        if (this.pfb == null) {
            throw new IllegalStateException("pfb must not be null at this point");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing " + this.pfb.getLength() + " bytes of Type 1 font data"));
        }
        int n = super.output(outputStream);
        log.debug((Object)"Embedded Type1 font");
        return n;
    }

    protected void populateStreamDict(Object object) {
        super.populateStreamDict(object);
        this.put("Length1", new Integer(this.pfb.getLength1()));
        this.put("Length2", new Integer(this.pfb.getLength2()));
        this.put("Length3", new Integer(this.pfb.getLength3()));
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.pfb.outputAllParts(outputStream);
    }

    public void setData(PFBData pFBData) throws IOException {
        this.pfb = pFBData;
    }
}

