/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.util.Service;

public class ImageHandlerRegistry {
    private static Log log = LogFactory.getLog(ImageHandlerRegistry.class);
    private static final Comparator<ImageHandler> HANDLER_COMPARATOR = new Comparator<ImageHandler>(){

        @Override
        public int compare(ImageHandler imageHandler, ImageHandler imageHandler2) {
            ImageHandler imageHandler3 = imageHandler;
            ImageHandler imageHandler4 = imageHandler2;
            return imageHandler3.getPriority() - imageHandler4.getPriority();
        }
    };
    private Map<Class<? extends Image>, ImageHandler> handlers = new HashMap<Class<? extends Image>, ImageHandler>();
    private List<ImageHandler> handlerList = new LinkedList<ImageHandler>();
    private int handlerRegistrations;

    public ImageHandlerRegistry() {
        this.discoverHandlers();
    }

    public void addHandler(String string) {
        try {
            ImageHandler imageHandler = (ImageHandler)Class.forName(string).newInstance();
            this.addHandler(imageHandler);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + ImageHandler.class.getName());
        }
    }

    public synchronized void addHandler(ImageHandler imageHandler) {
        Class clazz = imageHandler.getSupportedImageClass();
        this.handlers.put(clazz, imageHandler);
        ListIterator<ImageHandler> listIterator = this.handlerList.listIterator();
        while (listIterator.hasNext()) {
            ImageHandler imageHandler2 = listIterator.next();
            if (HANDLER_COMPARATOR.compare(imageHandler, imageHandler2) >= 0) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(imageHandler);
        ++this.handlerRegistrations;
    }

    public ImageHandler getHandler(RenderingContext renderingContext, Image image) {
        for (ImageHandler imageHandler : this.handlerList) {
            if (!imageHandler.isCompatible(renderingContext, image)) continue;
            return imageHandler;
        }
        return null;
    }

    public synchronized ImageFlavor[] getSupportedFlavors(RenderingContext renderingContext) {
        ArrayList<ImageFlavor> arrayList = new ArrayList<ImageFlavor>();
        for (ImageHandler imageHandler : this.handlerList) {
            if (!imageHandler.isCompatible(renderingContext, null)) continue;
            ImageFlavor[] imageFlavorArray = imageHandler.getSupportedImageFlavors();
            for (int i = 0; i < imageFlavorArray.length; ++i) {
                arrayList.add(imageFlavorArray[i]);
            }
        }
        return arrayList.toArray(new ImageFlavor[arrayList.size()]);
    }

    private void discoverHandlers() {
        Iterator iterator = Service.providers(ImageHandler.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ImageHandler imageHandler = (ImageHandler)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding ImageHandler: " + imageHandler.getClass().getName()));
                    }
                    this.addHandler(imageHandler);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding ImageHandler", (Throwable)illegalArgumentException);
                }
            }
        }
    }
}

