/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.RendererContext;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrintRenderer
extends AbstractRenderer {
    protected FontInfo fontInfo;
    protected FontResolver fontResolver = null;
    protected List<EmbedFontInfo> embedFontInfoList = null;

    public PrintRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public void addFontList(List<EmbedFontInfo> list) {
        if (this.embedFontInfoList == null) {
            this.setFontList(list);
        } else {
            this.embedFontInfoList.addAll(list);
        }
    }

    public void setFontList(List<EmbedFontInfo> list) {
        this.embedFontInfoList = list;
    }

    public List<EmbedFontInfo> getFontList() {
        return this.embedFontInfoList;
    }

    @Override
    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        this.fontInfo = fontInfo;
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        FontCollection[] fontCollectionArray = new FontCollection[]{new Base14FontCollection(fontManager.isBase14KerningEnabled()), new CustomFontCollection(this.getFontResolver(), this.getFontList(), this.userAgent.isComplexScriptFeaturesEnabled())};
        fontManager.setup(this.getFontInfo(), fontCollectionArray);
    }

    protected String getInternalFontNameForArea(Area area) {
        FontTriplet fontTriplet = (FontTriplet)area.getTrait(Trait.FONT);
        String string = this.fontInfo.getInternalFontKey(fontTriplet);
        if (string == null) {
            fontTriplet = new FontTriplet("any", "normal", 400);
            string = this.fontInfo.getInternalFontKey(fontTriplet);
        }
        return string;
    }

    protected Font getFontFromArea(Area area) {
        FontTriplet fontTriplet = (FontTriplet)area.getTrait(Trait.FONT);
        int n = (Integer)area.getTrait(Trait.FONT_SIZE);
        return this.fontInfo.getFontInstance(fontTriplet, n);
    }

    protected RendererContext instantiateRendererContext() {
        return new RendererContext(this, this.getMimeType());
    }

    protected RendererContext createRendererContext(int n, int n2, int n3, int n4, Map map) {
        RendererContext rendererContext = this.instantiateRendererContext();
        rendererContext.setUserAgent(this.userAgent);
        rendererContext.setProperty("width", new Integer(n3));
        rendererContext.setProperty("height", new Integer(n4));
        rendererContext.setProperty("xpos", new Integer(n));
        rendererContext.setProperty("ypos", new Integer(n2));
        rendererContext.setProperty("pageViewport", this.getCurrentPageViewport());
        if (map != null) {
            rendererContext.setProperty("foreign-attributes", map);
        }
        return rendererContext;
    }

    public void renderDocument(Document document, String string, Rectangle2D rectangle2D, Map map) {
        int n = this.currentIPPosition + (int)rectangle2D.getX();
        int n2 = this.currentBPPosition + (int)rectangle2D.getY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        RendererContext rendererContext = this.createRendererContext(n, n2, n3, n4, map);
        this.renderXML(rendererContext, document, string);
    }

    public FontResolver getFontResolver() {
        if (this.fontResolver == null) {
            this.fontResolver = new DefaultFontResolver(this.userAgent);
        }
        return this.fontResolver;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }
}

