/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFPImageHandlerRawJPEG
extends AFPImageHandler
implements ImageHandler {
    private final Log log = LogFactory.getLog(AFPImageHandlerRawJPEG.class);

    private void setDefaultResourceLevel(AFPImageObjectInfo aFPImageObjectInfo, AFPResourceManager aFPResourceManager) {
        AFPResourceInfo aFPResourceInfo = aFPImageObjectInfo.getResourceInfo();
        if (!aFPResourceInfo.levelChanged()) {
            aFPResourceInfo.setLevel(aFPResourceManager.getResourceLevelDefaults().getDefaultResourceLevel((byte)6));
        }
    }

    @Override
    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPImageObjectInfo();
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public Class<?> getSupportedImageClass() {
        return ImageRawJPEG.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.RAW_JPEG};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        AFPImageObjectInfo aFPImageObjectInfo = (AFPImageObjectInfo)this.createDataObjectInfo();
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        this.setResourceInformation(aFPImageObjectInfo, image.getInfo().getOriginalURI(), aFPRenderingContext.getForeignAttributes());
        this.setDefaultResourceLevel(aFPImageObjectInfo, aFPRenderingContext.getResourceManager());
        aFPImageObjectInfo.setObjectAreaInfo(AFPImageHandlerRawJPEG.createObjectAreaInfo(aFPPaintingState, rectangle));
        this.updateIntrinsicSize(aFPImageObjectInfo, aFPPaintingState, image.getSize());
        ImageRawJPEG imageRawJPEG = (ImageRawJPEG)image;
        aFPImageObjectInfo.setCompression(-125);
        ColorSpace colorSpace = imageRawJPEG.getColorSpace();
        switch (colorSpace.getType()) {
            case 6: {
                aFPImageObjectInfo.setMimeType("image/x-afp+fs11");
                aFPImageObjectInfo.setColor(false);
                aFPImageObjectInfo.setBitsPerPixel(8);
                break;
            }
            case 5: {
                aFPImageObjectInfo.setMimeType("image/x-afp+fs11");
                aFPImageObjectInfo.setColor(true);
                aFPImageObjectInfo.setBitsPerPixel(24);
                break;
            }
            case 9: {
                aFPImageObjectInfo.setMimeType("image/x-afp+fs45");
                aFPImageObjectInfo.setColor(true);
                aFPImageObjectInfo.setBitsPerPixel(32);
                break;
            }
            default: {
                throw new IllegalStateException("Color space of JPEG image not supported: " + colorSpace);
            }
        }
        boolean bl = aFPRenderingContext.getResourceManager().tryIncludeObject(aFPImageObjectInfo);
        if (!bl) {
            this.log.debug((Object)"Embedding undecoded JPEG as IOCA image...");
            InputStream inputStream = imageRawJPEG.createInputStream();
            try {
                aFPImageObjectInfo.setData(IOUtils.toByteArray((InputStream)inputStream));
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            aFPRenderingContext.getResourceManager().createObject(aFPImageObjectInfo);
        }
    }

    private void updateIntrinsicSize(AFPImageObjectInfo aFPImageObjectInfo, AFPPaintingState aFPPaintingState, ImageSize imageSize) {
        aFPImageObjectInfo.setDataHeightRes((int)Math.round(imageSize.getDpiHorizontal() * 10.0));
        aFPImageObjectInfo.setDataWidthRes((int)Math.round(imageSize.getDpiVertical() * 10.0));
        aFPImageObjectInfo.setDataHeight(imageSize.getHeightPx());
        aFPImageObjectInfo.setDataWidth(imageSize.getWidthPx());
        int n = aFPPaintingState.getResolution();
        AFPObjectAreaInfo aFPObjectAreaInfo = aFPImageObjectInfo.getObjectAreaInfo();
        aFPObjectAreaInfo.setResolution(n);
    }

    @Override
    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        if (!(renderingContext instanceof AFPRenderingContext)) {
            return false;
        }
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        if (!aFPPaintingState.canEmbedJpeg()) {
            return false;
        }
        if (aFPPaintingState.getBitsPerPixel() < 8) {
            return false;
        }
        if (image == null) {
            return true;
        }
        if (image instanceof ImageRawJPEG) {
            ImageRawJPEG imageRawJPEG = (ImageRawJPEG)image;
            ColorSpace colorSpace = imageRawJPEG.getColorSpace();
            switch (colorSpace.getType()) {
                case 5: 
                case 6: {
                    break;
                }
                case 9: {
                    if (aFPPaintingState.isCMYKImagesSupported()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return imageRawJPEG.getSOFType() == 192;
        }
        return false;
    }
}

