/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.util.bitmap.BitmapImageUtil;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.util.UnitConv;

public class AFPImageHandlerRenderedImage
extends AFPImageHandler
implements ImageHandler {
    private static Log log = LogFactory.getLog(AFPImageHandlerRenderedImage.class);
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};

    private void setDefaultResourceLevel(AFPImageObjectInfo aFPImageObjectInfo, AFPResourceManager aFPResourceManager) {
        AFPResourceInfo aFPResourceInfo = aFPImageObjectInfo.getResourceInfo();
        if (!aFPResourceInfo.levelChanged()) {
            aFPResourceInfo.setLevel(aFPResourceManager.getResourceLevelDefaults().getDefaultResourceLevel((byte)6));
        }
    }

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPImageObjectInfo();
    }

    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        AFPImageObjectInfo aFPImageObjectInfo = (AFPImageObjectInfo)this.createDataObjectInfo();
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        this.setResourceInformation(aFPImageObjectInfo, image.getInfo().getOriginalURI(), aFPRenderingContext.getForeignAttributes());
        this.setDefaultResourceLevel(aFPImageObjectInfo, aFPRenderingContext.getResourceManager());
        aFPImageObjectInfo.setObjectAreaInfo(AFPImageHandlerRenderedImage.createObjectAreaInfo(aFPPaintingState, rectangle));
        Dimension dimension = rectangle.getSize();
        ImageRendered imageRendered = (ImageRendered)image;
        RenderedImageEncoder renderedImageEncoder = new RenderedImageEncoder(imageRendered, dimension);
        renderedImageEncoder.prepareEncoding(aFPImageObjectInfo, aFPPaintingState);
        boolean bl = aFPRenderingContext.getResourceManager().tryIncludeObject(aFPImageObjectInfo);
        if (!bl) {
            long l = System.currentTimeMillis();
            renderedImageEncoder.encodeImage(aFPImageObjectInfo, aFPPaintingState);
            if (log.isDebugEnabled()) {
                long l2 = System.currentTimeMillis() - l;
                log.debug((Object)("Image encoding took " + l2 + "ms."));
            }
            aFPRenderingContext.getResourceManager().createObject(aFPImageObjectInfo);
        }
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof ImageRendered) && renderingContext instanceof AFPRenderingContext;
    }

    private static final class RenderedImageEncoder {
        private ImageRendered imageRendered;
        private Dimension targetSize;
        private boolean useFS10;
        private int maxPixelSize;
        private boolean usePageSegments;
        private boolean resample;
        private Dimension resampledDim;
        private ImageSize intrinsicSize;
        private ImageSize effIntrinsicSize;

        private RenderedImageEncoder(ImageRendered imageRendered, Dimension dimension) {
            this.imageRendered = imageRendered;
            this.targetSize = dimension;
        }

        private void prepareEncoding(AFPImageObjectInfo aFPImageObjectInfo, AFPPaintingState aFPPaintingState) {
            int n;
            this.maxPixelSize = aFPPaintingState.getBitsPerPixel();
            if (aFPPaintingState.isColorImages()) {
                this.maxPixelSize = aFPPaintingState.isCMYKImagesSupported() ? (this.maxPixelSize *= 4) : (this.maxPixelSize *= 3);
            }
            RenderedImage renderedImage = this.imageRendered.getRenderedImage();
            this.useFS10 = this.maxPixelSize == 1 || BitmapImageUtil.isMonochromeImage(renderedImage);
            ImageInfo imageInfo = this.imageRendered.getInfo();
            this.effIntrinsicSize = this.intrinsicSize = imageInfo.getSize();
            AFPResourceInfo aFPResourceInfo = aFPImageObjectInfo.getResourceInfo();
            boolean bl = this.usePageSegments = this.useFS10 && !aFPResourceInfo.getLevel().isInline();
            if (this.usePageSegments) {
                n = aFPPaintingState.getResolution();
                this.resampledDim = new Dimension((int)Math.ceil(UnitConv.mpt2px((double)this.targetSize.getWidth(), (int)n)), (int)Math.ceil(UnitConv.mpt2px((double)this.targetSize.getHeight(), (int)n)));
                aFPResourceInfo.setImageDimension(this.resampledDim);
                boolean bl2 = this.resample = this.resampledDim.width < renderedImage.getWidth() && this.resampledDim.height < renderedImage.getHeight();
                if (this.resample) {
                    this.effIntrinsicSize = new ImageSize(this.resampledDim.width, this.resampledDim.height, (double)n);
                }
            }
            aFPImageObjectInfo.setDataHeightRes((int)Math.round(this.effIntrinsicSize.getDpiHorizontal() * 10.0));
            aFPImageObjectInfo.setDataWidthRes((int)Math.round(this.effIntrinsicSize.getDpiVertical() * 10.0));
            aFPImageObjectInfo.setDataHeight(this.effIntrinsicSize.getHeightPx());
            aFPImageObjectInfo.setDataWidth(this.effIntrinsicSize.getWidthPx());
            n = aFPPaintingState.getResolution();
            AFPObjectAreaInfo aFPObjectAreaInfo = aFPImageObjectInfo.getObjectAreaInfo();
            aFPObjectAreaInfo.setWidthRes(n);
            aFPObjectAreaInfo.setHeightRes(n);
        }

        private AFPDataObjectInfo encodeImage(AFPImageObjectInfo aFPImageObjectInfo, AFPPaintingState aFPPaintingState) throws IOException {
            FunctionSet functionSet;
            RenderedImage renderedImage = this.imageRendered.getRenderedImage();
            FunctionSet functionSet2 = functionSet = this.useFS10 ? FunctionSet.FS10 : FunctionSet.FS11;
            if (this.usePageSegments) {
                assert (this.resampledDim != null);
                aFPImageObjectInfo.setCreatePageSegment(true);
                float f = aFPPaintingState.getDitheringQuality();
                if (this.resample) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resample from " + this.intrinsicSize.getDimensionPx() + " to " + this.resampledDim));
                    }
                    renderedImage = BitmapImageUtil.convertToMonochrome(renderedImage, this.resampledDim, f);
                } else if (f >= 0.5f) {
                    renderedImage = BitmapImageUtil.convertToMonochrome(renderedImage, this.intrinsicSize.getDimensionPx(), f);
                }
            }
            ColorModel colorModel = renderedImage.getColorModel();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ColorModel: " + colorModel));
            }
            int n = colorModel.getPixelSize();
            if (colorModel.hasAlpha()) {
                n -= 8;
            }
            byte[] byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = true;
            if (bl && n <= this.maxPixelSize) {
                ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage, n == 32);
                ColorModel colorModel2 = imageEncodingHelper.getEncodedColorModel();
                boolean bl2 = true;
                if (imageEncodingHelper.getEncodedColorModel().getPixelSize() > this.maxPixelSize) {
                    bl2 = false;
                }
                if (BitmapImageUtil.getColorIndexSize(renderedImage) > 2) {
                    bl2 = false;
                }
                if (this.useFS10 && BitmapImageUtil.isMonochromeImage(renderedImage) && BitmapImageUtil.isZeroBlack(renderedImage)) {
                    bl2 = false;
                    if (this.encodeInvertedBilevel(imageEncodingHelper, aFPImageObjectInfo, byteArrayOutputStream)) {
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                }
                if (bl2) {
                    log.debug((Object)"Encoding image directly...");
                    aFPImageObjectInfo.setBitsPerPixel(colorModel2.getPixelSize());
                    if (n == 32) {
                        functionSet = FunctionSet.FS45;
                    }
                    if (!aFPPaintingState.canEmbedJpeg() && aFPPaintingState.getBitmapEncodingQuality() < 1.0f) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Encoding using baseline DCT (JPEG, q=" + aFPPaintingState.getBitmapEncodingQuality() + ")..."));
                            }
                            this.encodeToBaselineDCT(renderedImage, aFPPaintingState.getBitmapEncodingQuality(), aFPPaintingState.getResolution(), byteArrayOutputStream);
                            aFPImageObjectInfo.setCompression(-125);
                        }
                        catch (IOException iOException) {
                            imageEncodingHelper.encode((OutputStream)byteArrayOutputStream);
                        }
                    } else {
                        imageEncodingHelper.encode((OutputStream)byteArrayOutputStream);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
            }
            if (byArray == null) {
                log.debug((Object)"Encoding image via RGB...");
                byArray = this.encodeViaRGB(renderedImage, aFPImageObjectInfo, aFPPaintingState, byteArrayOutputStream);
            }
            if (aFPPaintingState.getFS45()) {
                functionSet = FunctionSet.FS45;
            }
            aFPImageObjectInfo.setCreatePageSegment((functionSet.equals((Object)FunctionSet.FS11) || functionSet.equals((Object)FunctionSet.FS45)) && aFPPaintingState.getWrapPSeg());
            aFPImageObjectInfo.setMimeType(functionSet.getMimeType());
            aFPImageObjectInfo.setData(byArray);
            return aFPImageObjectInfo;
        }

        private byte[] encodeViaRGB(RenderedImage renderedImage, AFPImageObjectInfo aFPImageObjectInfo, AFPPaintingState aFPPaintingState, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            ImageEncodingHelper.encodeRenderedImageAsRGB((RenderedImage)renderedImage, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            aFPImageObjectInfo.setBitsPerPixel(24);
            boolean bl = aFPPaintingState.isColorImages();
            aFPImageObjectInfo.setColor(bl);
            if (!bl) {
                log.debug((Object)"Converting RGB image to grayscale...");
                byteArrayOutputStream.reset();
                int n = aFPPaintingState.getBitsPerPixel();
                aFPImageObjectInfo.setBitsPerPixel(n);
                ImageEncodingHelper.encodeRGBAsGrayScale((byte[])byArray, (int)renderedImage.getWidth(), (int)renderedImage.getHeight(), (int)n, (OutputStream)byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
                if (n == 1) {
                    aFPImageObjectInfo.setSubtractive(true);
                }
            }
            return byArray;
        }

        private boolean encodeInvertedBilevel(ImageEncodingHelper imageEncodingHelper, AFPImageObjectInfo aFPImageObjectInfo, OutputStream outputStream) throws IOException {
            RenderedImage renderedImage = imageEncodingHelper.getImage();
            if (!BitmapImageUtil.isMonochromeImage(renderedImage)) {
                throw new IllegalStateException("This method only supports binary images!");
            }
            int n = renderedImage.getNumXTiles() * renderedImage.getNumYTiles();
            if (n > 1) {
                return false;
            }
            SampleModel sampleModel = renderedImage.getSampleModel();
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, renderedImage.getWidth(), renderedImage.getHeight(), 1);
            if (!((Object)multiPixelPackedSampleModel).equals(sampleModel)) {
                return false;
            }
            aFPImageObjectInfo.setBitsPerPixel(1);
            Raster raster = renderedImage.getTile(0, 0);
            DataBuffer dataBuffer = raster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte) {
                int n2;
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                log.debug((Object)"Encoding image as inverted bi-level...");
                byte[] byArray = dataBufferByte.getData();
                int n3 = 0;
                byte[] byArray2 = new byte[4096];
                for (int i = byArray.length; i > 0; i -= n2) {
                    n2 = Math.min(i, byArray2.length);
                    for (int j = 0; j < n2; ++j) {
                        byArray2[j] = ~byArray[n3];
                        ++n3;
                    }
                    outputStream.write(byArray2, 0, n2);
                }
                return true;
            }
            return false;
        }

        private void encodeToBaselineDCT(RenderedImage renderedImage, float f, int n, OutputStream outputStream) throws IOException {
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setJPEGQuality(f, true);
            imageWriterParams.setResolution(n);
            imageWriter.writeImage(renderedImage, outputStream, imageWriterParams);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum FunctionSet {
            FS10("image/x-afp+fs10"),
            FS11("image/x-afp+fs11"),
            FS45("image/x-afp+fs45");

            private String mimeType;

            private FunctionSet(String string2) {
                this.mimeType = string2;
            }

            private String getMimeType() {
                return this.mimeType;
            }
        }
    }
}

