/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.fonts.FontInfo;
import org.apache.xmlgraphics.java2d.GraphicContext;

public final class AFPInfo {
    private int width;
    private int height;
    private int x;
    private int y;
    private Configuration handlerConfiguration;
    private FontInfo fontInfo;
    private AFPPaintingState paintingState;
    private AFPResourceManager resourceManager;
    private AFPResourceInfo resourceInfo;
    private boolean paintAsBitmap;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public Configuration getHandlerConfiguration() {
        return this.handlerConfiguration;
    }

    public void setHandlerConfiguration(Configuration configuration) {
        this.handlerConfiguration = configuration;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public AFPPaintingState getPaintingState() {
        return this.paintingState;
    }

    public AFPResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public boolean isColorSupported() {
        return this.getPaintingState().isColorImages();
    }

    protected int getX() {
        return this.x;
    }

    protected int getY() {
        return this.y;
    }

    protected int getResolution() {
        return this.getPaintingState().getResolution();
    }

    protected int getBitsPerPixel() {
        return this.getPaintingState().getBitsPerPixel();
    }

    protected void setX(int n) {
        this.x = n;
    }

    protected void setY(int n) {
        this.y = n;
    }

    protected void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public void setPaintingState(AFPPaintingState aFPPaintingState) {
        this.paintingState = aFPPaintingState;
    }

    public void setResourceManager(AFPResourceManager aFPResourceManager) {
        this.resourceManager = aFPResourceManager;
    }

    public void setPaintAsBitmap(boolean bl) {
        this.paintAsBitmap = bl;
    }

    public boolean paintAsBitmap() {
        return this.paintAsBitmap;
    }

    public boolean strokeText() {
        boolean bl = false;
        if (this.handlerConfiguration != null) {
            bl = this.handlerConfiguration.getChild("stroke-text", true).getValueAsBoolean(bl);
        }
        return bl;
    }

    public void setResourceInfo(AFPResourceInfo aFPResourceInfo) {
        this.resourceInfo = aFPResourceInfo;
    }

    public AFPResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public AFPGraphics2D createGraphics2D(boolean bl) {
        AFPGraphics2D aFPGraphics2D = new AFPGraphics2D(bl, this.paintingState, this.resourceManager, this.resourceInfo, this.fontInfo);
        aFPGraphics2D.setGraphicContext(new GraphicContext());
        return aFPGraphics2D;
    }

    public String toString() {
        return "AFPInfo{width=" + this.width + ", height=" + this.height + ", x=" + this.x + ", y=" + this.y + ", cfg=" + this.handlerConfiguration + ", fontInfo=" + this.fontInfo + ", resourceManager=" + this.resourceManager + ", paintingState=" + this.paintingState + ", paintAsBitmap=" + this.paintAsBitmap + ", resourceInfo=" + this.resourceInfo + "}";
    }
}

