/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.fop.afp.AFPBorderPainter;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.BorderPaintingInfo;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.RectanglePaintingInfo;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontAttributes;
import org.apache.fop.afp.fonts.AFPPageFonts;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.modca.AbstractPageObject;
import org.apache.fop.afp.modca.PresentationTextObject;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaProducer;
import org.apache.fop.afp.util.DefaultFOPResourceAccessor;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPDocumentHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.render.afp.PageSegmentDescriptor;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.w3c.dom.Document;

public class AFPPainter
extends AbstractIFPainter {
    private static final int X = 0;
    private static final int Y = 1;
    private final AFPDocumentHandler documentHandler;
    private final AFPBorderPainterAdapter borderPainter;
    private final AbstractAFPPainter rectanglePainter;
    private final AFPUnitConverter unitConv;

    public AFPPainter(AFPDocumentHandler aFPDocumentHandler) {
        this.documentHandler = aFPDocumentHandler;
        this.state = IFState.create();
        this.borderPainter = new AFPBorderPainterAdapter(new AFPBorderPainter(this.getPaintingState(), this.getDataStream()));
        this.rectanglePainter = aFPDocumentHandler.createRectanglePainter();
        this.unitConv = this.getPaintingState().getUnitConverter();
    }

    protected IFContext getContext() {
        return this.documentHandler.getContext();
    }

    FontInfo getFontInfo() {
        return this.documentHandler.getFontInfo();
    }

    AFPPaintingState getPaintingState() {
        return this.documentHandler.getPaintingState();
    }

    DataStream getDataStream() {
        return this.documentHandler.getDataStream();
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        try {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(affineTransform);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startViewport()", iOException);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endViewport()", iOException);
        }
    }

    private void concatenateTransformationMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.getPaintingState().concatenate(affineTransform);
        }
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        try {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(affineTransform);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startGroup()", iOException);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endGroup()", iOException);
        }
    }

    protected Map createDefaultImageProcessingHints(ImageSessionContext imageSessionContext) {
        Map map = super.createDefaultImageProcessingHints(imageSessionContext);
        map.put(ImageProcessingHints.TRANSPARENCY_INTENT, "ignore");
        return map;
    }

    protected RenderingContext createRenderingContext() {
        AFPRenderingContext aFPRenderingContext = new AFPRenderingContext(this.getUserAgent(), this.documentHandler.getResourceManager(), this.getPaintingState(), this.getFontInfo(), this.getContext().getForeignAttributes());
        return aFPRenderingContext;
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        PageSegmentDescriptor pageSegmentDescriptor = this.documentHandler.getPageSegmentNameFor(string);
        if (pageSegmentDescriptor != null) {
            float[] fArray = new float[]{rectangle.x, rectangle.y};
            int[] nArray = this.unitConv.mpts2units(fArray);
            int n = Math.round(this.unitConv.mpt2units(rectangle.width));
            int n2 = Math.round(this.unitConv.mpt2units(rectangle.height));
            this.getDataStream().createIncludePageSegment(pageSegmentDescriptor.getName(), nArray[0], nArray[1], n, n2);
            if (pageSegmentDescriptor.getURI() != null) {
                DefaultFOPResourceAccessor defaultFOPResourceAccessor = new DefaultFOPResourceAccessor(this.documentHandler.getUserAgent(), null, null);
                try {
                    URI uRI = new URI(pageSegmentDescriptor.getURI());
                    this.documentHandler.getResourceManager().createIncludedResourceFromExternal(pageSegmentDescriptor.getName(), uRI, defaultFOPResourceAccessor);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IFException("Could not handle resource url" + pageSegmentDescriptor.getURI(), uRISyntaxException);
                }
                catch (IOException iOException) {
                    throw new IFException("Could not handle resource" + pageSegmentDescriptor.getURI(), iOException);
                }
            }
        } else {
            this.drawImageUsingURI(string, rectangle);
        }
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        this.drawImageUsingDocument(document, rectangle);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
    }

    private float toPoint(int n) {
        return (float)n / 1000.0f;
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            if (!(paint instanceof Color)) {
                throw new UnsupportedOperationException("Non-Color paints NYI");
            }
            this.getPaintingState().setColor((Color)paint);
            RectanglePaintingInfo rectanglePaintingInfo = new RectanglePaintingInfo(this.toPoint(rectangle.x), this.toPoint(rectangle.y), this.toPoint(rectangle.width), this.toPoint(rectangle.height));
            try {
                this.rectanglePainter.paint(rectanglePaintingInfo);
            }
            catch (IOException iOException) {
                throw new IFException("IO error while painting rectangle", iOException);
            }
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            try {
                this.borderPainter.drawBorders(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
            }
            catch (IOException iOException) {
                throw new IFException("IO error while painting borders", iOException);
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        try {
            this.borderPainter.drawLine(point, point2, n, color, ruleStyle);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawLine()", iOException);
        }
    }

    public void drawText(int n, int n2, final int n3, final int n4, final int[][] nArray, final String string) throws IFException {
        int n5 = this.state.getFontSize();
        this.getPaintingState().setFontSize(n5);
        FontTriplet fontTriplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
        String string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
        if (string2 == null) {
            fontTriplet = new FontTriplet("any", "normal", 400);
            string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
        }
        Map<String, Typeface> map = this.documentHandler.getFontInfo().getFonts();
        AFPFont aFPFont = (AFPFont)map.get(string2);
        final Font font = this.getFontInfo().getFontInstance(fontTriplet, n5);
        AFPPageFonts aFPPageFonts = this.getPaintingState().getPageFonts();
        AFPFontAttributes aFPFontAttributes = aFPPageFonts.registerFont(string2, aFPFont, n5);
        final int n6 = aFPFontAttributes.getFontReference();
        final int[] nArray2 = this.unitConv.mpts2units(new float[]{n, n2});
        final CharacterSet characterSet = aFPFont.getCharacterSet(n5);
        if (aFPFont.isEmbeddable()) {
            try {
                this.documentHandler.getResourceManager().embedFont(aFPFont, characterSet);
            }
            catch (IOException iOException) {
                throw new IFException("Error while embedding font resources", iOException);
            }
        }
        AbstractPageObject abstractPageObject = this.getDataStream().getCurrentPage();
        PresentationTextObject presentationTextObject = abstractPageObject.getPresentationTextObject();
        try {
            presentationTextObject.createControlSequences(new PtocaProducer(){

                public void produce(PtocaBuilder ptocaBuilder) throws IOException {
                    int n;
                    Point point = AFPPainter.this.getPaintingState().getPoint(nArray2[0], nArray2[1]);
                    ptocaBuilder.setTextOrientation(AFPPainter.this.getPaintingState().getRotation());
                    ptocaBuilder.absoluteMoveBaseline(point.y);
                    ptocaBuilder.absoluteMoveInline(point.x);
                    ptocaBuilder.setExtendedTextColor(AFPPainter.this.state.getTextColor());
                    ptocaBuilder.setCodedFont((byte)n6);
                    int n2 = string.length();
                    int[] nArray3 = IFUtil.convertDPToDX(nArray);
                    int n32 = nArray3 != null ? nArray3.length : 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n32 > 0 && nArray3[0] != 0) {
                        int n42 = Math.round(AFPPainter.this.unitConv.mpt2units(nArray3[0]));
                        ptocaBuilder.relativeMoveInline(-n42);
                    }
                    int n5 = 0;
                    if (n3 != 0) {
                        n5 = Math.round(AFPPainter.this.unitConv.mpt2units(n3));
                    }
                    ptocaBuilder.setInterCharacterAdjustment(n5);
                    int n62 = font.getCharWidth(' ');
                    int n7 = n = Math.round(AFPPainter.this.unitConv.mpt2units(n62 + n3));
                    if (n4 != 0) {
                        n7 = Math.round(AFPPainter.this.unitConv.mpt2units(n62 + n4 + n3));
                    }
                    ptocaBuilder.setVariableSpaceCharacterIncrement(n7);
                    boolean bl = false;
                    for (int i = 0; i < n2; ++i) {
                        int n8;
                        char c = string.charAt(i);
                        float f = 0.0f;
                        if (CharUtilities.isFixedWidthSpace(c)) {
                            this.flushText(ptocaBuilder, stringBuffer, characterSet);
                            ptocaBuilder.setVariableSpaceCharacterIncrement(n);
                            bl = true;
                            stringBuffer.append(' ');
                            n8 = font.getCharWidth(c);
                            f += (float)(n8 - n62);
                        } else {
                            if (bl) {
                                this.flushText(ptocaBuilder, stringBuffer, characterSet);
                                ptocaBuilder.setVariableSpaceCharacterIncrement(n7);
                                bl = false;
                            }
                            n8 = c == '\u00a0' ? 32 : (int)c;
                            stringBuffer.append((char)n8);
                        }
                        if (i < n32 - 1) {
                            f += (float)nArray3[i + 1];
                        }
                        if (f == 0.0f) continue;
                        this.flushText(ptocaBuilder, stringBuffer, characterSet);
                        n8 = Math.round(AFPPainter.this.unitConv.mpt2units(f));
                        ptocaBuilder.relativeMoveInline(n8);
                    }
                    this.flushText(ptocaBuilder, stringBuffer, characterSet);
                }

                private void flushText(PtocaBuilder ptocaBuilder, StringBuffer stringBuffer, CharacterSet characterSet2) throws IOException {
                    if (stringBuffer.length() > 0) {
                        ptocaBuilder.addTransparentData(characterSet2.encodeChars(stringBuffer));
                        stringBuffer.setLength(0);
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawText()", iOException);
        }
    }

    protected void saveGraphicsState() throws IOException {
        this.getPaintingState().save();
    }

    protected void restoreGraphicsState() throws IOException {
        this.getPaintingState().restore();
    }

    private static class AFPBorderPainterAdapter
    extends BorderPainter {
        private final AFPBorderPainter delegate;

        public AFPBorderPainterAdapter(AFPBorderPainter aFPBorderPainter) {
            this.delegate = aFPBorderPainter;
        }

        protected void clip() throws IOException {
        }

        protected void closePath() throws IOException {
        }

        protected void moveTo(int n, int n2) throws IOException {
        }

        protected void lineTo(int n, int n2) throws IOException {
        }

        protected void saveGraphicsState() throws IOException {
        }

        protected void restoreGraphicsState() throws IOException {
        }

        private float toPoints(int n) {
            return (float)n / 1000.0f;
        }

        protected void drawBorderLine(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Color color) throws IOException {
            BorderPaintingInfo borderPaintingInfo = new BorderPaintingInfo(this.toPoints(n), this.toPoints(n2), this.toPoints(n3), this.toPoints(n4), bl, n5, color);
            this.delegate.paint(borderPaintingInfo);
        }

        public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IOException {
            if (point.y != point2.y) {
                throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
            }
            int n2 = n / 2;
            this.drawBorderLine(point.x, point.y - n2, point2.x, point.y + n2, true, true, ruleStyle.getEnumValue(), color);
        }
    }
}

