/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.svg.AFPBridgeContext;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.image.loader.batik.Graphics2DImagePainterImpl;
import org.apache.fop.render.AbstractGenericSVGHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.afp.AFPInfo;
import org.apache.fop.render.afp.AFPRendererContext;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;

public class AFPSVGHandler
extends AbstractGenericSVGHandler {
    private boolean paintAsBitmap = false;

    public void handleXML(RendererContext rendererContext, Document document, String string) throws Exception {
        if ("http://www.w3.org/2000/svg".equals(string)) {
            this.renderSVGDocument(rendererContext, document);
        }
    }

    protected void renderSVGDocument(RendererContext rendererContext, Document document) throws IOException {
        AFPRendererContext aFPRendererContext = (AFPRendererContext)rendererContext;
        AFPInfo aFPInfo = aFPRendererContext.getInfo();
        this.paintAsBitmap = aFPInfo.paintAsBitmap();
        FOUserAgent fOUserAgent = rendererContext.getUserAgent();
        String string = this.getDocumentURI(document);
        if (this.paintAsBitmap) {
            try {
                super.renderSVGDocument(rendererContext, document);
            }
            catch (IOException iOException) {
                SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(fOUserAgent.getEventBroadcaster());
                sVGEventProducer.svgRenderingError(this, iOException, string);
            }
            return;
        }
        boolean bl = aFPInfo.strokeText();
        AFPGraphics2D aFPGraphics2D = aFPInfo.createGraphics2D(bl);
        AFPPaintingState aFPPaintingState = aFPGraphics2D.getPaintingState();
        aFPPaintingState.setImageUri(string);
        BridgeContext bridgeContext = AFPSVGHandler.createBridgeContext(fOUserAgent, aFPGraphics2D);
        Document document2 = BatikUtil.cloneSVGDocument(document);
        GraphicsNode graphicsNode = this.buildGraphicsNode(fOUserAgent, bridgeContext, document2);
        RendererContext.RendererContextWrapper rendererContextWrapper = RendererContext.wrapRendererContext(rendererContext);
        Dimension dimension = this.getImageSize(rendererContextWrapper);
        Graphics2DImagePainter graphics2DImagePainter = this.createGraphics2DImagePainter(bridgeContext, graphicsNode, dimension);
        RendererContext.RendererContextWrapper rendererContextWrapper2 = RendererContext.wrapRendererContext(rendererContext);
        int n = rendererContextWrapper2.getCurrentXPosition();
        int n2 = rendererContextWrapper2.getCurrentYPosition();
        int n3 = aFPInfo.getWidth();
        int n4 = aFPInfo.getHeight();
        int n5 = aFPInfo.getResolution();
        aFPPaintingState.save();
        AFPObjectAreaInfo aFPObjectAreaInfo = this.createObjectAreaInfo(aFPPaintingState, n, n2, n3, n4, n5);
        AFPResourceInfo aFPResourceInfo = aFPInfo.getResourceInfo();
        AFPGraphicsObjectInfo aFPGraphicsObjectInfo = this.createGraphicsObjectInfo(aFPPaintingState, graphics2DImagePainter, fOUserAgent, aFPResourceInfo, aFPGraphics2D);
        aFPGraphicsObjectInfo.setObjectAreaInfo(aFPObjectAreaInfo);
        AFPResourceManager aFPResourceManager = aFPInfo.getResourceManager();
        aFPResourceManager.createObject(aFPGraphicsObjectInfo);
        aFPPaintingState.restore();
    }

    private AFPObjectAreaInfo createObjectAreaInfo(AFPPaintingState aFPPaintingState, int n, int n2, int n3, int n4, int n5) {
        AffineTransform affineTransform = aFPPaintingState.getData().getTransform();
        affineTransform.translate(n, n2);
        AFPUnitConverter aFPUnitConverter = aFPPaintingState.getUnitConverter();
        int n6 = aFPPaintingState.getRotation();
        int n7 = (int)Math.round(affineTransform.getTranslateX());
        int n8 = (int)Math.round(affineTransform.getTranslateY());
        int n9 = Math.round(aFPUnitConverter.mpt2units(n3));
        int n10 = Math.round(aFPUnitConverter.mpt2units(n4));
        AFPObjectAreaInfo aFPObjectAreaInfo = new AFPObjectAreaInfo(n7, n8, n9, n10, n5, n6);
        return aFPObjectAreaInfo;
    }

    private AFPGraphicsObjectInfo createGraphicsObjectInfo(AFPPaintingState aFPPaintingState, Graphics2DImagePainter graphics2DImagePainter, FOUserAgent fOUserAgent, AFPResourceInfo aFPResourceInfo, AFPGraphics2D aFPGraphics2D) {
        AFPGraphicsObjectInfo aFPGraphicsObjectInfo = new AFPGraphicsObjectInfo();
        String string = aFPPaintingState.getImageUri();
        aFPGraphicsObjectInfo.setUri(string);
        aFPGraphicsObjectInfo.setMimeType("image/x-afp+goca");
        aFPGraphicsObjectInfo.setResourceInfo(aFPResourceInfo);
        aFPGraphicsObjectInfo.setPainter(graphics2DImagePainter);
        aFPGraphicsObjectInfo.setGraphics2D(aFPGraphics2D);
        return aFPGraphicsObjectInfo;
    }

    public static BridgeContext createBridgeContext(FOUserAgent fOUserAgent, AFPGraphics2D aFPGraphics2D) {
        ImageManager imageManager = fOUserAgent.getFactory().getImageManager();
        SVGUserAgent sVGUserAgent = new SVGUserAgent(fOUserAgent, new AffineTransform());
        ImageSessionContext imageSessionContext = fOUserAgent.getImageSessionContext();
        FontInfo fontInfo = aFPGraphics2D.getFontInfo();
        return new AFPBridgeContext((UserAgent)sVGUserAgent, fontInfo, imageManager, imageSessionContext, new AffineTransform(), aFPGraphics2D);
    }

    public boolean supportsRenderer(Renderer renderer) {
        return false;
    }

    protected void updateRendererContext(RendererContext rendererContext) {
        rendererContext.setProperty("afpGrayscale", Boolean.FALSE);
    }

    private Graphics2DImagePainter createGraphics2DImagePainter(BridgeContext bridgeContext, GraphicsNode graphicsNode, Dimension dimension) {
        Object object = null;
        object = this.paintAsBitmap() ? super.createGraphics2DImagePainter(graphicsNode, bridgeContext, dimension) : new Graphics2DImagePainterImpl(graphicsNode, bridgeContext, dimension);
        return object;
    }

    private boolean paintAsBitmap() {
        return this.paintAsBitmap;
    }
}

