/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiFileRenderingUtil {
    private String filePrefix;
    private String fileExtension;
    private File outputDir;

    public MultiFileRenderingUtil(String string, File file) {
        this.fileExtension = string;
        if (file == null) {
            this.outputDir = null;
            this.filePrefix = null;
        } else {
            this.outputDir = file.getParentFile();
            String string2 = file.getName();
            int n = string2.lastIndexOf(".");
            if (n > 0) {
                String string3 = string2.substring(n + 1).toLowerCase();
                if (!string.equals(string3)) {
                    throw new IllegalArgumentException("Invalid file extension ('" + string3 + "') specified");
                }
            } else if (n == -1) {
                n = string2.length();
            } else {
                throw new IllegalArgumentException("Invalid file name ('" + string2 + "') specified");
            }
            if (string2.charAt(n - 1) == '1') {
                --n;
            }
            this.filePrefix = string2.substring(0, n);
        }
    }

    public OutputStream createOutputStream(int n) throws IOException {
        if (this.filePrefix == null) {
            return null;
        }
        File file = new File(this.outputDir, this.filePrefix + (n + 1) + "." + this.fileExtension);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        return bufferedOutputStream;
    }
}

