/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class IFGraphicContext
extends GraphicContext {
    private static final AffineTransform[] EMPTY_TRANSFORM_ARRAY = new AffineTransform[0];
    private ArrayList groupList = new ArrayList();

    public IFGraphicContext() {
    }

    protected IFGraphicContext(IFGraphicContext iFGraphicContext) {
        super((GraphicContext)iFGraphicContext);
    }

    public Object clone() {
        return new IFGraphicContext(this);
    }

    public void pushGroup(Group group) {
        this.groupList.add(group);
        int n = group.getTransforms().length;
        for (int i = 0; i < n; ++i) {
            this.transform(group.getTransforms()[i]);
        }
    }

    public Group[] getGroups() {
        return this.groupList.toArray(new Group[this.getGroupStackSize()]);
    }

    public Group[] dropGroups() {
        Group[] groupArray = this.getGroups();
        this.groupList.clear();
        return groupArray;
    }

    public int getGroupStackSize() {
        return this.groupList.size();
    }

    public static class Viewport
    extends Group {
        private Dimension size;
        private Rectangle clipRect;

        public Viewport(AffineTransform[] affineTransformArray, Dimension dimension, Rectangle rectangle) {
            super(affineTransformArray);
            this.size = dimension;
            this.clipRect = rectangle;
        }

        public Viewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) {
            this(new AffineTransform[]{affineTransform}, dimension, rectangle);
        }

        public Dimension getSize() {
            return this.size;
        }

        public Rectangle getClipRect() {
            return this.clipRect;
        }

        public void start(IFPainter iFPainter) throws IFException {
            iFPainter.startViewport(this.getTransforms(), this.size, this.clipRect);
        }

        public void end(IFPainter iFPainter) throws IFException {
            iFPainter.endViewport();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("viewport: ");
            IFUtil.toString(this.getTransforms(), stringBuffer);
            stringBuffer.append(", ").append(this.getSize());
            if (this.getClipRect() != null) {
                stringBuffer.append(", ").append(this.getClipRect());
            }
            return stringBuffer.toString();
        }
    }

    public static class Group {
        private AffineTransform[] transforms;

        public Group(AffineTransform[] affineTransformArray) {
            this.transforms = affineTransformArray;
        }

        public Group(AffineTransform affineTransform) {
            this(new AffineTransform[]{affineTransform});
        }

        public Group() {
            this(EMPTY_TRANSFORM_ARRAY);
        }

        public AffineTransform[] getTransforms() {
            return this.transforms;
        }

        public void start(IFPainter iFPainter) throws IFException {
            iFPainter.startGroup(this.transforms);
        }

        public void end(IFPainter iFPainter) throws IFException {
            iFPainter.endGroup();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("group: ");
            IFUtil.toString(this.getTransforms(), stringBuffer);
            return stringBuffer.toString();
        }
    }
}

