/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.AccessibilityEventProducer;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.render.intermediate.AffineTransformArrayParser;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationHandler;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.DOMBuilderContentHandlerFactory;
import org.apache.fop.util.DefaultErrorListener;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class IFParser
implements IFConstants {
    protected static final Log log = LogFactory.getLog(IFParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static Set<String> handledNamespaces = new HashSet<String>();

    public void parse(Source source, IFDocumentHandler iFDocumentHandler, FOUserAgent fOUserAgent) throws TransformerException, IFException {
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.setErrorListener(new DefaultErrorListener(log));
            SAXResult sAXResult = new SAXResult(this.getContentHandler(iFDocumentHandler, fOUserAgent));
            transformer.transform(source, sAXResult);
        }
        catch (TransformerException transformerException) {
            if (transformerException.getCause() instanceof SAXException) {
                SAXException sAXException = (SAXException)transformerException.getCause();
                if (sAXException.getCause() instanceof IFException) {
                    throw (IFException)sAXException.getCause();
                }
            } else if (transformerException.getCause() instanceof IFException) {
                throw (IFException)transformerException.getCause();
            }
            throw transformerException;
        }
    }

    public ContentHandler getContentHandler(IFDocumentHandler iFDocumentHandler, FOUserAgent fOUserAgent) {
        ElementMappingRegistry elementMappingRegistry = fOUserAgent.getFactory().getElementMappingRegistry();
        return new Handler(iFDocumentHandler, fOUserAgent, elementMappingRegistry);
    }

    static {
        handledNamespaces.add("http://www.w3.org/2000/xmlns/");
        handledNamespaces.add("http://www.w3.org/XML/1998/namespace");
        handledNamespaces.add("http://xmlgraphics.apache.org/fop/intermediate");
        handledNamespaces.add("http://www.w3.org/1999/xlink");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    extends DefaultHandler {
        private Map<String, ElementHandler> elementHandlers = new HashMap<String, ElementHandler>();
        private IFDocumentHandler documentHandler;
        private IFPainter painter;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private StringBuffer content = new StringBuffer();
        private boolean ignoreCharacters = true;
        private int delegateDepth;
        private ContentHandler delegate;
        private boolean inForeignObject;
        private Document foreignObject;
        private ContentHandler navParser;
        private StructureTreeHandler structureTreeHandler;
        private Attributes pageSequenceAttributes;
        private Map<String, StructureTreeElement> structureTreeElements = new HashMap<String, StructureTreeElement>();
        private static final String[] SIDES = new String[]{"top", "bottom", "left", "right"};

        public Handler(IFDocumentHandler iFDocumentHandler, FOUserAgent fOUserAgent, ElementMappingRegistry elementMappingRegistry) {
            this.documentHandler = iFDocumentHandler;
            this.userAgent = fOUserAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.elementHandlers.put("document", new DocumentHandler());
            this.elementHandlers.put("header", new DocumentHeaderHandler());
            this.elementHandlers.put("locale", new LocaleHandler());
            this.elementHandlers.put("trailer", new DocumentTrailerHandler());
            this.elementHandlers.put("page-sequence", new PageSequenceHandler());
            this.elementHandlers.put("page", new PageHandler());
            this.elementHandlers.put("page-header", new PageHeaderHandler());
            this.elementHandlers.put("content", new PageContentHandler());
            this.elementHandlers.put("page-trailer", new PageTrailerHandler());
            this.elementHandlers.put("viewport", new ViewportHandler());
            this.elementHandlers.put("g", new GroupHandler());
            this.elementHandlers.put("id", new IDHandler());
            this.elementHandlers.put("font", new FontHandler());
            this.elementHandlers.put("text", new TextHandler());
            this.elementHandlers.put("clip-rect", new ClipRectHandler());
            this.elementHandlers.put("rect", new RectHandler());
            this.elementHandlers.put("line", new LineHandler());
            this.elementHandlers.put("border-rect", new BorderRectHandler());
            this.elementHandlers.put("image", new ImageHandler());
        }

        private void establishForeignAttributes(Map<QName, String> map) {
            this.documentHandler.getContext().setForeignAttributes(map);
        }

        private void resetForeignAttributes() {
            this.documentHandler.getContext().resetForeignAttributes();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                ++this.delegateDepth;
                this.delegate.startElement(string, string2, string3, attributes);
            } else {
                boolean bl = true;
                if ("http://xmlgraphics.apache.org/fop/intermediate".equals(string)) {
                    if (string2.equals("page-sequence") && this.userAgent.isAccessibilityEnabled()) {
                        this.pageSequenceAttributes = new AttributesImpl(attributes);
                        Locale locale = Handler.getLanguage(attributes);
                        this.structureTreeHandler = new StructureTreeHandler(this.userAgent.getStructureTreeEventHandler(), locale);
                    } else if (string2.equals("structure-tree")) {
                        if (this.userAgent.isAccessibilityEnabled()) {
                            String string4 = attributes.getValue("type");
                            this.structureTreeHandler.startStructureTree(string4);
                            this.delegate = this.structureTreeHandler;
                        } else {
                            this.delegate = new DefaultHandler();
                        }
                        ++this.delegateDepth;
                        this.delegate.startDocument();
                        this.delegate.startElement(string, string2, string3, attributes);
                    } else {
                        if (this.pageSequenceAttributes != null) {
                            AccessibilityEventProducer.Provider.get(this.userAgent.getEventBroadcaster()).noStructureTreeInXML(this);
                        }
                        bl = this.startIFElement(string2, attributes);
                    }
                } else if ("http://xmlgraphics.apache.org/fop/intermediate/document-navigation".equals(string)) {
                    if (this.navParser == null) {
                        this.navParser = new DocumentNavigationHandler(this.documentHandler.getDocumentNavigationHandler(), this.structureTreeElements);
                    }
                    this.delegate = this.navParser;
                    ++this.delegateDepth;
                    this.delegate.startDocument();
                    this.delegate.startElement(string, string2, string3, attributes);
                } else {
                    ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = this.userAgent.getFactory().getContentHandlerFactoryRegistry();
                    ContentHandlerFactory contentHandlerFactory = contentHandlerFactoryRegistry.getFactory(string);
                    if (contentHandlerFactory == null) {
                        DOMImplementation dOMImplementation = this.elementMappingRegistry.getDOMImplementationForNamespace(string);
                        if (dOMImplementation == null) {
                            dOMImplementation = ElementMapping.getDefaultDOMImplementation();
                        }
                        contentHandlerFactory = new DOMBuilderContentHandlerFactory(string, dOMImplementation);
                    }
                    this.delegate = contentHandlerFactory.createContentHandler();
                    ++this.delegateDepth;
                    this.delegate.startDocument();
                    this.delegate.startElement(string, string2, string3, attributes);
                }
                if (!bl) {
                    if (string == null || string.length() == 0) {
                        throw new SAXException("Unhandled element " + string2 + " in namespace: " + string);
                    }
                    log.warn((Object)("Unhandled element " + string2 + " in namespace: " + string));
                }
            }
        }

        private static Locale getLanguage(Attributes attributes) {
            String string = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
            return string == null ? null : LanguageTags.toLocale(string);
        }

        private boolean startIFElement(String string, Attributes attributes) throws SAXException {
            this.lastAttributes = new AttributesImpl(attributes);
            ElementHandler elementHandler = this.elementHandlers.get(string);
            this.content.setLength(0);
            this.ignoreCharacters = true;
            if (elementHandler != null) {
                this.ignoreCharacters = elementHandler.ignoreCharacters();
                try {
                    elementHandler.startElement(attributes);
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
                return true;
            }
            return false;
        }

        private void handleIFException(IFException iFException) throws SAXException {
            if (iFException.getCause() instanceof SAXException) {
                throw (SAXException)iFException.getCause();
            }
            throw new SAXException(iFException);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(string, string2, string3);
                --this.delegateDepth;
                if (this.delegateDepth == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object object = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        if (this.inForeignObject) {
                            this.foreignObject = (Document)object;
                        } else {
                            this.handleExternallyGeneratedObject(object);
                        }
                    }
                    this.delegate = null;
                }
            } else if ("http://xmlgraphics.apache.org/fop/intermediate".equals(string)) {
                ElementHandler elementHandler = this.elementHandlers.get(string2);
                if (elementHandler != null) {
                    try {
                        elementHandler.endElement();
                    }
                    catch (IFException iFException) {
                        this.handleIFException(iFException);
                    }
                    this.content.setLength(0);
                }
                this.ignoreCharacters = true;
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring " + string2 + " in namespace: " + string));
            }
        }

        protected void handleExternallyGeneratedObject(Object object) throws SAXException {
            try {
                this.documentHandler.handleExtensionObject(object);
            }
            catch (IFException iFException) {
                this.handleIFException(iFException);
            }
        }

        private Color getAttributeAsColor(Attributes attributes, String string) throws PropertyException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                return null;
            }
            return ColorUtil.parseColorString(this.userAgent, string2);
        }

        private static Map<QName, String> getForeignAttributes(Attributes attributes) {
            HashMap<QName, String> hashMap = null;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getURI(i);
                if (string.length() <= 0 || handledNamespaces.contains(string)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<QName, String>();
                }
                QName qName = new QName(string, attributes.getQName(i));
                hashMap.put(qName, attributes.getValue(i));
            }
            return hashMap;
        }

        private void establishStructureTreeElement(Attributes attributes) {
            String string = attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "struct-ref");
            if (string != null && string.length() > 0) {
                assert (this.structureTreeElements.containsKey(string));
                StructureTreeElement structureTreeElement = this.structureTreeElements.get(string);
                this.documentHandler.getContext().setStructureTreeElement(structureTreeElement);
            }
        }

        private void resetStructureTreeElement() {
            this.documentHandler.getContext().resetStructureTreeElement();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(cArray, n, n2);
            } else if (!this.ignoreCharacters) {
                this.content.append(cArray, n, n2);
            }
        }

        private class ImageHandler
        extends AbstractElementHandler {
            private ImageHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.inForeignObject = true;
            }

            public void endElement() throws IFException {
                int n = Integer.parseInt(Handler.this.lastAttributes.getValue("x"));
                int n2 = Integer.parseInt(Handler.this.lastAttributes.getValue("y"));
                int n3 = Integer.parseInt(Handler.this.lastAttributes.getValue("width"));
                int n4 = Integer.parseInt(Handler.this.lastAttributes.getValue("height"));
                Map map = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(map);
                Handler.this.establishStructureTreeElement(Handler.this.lastAttributes);
                if (Handler.this.foreignObject != null) {
                    Handler.this.painter.drawImage(Handler.this.foreignObject, new Rectangle(n, n2, n3, n4));
                    Handler.this.foreignObject = null;
                } else {
                    String string = Handler.this.lastAttributes.getValue(XMLConstants.XLINK_HREF.getNamespaceURI(), XMLConstants.XLINK_HREF.getLocalName());
                    if (string == null) {
                        throw new IFException("xlink:href is missing on image", null);
                    }
                    Handler.this.painter.drawImage(string, new Rectangle(n, n2, n3, n4));
                }
                Handler.this.resetForeignAttributes();
                Handler.this.resetStructureTreeElement();
                Handler.this.inForeignObject = false;
            }

            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class BorderRectHandler
        extends AbstractElementHandler {
            private BorderRectHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                int n = Integer.parseInt(attributes.getValue("x"));
                int n2 = Integer.parseInt(attributes.getValue("y"));
                int n3 = Integer.parseInt(attributes.getValue("width"));
                int n4 = Integer.parseInt(attributes.getValue("height"));
                BorderProps[] borderPropsArray = new BorderProps[4];
                for (int i = 0; i < 4; ++i) {
                    String string = attributes.getValue(SIDES[i]);
                    if (string == null) continue;
                    borderPropsArray[i] = BorderProps.valueOf(Handler.this.userAgent, string);
                }
                Handler.this.painter.drawBorderRect(new Rectangle(n, n2, n3, n4), borderPropsArray[0], borderPropsArray[1], borderPropsArray[2], borderPropsArray[3]);
            }
        }

        private class LineHandler
        extends AbstractElementHandler {
            private LineHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Color color;
                int n = Integer.parseInt(attributes.getValue("x1"));
                int n2 = Integer.parseInt(attributes.getValue("y1"));
                int n3 = Integer.parseInt(attributes.getValue("x2"));
                int n4 = Integer.parseInt(attributes.getValue("y2"));
                int n5 = Integer.parseInt(attributes.getValue("stroke-width"));
                try {
                    color = Handler.this.getAttributeAsColor(attributes, "color");
                }
                catch (PropertyException propertyException) {
                    throw new IFException("Error parsing the fill attribute", propertyException);
                }
                RuleStyle ruleStyle = RuleStyle.valueOf(attributes.getValue("style"));
                Handler.this.painter.drawLine(new Point(n, n2), new Point(n3, n4), n5, color, ruleStyle);
            }
        }

        private class RectHandler
        extends AbstractElementHandler {
            private RectHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Color color;
                int n = Integer.parseInt(attributes.getValue("x"));
                int n2 = Integer.parseInt(attributes.getValue("y"));
                int n3 = Integer.parseInt(attributes.getValue("width"));
                int n4 = Integer.parseInt(attributes.getValue("height"));
                try {
                    color = Handler.this.getAttributeAsColor(attributes, "fill");
                }
                catch (PropertyException propertyException) {
                    throw new IFException("Error parsing the fill attribute", propertyException);
                }
                Handler.this.painter.fillRect(new Rectangle(n, n2, n3, n4), color);
            }
        }

        private class ClipRectHandler
        extends AbstractElementHandler {
            private ClipRectHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                int n = Integer.parseInt(attributes.getValue("x"));
                int n2 = Integer.parseInt(attributes.getValue("y"));
                int n3 = Integer.parseInt(attributes.getValue("width"));
                int n4 = Integer.parseInt(attributes.getValue("height"));
                Handler.this.painter.clipRect(new Rectangle(n, n2, n3, n4));
            }
        }

        private class TextHandler
        extends AbstractElementHandler {
            private TextHandler() {
            }

            public void endElement() throws IFException {
                int n = Integer.parseInt(Handler.this.lastAttributes.getValue("x"));
                int n2 = Integer.parseInt(Handler.this.lastAttributes.getValue("y"));
                String string = Handler.this.lastAttributes.getValue("letter-spacing");
                int n3 = string != null ? Integer.parseInt(string) : 0;
                string = Handler.this.lastAttributes.getValue("word-spacing");
                int n4 = string != null ? Integer.parseInt(string) : 0;
                int[] nArray = XMLUtil.getAttributeAsIntArray(Handler.this.lastAttributes, "dx");
                int[][] nArray2 = XMLUtil.getAttributeAsPositionAdjustments(Handler.this.lastAttributes, "dp");
                if (nArray2 == null && nArray != null) {
                    nArray2 = IFUtil.convertDXToDP(nArray);
                }
                Handler.this.establishStructureTreeElement(Handler.this.lastAttributes);
                Handler.this.painter.drawText(n, n2, n3, n4, nArray2, Handler.this.content.toString());
                Handler.this.resetStructureTreeElement();
            }

            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class FontHandler
        extends AbstractElementHandler {
            private FontHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Color color;
                String string = attributes.getValue("family");
                String string2 = attributes.getValue("style");
                Integer n = XMLUtil.getAttributeAsInteger(attributes, "weight");
                String string3 = attributes.getValue("variant");
                Integer n2 = XMLUtil.getAttributeAsInteger(attributes, "size");
                try {
                    color = Handler.this.getAttributeAsColor(attributes, "color");
                }
                catch (PropertyException propertyException) {
                    throw new IFException("Error parsing the color attribute", propertyException);
                }
                Handler.this.painter.setFont(string, string2, n, string3, n2, color);
            }
        }

        private class IDHandler
        extends AbstractElementHandler {
            private IDHandler() {
            }

            public void startElement(Attributes attributes) throws IFException, SAXException {
                String string = attributes.getValue("name");
                Handler.this.documentHandler.getContext().setID(string);
            }
        }

        private class GroupHandler
        extends AbstractElementHandler {
            private GroupHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                String string = attributes.getValue("transform");
                AffineTransform[] affineTransformArray = AffineTransformArrayParser.createAffineTransform(string);
                Handler.this.painter.startGroup(affineTransformArray);
            }

            public void endElement() throws IFException {
                Handler.this.painter.endGroup();
            }
        }

        private class ViewportHandler
        extends AbstractElementHandler {
            private ViewportHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                String string = attributes.getValue("transform");
                AffineTransform[] affineTransformArray = AffineTransformArrayParser.createAffineTransform(string);
                int n = Integer.parseInt(attributes.getValue("width"));
                int n2 = Integer.parseInt(attributes.getValue("height"));
                Rectangle rectangle = XMLUtil.getAttributeAsRectangle(attributes, "clip-rect");
                Handler.this.painter.startViewport(affineTransformArray, new Dimension(n, n2), rectangle);
            }

            public void endElement() throws IFException {
                Handler.this.painter.endViewport();
            }
        }

        private class PageTrailerHandler
        extends AbstractElementHandler {
            private PageTrailerHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startPageTrailer();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageTrailer();
            }
        }

        private class PageContentHandler
        extends AbstractElementHandler {
            private PageContentHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.painter = Handler.this.documentHandler.startPageContent();
            }

            public void endElement() throws IFException {
                Handler.this.painter = null;
                Handler.this.documentHandler.getContext().setID("");
                Handler.this.documentHandler.endPageContent();
            }
        }

        private class PageHeaderHandler
        extends AbstractElementHandler {
            private PageHeaderHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startPageHeader();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageHeader();
            }
        }

        private class PageHandler
        extends AbstractElementHandler {
            private PageHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                int n = Integer.parseInt(attributes.getValue("index"));
                String string = attributes.getValue("name");
                String string2 = attributes.getValue("page-master-name");
                int n2 = Integer.parseInt(attributes.getValue("width"));
                int n3 = Integer.parseInt(attributes.getValue("height"));
                Map map = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(map);
                Handler.this.documentHandler.startPage(n, string, string2, new Dimension(n2, n3));
                Handler.this.resetForeignAttributes();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endPage();
            }
        }

        private class PageSequenceHandler
        extends AbstractElementHandler {
            private PageSequenceHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                String string = attributes.getValue("id");
                Locale locale = Handler.getLanguage(attributes);
                if (locale != null) {
                    Handler.this.documentHandler.getContext().setLanguage(locale);
                }
                Map map = Handler.getForeignAttributes(Handler.this.lastAttributes);
                Handler.this.establishForeignAttributes(map);
                Handler.this.documentHandler.startPageSequence(string);
                Handler.this.resetForeignAttributes();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endPageSequence();
                Handler.this.documentHandler.getContext().setLanguage(null);
            }
        }

        private class DocumentTrailerHandler
        extends AbstractElementHandler {
            private DocumentTrailerHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocumentTrailer();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocumentTrailer();
            }
        }

        private class LocaleHandler
        extends AbstractElementHandler {
            private LocaleHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.setDocumentLocale(Handler.getLanguage(attributes));
            }
        }

        private class DocumentHeaderHandler
        extends AbstractElementHandler {
            private DocumentHeaderHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocumentHeader();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocumentHeader();
            }
        }

        private class DocumentHandler
        extends AbstractElementHandler {
            private DocumentHandler() {
            }

            public void startElement(Attributes attributes) throws IFException {
                Handler.this.documentHandler.startDocument();
            }

            public void endElement() throws IFException {
                Handler.this.documentHandler.endDocument();
            }
        }

        private abstract class AbstractElementHandler
        implements ElementHandler {
            private AbstractElementHandler() {
            }

            public void startElement(Attributes attributes) throws IFException, SAXException {
            }

            public void endElement() throws IFException {
            }

            public boolean ignoreCharacters() {
                return true;
            }
        }

        private static interface ElementHandler {
            public void startElement(Attributes var1) throws IFException, SAXException;

            public void endElement() throws IFException;

            public boolean ignoreCharacters();
        }

        private final class StructureTreeHandler
        extends DefaultHandler {
            private final Locale pageSequenceLanguage;
            private final StructureTreeEventHandler structureTreeEventHandler;

            private StructureTreeHandler(StructureTreeEventHandler structureTreeEventHandler, Locale locale) throws SAXException {
                this.pageSequenceLanguage = locale;
                this.structureTreeEventHandler = structureTreeEventHandler;
            }

            void startStructureTree(String string) {
                this.structureTreeEventHandler.startPageSequence(this.pageSequenceLanguage, string);
            }

            public void endDocument() throws SAXException {
                Handler.this.startIFElement("page-sequence", Handler.this.pageSequenceAttributes);
                Handler.this.pageSequenceAttributes = null;
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (!"structure-tree".equals(string2)) {
                    String string4;
                    if (string2.equals("marked-content")) {
                        string2 = "#PCDATA";
                    }
                    if ((string4 = attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "struct-id")) == null) {
                        this.structureTreeEventHandler.startNode(string2, attributes);
                    } else if (string2.equals("external-graphic") || string2.equals("instream-foreign-object")) {
                        StructureTreeElement structureTreeElement = this.structureTreeEventHandler.startImageNode(string2, attributes);
                        Handler.this.structureTreeElements.put(string4, structureTreeElement);
                    } else {
                        StructureTreeElement structureTreeElement = this.structureTreeEventHandler.startReferencedNode(string2, attributes);
                        Handler.this.structureTreeElements.put(string4, structureTreeElement);
                    }
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (!"structure-tree".equals(string2)) {
                    this.structureTreeEventHandler.endNode(string2);
                }
            }
        }
    }
}

