/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public final class IFState {
    private IFState parent;
    private String fontFamily;
    private int fontSize;
    private String fontStyle;
    private int fontWeight;
    private String fontVariant;
    private boolean fontChanged = true;
    private Color textColor;

    private IFState() {
    }

    private IFState(IFState iFState) {
        this.parent = iFState;
        this.fontFamily = iFState.fontFamily;
        this.fontSize = iFState.fontSize;
        this.fontStyle = iFState.fontStyle;
        this.fontWeight = iFState.fontWeight;
        this.fontVariant = iFState.fontVariant;
        this.textColor = iFState.textColor;
    }

    public static IFState create() {
        return new IFState();
    }

    public IFState push() {
        return new IFState(this);
    }

    public IFState pop() {
        return this.parent;
    }

    public boolean isFontChanged() {
        return this.fontChanged;
    }

    public void resetFontChanged() {
        this.fontChanged = false;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String string) {
        if (!string.equals(this.fontFamily)) {
            this.fontChanged = true;
        }
        this.fontFamily = string;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        if (n != this.fontSize) {
            this.fontChanged = true;
        }
        this.fontSize = n;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String string) {
        if (!string.equals(this.fontStyle)) {
            this.fontChanged = true;
        }
        this.fontStyle = string;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(int n) {
        if (n != this.fontWeight) {
            this.fontChanged = true;
        }
        this.fontWeight = n;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public void setFontVariant(String string) {
        if (!string.equals(this.fontVariant)) {
            this.fontChanged = true;
        }
        this.fontVariant = string;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (!ColorUtil.isSameColor((Color)color, (Color)this.textColor)) {
            this.fontChanged = true;
        }
        this.textColor = color;
    }
}

