/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.FontMetricsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFontMetricsMapper
extends Typeface
implements FontMetricsMapper {
    private Typeface typeface;
    private Font font;
    private float size = 1.0f;
    private static final int TYPE1_FONT = 1;

    public CustomFontMetricsMapper(CustomFont customFont) throws FontFormatException, IOException {
        this.typeface = customFont;
        this.initialize(customFont.getEmbedFileSource());
    }

    public CustomFontMetricsMapper(LazyFont lazyFont, Source source) throws FontFormatException, IOException {
        this.typeface = lazyFont;
        this.initialize(source);
    }

    private void initialize(Source source) throws FontFormatException, IOException {
        int n = 0;
        if (FontType.TYPE1.equals(this.typeface.getFontType())) {
            n = 1;
        }
        InputStream inputStream = null;
        if (source instanceof StreamSource) {
            inputStream = ((StreamSource)source).getInputStream();
        } else if (source.getSystemId() != null) {
            inputStream = new URL(source.getSystemId()).openStream();
        } else {
            throw new IllegalArgumentException("No font source provided.");
        }
        this.font = Font.createFont(n, inputStream);
        inputStream.close();
    }

    @Override
    public final String getEncodingName() {
        return null;
    }

    @Override
    public final boolean hasChar(char c) {
        return this.font.canDisplay(c);
    }

    @Override
    public final char mapChar(char c) {
        return this.typeface.mapChar(c);
    }

    @Override
    public final Font getFont(int n) {
        if (this.size == (float)n) {
            return this.font;
        }
        this.size = (float)n / 1000.0f;
        this.font = this.font.deriveFont(this.size);
        return this.font;
    }

    @Override
    public final int getAscender(int n) {
        return this.typeface.getAscender(n);
    }

    @Override
    public final int getCapHeight(int n) {
        return this.typeface.getCapHeight(n);
    }

    @Override
    public final int getDescender(int n) {
        return this.typeface.getDescender(n);
    }

    @Override
    public final String getEmbedFontName() {
        return this.typeface.getEmbedFontName();
    }

    @Override
    public final Set<String> getFamilyNames() {
        return this.typeface.getFamilyNames();
    }

    @Override
    public final String getFontName() {
        return this.typeface.getFontName();
    }

    @Override
    public final FontType getFontType() {
        return this.typeface.getFontType();
    }

    @Override
    public final String getFullName() {
        return this.typeface.getFullName();
    }

    public final Map getKerningInfo() {
        return this.typeface.getKerningInfo();
    }

    @Override
    public final int getWidth(int n, int n2) {
        return this.typeface.getWidth(n, n2);
    }

    @Override
    public final int[] getWidths() {
        return this.typeface.getWidths();
    }

    @Override
    public final int getXHeight(int n) {
        return this.typeface.getXHeight(n);
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.typeface.hasKerningInfo();
    }
}

