/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;

public class Java2DBorderPainter
extends BorderPainter {
    private static Log log = LogFactory.getLog(Java2DBorderPainter.class);
    private Java2DPainter painter;
    private GeneralPath currentPath = null;

    public Java2DBorderPainter(Java2DPainter java2DPainter) {
        this.painter = java2DPainter;
    }

    private Java2DGraphicsState getG2DState() {
        return this.painter.g2dState;
    }

    private Graphics2D getG2D() {
        return this.getG2DState().getGraph();
    }

    protected void drawBorderLine(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Color color) {
        float f = n3 - n;
        float f2 = n4 - n2;
        if (f < 0.0f || f2 < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (n5) {
            case 31: {
                this.getG2D().setColor(color);
                if (bl) {
                    float f3 = Math.abs(2.0f * f2);
                    int n6 = (int)(f / f3);
                    if (n6 % 2 == 0) {
                        ++n6;
                    }
                    f3 = f / (float)n6;
                    float f4 = (float)n2 + f2 / 2.0f;
                    BasicStroke basicStroke = new BasicStroke(f2, 0, 0, 10.0f, new float[]{f3}, 0.0f);
                    this.getG2D().setStroke(basicStroke);
                    this.getG2D().draw(new Line2D.Float(n, f4, n3, f4));
                    break;
                }
                float f5 = Math.abs(2.0f * f);
                int n7 = (int)(f2 / f5);
                if (n7 % 2 == 0) {
                    ++n7;
                }
                f5 = f2 / (float)n7;
                float f6 = (float)n + f / 2.0f;
                BasicStroke basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{f5}, 0.0f);
                this.getG2D().setStroke(basicStroke);
                this.getG2D().draw(new Line2D.Float(f6, n2, f6, n4));
                break;
            }
            case 36: {
                this.getG2D().setColor(color);
                if (bl) {
                    float f7 = Math.abs(2.0f * f2);
                    int n8 = (int)(f / f7);
                    if (n8 % 2 == 0) {
                        ++n8;
                    }
                    f7 = f / (float)n8;
                    float f8 = (float)n2 + f2 / 2.0f;
                    BasicStroke basicStroke = new BasicStroke(f2, 1, 0, 10.0f, new float[]{0.0f, f7}, 0.0f);
                    this.getG2D().setStroke(basicStroke);
                    this.getG2D().draw(new Line2D.Float(n, f8, n3, f8));
                    break;
                }
                float f9 = Math.abs(2.0f * f);
                int n9 = (int)(f2 / f9);
                if (n9 % 2 == 0) {
                    ++n9;
                }
                f9 = f2 / (float)n9;
                float f10 = (float)n + f / 2.0f;
                BasicStroke basicStroke = new BasicStroke(f, 1, 0, 10.0f, new float[]{0.0f, f9}, 0.0f);
                this.getG2D().setStroke(basicStroke);
                this.getG2D().draw(new Line2D.Float(f10, n2, f10, n4));
                break;
            }
            case 37: {
                this.getG2D().setColor(color);
                if (bl) {
                    float f11 = f2 / 3.0f;
                    float f12 = (float)n2 + f11 / 2.0f;
                    float f13 = f12 + f11 + f11;
                    BasicStroke basicStroke = new BasicStroke(f11);
                    this.getG2D().setStroke(basicStroke);
                    this.getG2D().draw(new Line2D.Float(n, f12, n3, f12));
                    this.getG2D().draw(new Line2D.Float(n, f13, n3, f13));
                    break;
                }
                float f14 = f / 3.0f;
                float f15 = (float)n + f14 / 2.0f;
                float f16 = f15 + f14 + f14;
                BasicStroke basicStroke = new BasicStroke(f14);
                this.getG2D().setStroke(basicStroke);
                this.getG2D().draw(new Line2D.Float(f15, n2, f15, n4));
                this.getG2D().draw(new Line2D.Float(f16, n2, f16, n4));
                break;
            }
            case 55: 
            case 119: {
                float f17;
                float f18 = f17 = n5 == 55 ? 0.4f : -0.4f;
                if (bl) {
                    Color color2 = ColorUtil.lightenColor(color, -f17);
                    Color color3 = ColorUtil.lightenColor(color, f17);
                    float f19 = f2 / 3.0f;
                    float f20 = (float)n2 + f19 / 2.0f;
                    this.getG2D().setStroke(new BasicStroke(f19));
                    this.getG2D().setColor(color2);
                    this.getG2D().draw(new Line2D.Float(n, f20, n3, f20));
                    this.getG2D().setColor(color);
                    this.getG2D().draw(new Line2D.Float(n, f20 + f19, n3, f20 + f19));
                    this.getG2D().setColor(color3);
                    this.getG2D().draw(new Line2D.Float(n, f20 + f19 + f19, n3, f20 + f19 + f19));
                    break;
                }
                Color color4 = ColorUtil.lightenColor(color, -f17);
                Color color5 = ColorUtil.lightenColor(color, f17);
                float f21 = f / 3.0f;
                float f22 = (float)n + f21 / 2.0f;
                this.getG2D().setStroke(new BasicStroke(f21));
                this.getG2D().setColor(color4);
                this.getG2D().draw(new Line2D.Float(f22, n2, f22, n4));
                this.getG2D().setColor(color);
                this.getG2D().draw(new Line2D.Float(f22 + f21, n2, f22 + f21, n4));
                this.getG2D().setColor(color5);
                this.getG2D().draw(new Line2D.Float(f22 + f21 + f21, n2, f22 + f21 + f21, n4));
                break;
            }
            case 67: 
            case 101: {
                float f23;
                float f24 = f23 = n5 == 101 ? 0.4f : -0.4f;
                if (bl) {
                    color = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f23);
                    this.getG2D().setStroke(new BasicStroke(f2));
                    float f25 = (float)n2 + f2 / 2.0f;
                    this.getG2D().setColor(color);
                    this.getG2D().draw(new Line2D.Float(n, f25, n3, f25));
                    break;
                }
                color = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f23);
                float f26 = (float)n + f / 2.0f;
                this.getG2D().setStroke(new BasicStroke(f));
                this.getG2D().setColor(color);
                this.getG2D().draw(new Line2D.Float(f26, n2, f26, n4));
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.getG2D().setColor(color);
                if (bl) {
                    float f27 = (float)n2 + f2 / 2.0f;
                    this.getG2D().setStroke(new BasicStroke(f2));
                    this.getG2D().draw(new Line2D.Float(n, f27, n3, f27));
                    break;
                }
                float f28 = (float)n + f / 2.0f;
                this.getG2D().setStroke(new BasicStroke(f));
                this.getG2D().draw(new Line2D.Float(f28, n2, f28, n4));
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) {
        if (point.y != point2.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int n2 = n / 2;
        int n3 = point.y - n2;
        Rectangle rectangle = new Rectangle(point.x, point.y - n2, point2.x - point.x, n);
        this.getG2DState().updateClip(rectangle);
        switch (ruleStyle.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(point.x, point.y - n2, point2.x, point2.y + n2, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 36: {
                int n4 = n2;
                this.drawBorderLine(point.x + n4, point.y - n2, point2.x + n4, point2.y + n2, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.getG2DState().updateColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(point.x, n3);
                this.lineTo(point2.x, n3);
                this.lineTo(point2.x, n3 + 2 * n2);
                this.lineTo(point.x, n3 + 2 * n2);
                this.closePath();
                this.getG2D().fill(this.currentPath);
                this.currentPath = null;
                this.getG2DState().updateColor(color);
                if (ruleStyle.getEnumValue() == 55) {
                    this.moveTo(point.x, n3);
                    this.lineTo(point2.x, n3);
                    this.lineTo(point2.x, n3 + n2);
                    this.lineTo(point.x + n2, n3 + n2);
                    this.lineTo(point.x, n3 + 2 * n2);
                } else {
                    this.moveTo(point2.x, n3);
                    this.lineTo(point2.x, n3 + 2 * n2);
                    this.lineTo(point.x, n3 + 2 * n2);
                    this.lineTo(point.x, n3 + n2);
                    this.lineTo(point2.x - n2, n3 + n2);
                }
                this.closePath();
                this.getG2D().fill(this.currentPath);
                this.currentPath = null;
            }
            case 95: {
                break;
            }
        }
        this.restoreGraphicsState();
    }

    protected void clip() {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.getG2DState().updateClip(this.currentPath);
        this.currentPath = null;
    }

    protected void closePath() {
        this.currentPath.closePath();
    }

    protected void lineTo(int n, int n2) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(n, n2);
    }

    protected void moveTo(int n, int n2) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(n, n2);
    }

    protected void saveGraphicsState() {
        this.painter.saveGraphicsState();
    }

    protected void restoreGraphicsState() {
        this.painter.restoreGraphicsState();
        this.currentPath = null;
    }
}

