/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class Java2DFontMetrics {
    public static final int FONT_SIZE = 1;
    public static final int FONT_FACTOR = 1000000;
    private int[] width = null;
    private int xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private Font f1 = null;
    private String family = "";
    private int style = 0;
    private float size = 0.0f;
    private FontMetrics fmt = null;
    private LineMetrics lineMetrics;
    private final Graphics2D graphics = Java2DFontMetrics.createFontMetricsGraphics2D();

    private static Graphics2D createFontMetricsGraphics2D() {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return graphics2D;
    }

    public int getMaxAscent(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return Math.round(this.lineMetrics.getAscent() * 1000000.0f);
    }

    public int getAscender(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return this.ascender * 1000;
    }

    public int getCapHeight(String string, int n, int n2) {
        return this.getAscender(string, n, n2);
    }

    public int getDescender(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return this.descender * 1000;
    }

    public int getXHeight(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return this.xHeight * 1000;
    }

    public int width(int n, String string, int n2, int n3) {
        this.setFont(string, n2, n3);
        int n4 = this.internalCharWidth(n) * 1000;
        return n4;
    }

    private int internalCharWidth(int n) {
        char[] cArray = new char[]{(char)n};
        Rectangle2D rectangle2D = this.fmt.getStringBounds(cArray, 0, 1, (Graphics)this.graphics);
        return (int)Math.round(rectangle2D.getWidth() * 1000.0);
    }

    public int[] getWidths(String string, int n, int n2) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.setFont(string, n, n2);
        for (int i = 0; i < 256; ++i) {
            this.width[i] = 1000 * this.internalCharWidth(i);
        }
        return this.width;
    }

    private Font getBaseFont(String string, int n, float f) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, string);
        if ((n & 1) != 0) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((n & 2) != 0) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        hashMap.put(TextAttribute.SIZE, new Float(f));
        return new Font(hashMap);
    }

    private boolean setFont(String string, int n, int n2) {
        boolean bl = false;
        float f = (float)n2 / 1000.0f;
        if (this.f1 == null) {
            this.f1 = this.getBaseFont(string, n, f);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            bl = true;
        } else if (this.style != n || !this.family.equals(string) || this.size != f) {
            this.f1 = string.equals(this.family) ? this.f1.deriveFont(n, f) : this.getBaseFont(string, n, f);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            bl = true;
        }
        if (bl) {
            TextLayout textLayout = new TextLayout("x", this.f1, this.graphics.getFontRenderContext());
            Rectangle2D rectangle2D = textLayout.getBounds();
            this.xHeight = (int)Math.round(-rectangle2D.getY() * 1000.0);
            textLayout = new TextLayout("d", this.f1, this.graphics.getFontRenderContext());
            rectangle2D = textLayout.getBounds();
            this.ascender = (int)Math.round(-rectangle2D.getY() * 1000.0);
            textLayout = new TextLayout("p", this.f1, this.graphics.getFontRenderContext());
            rectangle2D = textLayout.getBounds();
            this.descender = (int)Math.round((rectangle2D.getY() + rectangle2D.getHeight()) * -1000.0);
            this.lineMetrics = this.f1.getLineMetrics("", this.graphics.getFontRenderContext());
        }
        this.family = string;
        this.style = n;
        this.size = f;
        return bl;
    }

    public Font getFont(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return this.f1;
    }

    public boolean hasChar(String string, int n, int n2, char c) {
        this.setFont(string, n, n2);
        return this.f1.canDisplay(c);
    }
}

