/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.Java2DFontMetrics;

public class SystemFontMetricsMapper
extends Typeface
implements FontMetricsMapper {
    private final Java2DFontMetrics java2DFontMetrics;
    private final String family;
    private final int style;

    public SystemFontMetricsMapper(String string, int n, Java2DFontMetrics java2DFontMetrics) {
        this.family = string;
        this.style = n;
        this.java2DFontMetrics = java2DFontMetrics;
    }

    public String getFontName() {
        return this.family;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return this.getFontName();
    }

    public Set getFamilyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.family);
        return hashSet;
    }

    public FontType getFontType() {
        return FontType.OTHER;
    }

    public int getMaxAscent(int n) {
        return this.java2DFontMetrics.getMaxAscent(this.family, this.style, n);
    }

    public int getAscender(int n) {
        return this.java2DFontMetrics.getAscender(this.family, this.style, n);
    }

    public int getCapHeight(int n) {
        return this.java2DFontMetrics.getCapHeight(this.family, this.style, n);
    }

    public int getDescender(int n) {
        return this.java2DFontMetrics.getDescender(this.family, this.style, n);
    }

    public int getXHeight(int n) {
        return this.java2DFontMetrics.getXHeight(this.family, this.style, n);
    }

    public int getWidth(int n, int n2) {
        return this.java2DFontMetrics.width(n, this.family, this.style, n2);
    }

    public int[] getWidths() {
        return this.java2DFontMetrics.getWidths(this.family, this.style, 1);
    }

    public Font getFont(int n) {
        return this.java2DFontMetrics.getFont(this.family, this.style, n);
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public String getEncodingName() {
        return null;
    }

    public char mapChar(char c) {
        return c;
    }

    public boolean hasChar(char c) {
        return this.java2DFontMetrics.hasChar(this.family, this.style, 1, c);
    }
}

