/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.render.java2d.Java2DUtil;
import org.apache.fop.render.pcl.PCLConstants;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLPageDefinition;
import org.apache.fop.render.pcl.PCLPainter;
import org.apache.fop.render.pcl.PCLRendererConfigurator;
import org.apache.fop.render.pcl.PCLRenderingMode;
import org.apache.fop.render.pcl.PCLRenderingUtil;
import org.apache.fop.render.pcl.extensions.PCLElementMapping;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler
implements PCLConstants {
    private static Log log = LogFactory.getLog(PCLDocumentHandler.class);
    protected PCLRenderingUtil pclUtil;
    private PCLGenerator gen;
    private PCLPageDefinition currentPageDefinition;
    private long pageWidth = 0L;
    private long pageHeight = 0L;
    private BufferedImage currentImage;

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/x-pcl";
    }

    public void setContext(IFContext iFContext) {
        super.setContext(iFContext);
        this.pclUtil = new PCLRenderingUtil(iFContext.getUserAgent());
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new PCLRendererConfigurator(this.getUserAgent());
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontInfo fontInfo2 = Java2DUtil.buildDefaultJava2DBasedFontInfo(fontInfo, this.getUserAgent());
        this.setFontInfo(fontInfo2);
    }

    PCLRenderingUtil getPCLUtil() {
        return this.pclUtil;
    }

    PCLGenerator getPCLGenerator() {
        return this.gen;
    }

    protected int getResolution() {
        int n = Math.round(this.getUserAgent().getTargetResolution());
        if (n <= 300) {
            return 300;
        }
        return 600;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.gen = new PCLGenerator(this.outputStream, this.getResolution());
            this.gen.setDitheringQuality(this.pclUtil.getDitheringQuality());
            if (!this.pclUtil.isPJLDisabled()) {
                this.gen.universalEndOfLanguage();
                this.gen.writeText("@PJL COMMENT Produced by " + this.getUserAgent().getProducer() + "\n");
                if (this.getUserAgent().getTitle() != null) {
                    this.gen.writeText("@PJL JOB NAME = \"" + this.getUserAgent().getTitle() + "\"\n");
                }
                this.gen.writeText("@PJL SET RESOLUTION = " + this.getResolution() + "\n");
                this.gen.writeText("@PJL ENTER LANGUAGE = PCL\n");
            }
            this.gen.resetPrinter();
            this.gen.setUnitOfMeasure(this.getResolution());
            this.gen.setRasterGraphicsResolution(this.getResolution());
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startDocument()", iOException);
        }
    }

    public void endDocumentHeader() throws IFException {
    }

    public void endDocument() throws IFException {
        try {
            this.gen.separateJobs();
            this.gen.resetPrinter();
            if (!this.pclUtil.isPJLDisabled()) {
                this.gen.universalEndOfLanguage();
            }
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endDocument()", iOException);
        }
        super.endDocument();
    }

    public void startPageSequence(String string) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        try {
            Object object;
            Object object2;
            Object object3 = this.getContext().getForeignAttribute(PCLElementMapping.PCL_PAPER_SOURCE);
            if (object3 != null) {
                this.gen.selectPaperSource(Integer.parseInt(object3.toString()));
            }
            if ((object2 = this.getContext().getForeignAttribute(PCLElementMapping.PCL_OUTPUT_BIN)) != null) {
                this.gen.selectOutputBin(Integer.parseInt(object2.toString()));
            }
            if ((object = this.getContext().getForeignAttribute(PCLElementMapping.PCL_DUPLEX_MODE)) != null) {
                this.gen.selectDuplexMode(Integer.parseInt(object.toString()));
            }
            long l = dimension.width;
            long l2 = dimension.height;
            this.selectPageFormat(l, l2);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startPage()", iOException);
        }
    }

    public IFPainter startPageContent() throws IFException {
        if (this.pclUtil.getRenderingMode() == PCLRenderingMode.BITMAP) {
            return this.createAllBitmapPainter();
        }
        return new PCLPainter(this, this.currentPageDefinition);
    }

    private IFPainter createAllBitmapPainter() {
        double d = (float)this.gen.getMaximumBitmapResolution() / 72.0f;
        Rectangle rectangle = this.currentPageDefinition.getLogicalPageRect();
        int n = (int)Math.ceil(UnitConv.mpt2px((double)rectangle.width, (int)this.gen.getMaximumBitmapResolution()));
        int n2 = (int)Math.ceil(UnitConv.mpt2px((double)rectangle.height, (int)this.gen.getMaximumBitmapResolution()));
        this.currentImage = this.createBufferedImage(n, n2);
        Graphics2D graphics2D = this.currentImage.createGraphics();
        if (!PCLGenerator.isJAIAvailable()) {
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics2D.addRenderingHints(renderingHints);
        }
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.scale(d / 1000.0, d / 1000.0);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        return new Java2DPainter(graphics2D, this.getContext(), this.getFontInfo());
    }

    private BufferedImage createBufferedImage(int n, int n2) {
        int n3 = PCLGenerator.isJAIAvailable() ? 10 : 12;
        return new BufferedImage(n, n2, n3);
    }

    public void endPageContent() throws IFException {
        if (this.currentImage != null) {
            try {
                Rectangle rectangle = this.currentPageDefinition.getLogicalPageRect();
                this.gen.setCursorPos(0.0, 0.0);
                this.gen.paintBitmap(this.currentImage, rectangle.getSize(), true);
            }
            catch (IOException iOException) {
                throw new IFException("I/O error while encoding page image", iOException);
            }
            finally {
                this.currentImage = null;
            }
        }
    }

    public void endPage() throws IFException {
        try {
            this.gen.formFeed();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPage()", iOException);
        }
    }

    public void handleExtensionObject(Object object) throws IFException {
        log.debug((Object)("Don't know how to handle extension object. Ignoring: " + object + " (" + object.getClass().getName() + ")"));
    }

    private void selectPageFormat(long l, long l2) throws IOException {
        if (l != this.pageWidth || l2 != this.pageHeight) {
            this.pageWidth = l;
            this.pageHeight = l2;
            this.currentPageDefinition = PCLPageDefinition.getPageDefinition(l, l2, 1000);
            if (this.currentPageDefinition == null) {
                this.currentPageDefinition = PCLPageDefinition.getDefaultPageDefinition();
                log.warn((Object)("Paper type could not be determined. Falling back to: " + this.currentPageDefinition.getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("page size: " + this.currentPageDefinition.getPhysicalPageSize()));
                log.debug((Object)("logical page: " + this.currentPageDefinition.getLogicalPageRect()));
            }
            if (this.currentPageDefinition.isLandscapeFormat()) {
                this.gen.writeCommand("&l1O");
            } else {
                this.gen.writeCommand("&l0O");
            }
            this.gen.selectPageSize(this.currentPageDefinition.getSelector());
            this.gen.clearHorizontalMargins();
            this.gen.setTopMargin(0);
        }
    }
}

