/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLGraphics2D
extends AbstractGraphics2D {
    protected PCLGenerator gen;
    private final boolean failOnUnsupportedFeature = true;
    private boolean clippingDisabled = false;
    private Graphics2D fmg;

    public PCLGraphics2D(PCLGenerator pCLGenerator) {
        super(true);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.gen = pCLGenerator;
    }

    public PCLGraphics2D(PCLGraphics2D pCLGraphics2D) {
        super(true);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.gen = pCLGraphics2D.gen;
    }

    public Graphics create() {
        PCLGraphics2D pCLGraphics2D = new PCLGraphics2D(this);
        pCLGraphics2D.setGraphicContext((GraphicContext)this.getGraphicContext().clone());
        return pCLGraphics2D;
    }

    public void dispose() {
        this.gen = null;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    public void setClippingDisabled(boolean bl) {
        this.clippingDisabled = bl;
    }

    public void handleIOException(IOException iOException) {
        iOException.printStackTrace();
    }

    protected void handleUnsupportedFeature(String string) {
        ((Object)((Object)this)).getClass();
        throw new UnsupportedOperationException(string);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    protected void applyStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            int n;
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                int n2;
                this.gen.writeText("UL1,");
                n = Math.min(20, fArray.length);
                float f = 0.0f;
                for (n2 = 0; n2 < n; ++n2) {
                    f += fArray[n2];
                }
                if (n == 1) {
                    f *= 2.0f;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    float f2 = fArray[n2] * 100.0f / f;
                    this.gen.writeText(this.gen.formatDouble2(f2));
                    if (n2 >= fArray.length - 1) continue;
                    this.gen.writeText(",");
                }
                if (n == 1) {
                    this.gen.writeText("," + this.gen.formatDouble2(fArray[0] * 100.0f / f));
                }
                this.gen.writeText(";");
                Point2D.Double double_ = new Point2D.Double(f, 0.0);
                this.getTransform().deltaTransform(double_, double_);
                double d = UnitConv.pt2mm((double)double_.distance(0.0, 0.0));
                this.gen.writeText("LT1," + this.gen.formatDouble4(d) + ",1;");
            } else {
                this.gen.writeText("LT;");
            }
            this.gen.writeText("LA1");
            n = basicStroke.getEndCap();
            switch (n) {
                case 0: {
                    this.gen.writeText(",1");
                    break;
                }
                case 1: {
                    this.gen.writeText(",4");
                    break;
                }
                case 2: {
                    this.gen.writeText(",2");
                    break;
                }
                default: {
                    System.err.println("Unsupported line cap: " + n);
                }
            }
            this.gen.writeText(",2");
            int n3 = basicStroke.getLineJoin();
            switch (n3) {
                case 0: {
                    this.gen.writeText(",1");
                    break;
                }
                case 1: {
                    this.gen.writeText(",4");
                    break;
                }
                case 2: {
                    this.gen.writeText(",5");
                    break;
                }
                default: {
                    System.err.println("Unsupported line join: " + n3);
                }
            }
            float f = basicStroke.getMiterLimit();
            this.gen.writeText(",3" + this.gen.formatDouble4(f));
            float f3 = basicStroke.getLineWidth();
            Point2D.Double double_ = new Point2D.Double(f3, 0.0);
            Point2D point2D = this.getTransform().deltaTransform(double_, null);
            double d = UnitConv.pt2mm((double)point2D.distance(0.0, 0.0));
            this.gen.writeText(";PW" + this.gen.formatDouble4(d) + ";");
        } else {
            this.handleUnsupportedFeature("Unsupported Stroke: " + stroke.getClass().getName());
        }
    }

    protected void applyPaint(Paint paint) throws IOException {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            int n = this.gen.convertToPCLShade(color);
            this.gen.writeText("TR0;FT10," + n + ";");
        } else {
            this.handleUnsupportedFeature("Unsupported Paint: " + paint.getClass().getName());
        }
    }

    private void writeClip(Shape shape) throws IOException {
        if (this.clippingDisabled) {
            return;
        }
        if (shape != null) {
            this.handleUnsupportedFeature("Clipping is not supported. Shape: " + shape);
        }
    }

    public void draw(Shape shape) {
        try {
            AffineTransform affineTransform = this.getTransform();
            Shape shape2 = this.getClip();
            this.writeClip(shape2);
            if (!Color.black.equals(this.getColor())) {
                this.handleUnsupportedFeature("Only black is supported as stroke color: " + this.getColor());
            }
            this.applyStroke(this.getStroke());
            PathIterator pathIterator = shape.getPathIterator(affineTransform);
            this.processPathIteratorStroke(pathIterator);
            this.writeClip(null);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public void fill(Shape shape) {
        try {
            AffineTransform affineTransform = this.getTransform();
            Shape shape2 = this.getClip();
            this.writeClip(shape2);
            this.applyPaint(this.getPaint());
            PathIterator pathIterator = shape.getPathIterator(affineTransform);
            this.processPathIteratorFill(pathIterator);
            this.writeClip(null);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public void processPathIteratorStroke(PathIterator pathIterator) throws IOException {
        this.gen.writeText("\n");
        double[] dArray = new double[6];
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        StringBuffer stringBuffer = new StringBuffer(256);
        this.penUp(stringBuffer);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 4) {
                this.gen.writeText("PM;");
                this.gen.writeText(stringBuffer.toString());
                this.gen.writeText("PM2;EP;");
                stringBuffer.setLength(0);
                pathIterator.next();
                continue;
            }
            if (n == 0) {
                this.gen.writeText(stringBuffer.toString());
                stringBuffer.setLength(0);
                if (bl) {
                    this.penUp(stringBuffer);
                    bl = false;
                }
            } else if (!bl) {
                this.penDown(stringBuffer);
                bl = true;
            }
            switch (n) {
                case 4: {
                    break;
                }
                case 0: {
                    d = dArray[0];
                    d2 = dArray[1];
                    this.plotAbsolute(d, d2, stringBuffer);
                    this.gen.writeText(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    break;
                }
                case 1: {
                    d = dArray[0];
                    d2 = dArray[1];
                    this.plotAbsolute(d, d2, stringBuffer);
                    break;
                }
                case 3: {
                    d = dArray[4];
                    d2 = dArray[5];
                    this.bezierAbsolute(dArray[0], dArray[1], dArray[2], dArray[3], d, d2, stringBuffer);
                    break;
                }
                case 2: {
                    double d3 = d;
                    double d4 = d2;
                    d = dArray[2];
                    d2 = dArray[3];
                    this.quadraticBezierAbsolute(d3, d4, dArray[0], dArray[1], d, d2, stringBuffer);
                    break;
                }
            }
            pathIterator.next();
        }
        stringBuffer.append("\n");
        this.gen.writeText(stringBuffer.toString());
    }

    public void processPathIteratorFill(PathIterator pathIterator) throws IOException {
        this.gen.writeText("\n");
        double[] dArray = new double[6];
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer(256);
        this.penUp(stringBuffer);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 4) {
                stringBuffer.append("PM1;");
                pathIterator.next();
                continue;
            }
            if (n == 0) {
                if (bl) {
                    this.penUp(stringBuffer);
                    bl = false;
                }
            } else if (!bl) {
                this.penDown(stringBuffer);
                bl = true;
            }
            switch (n) {
                case 0: {
                    d = dArray[0];
                    d2 = dArray[1];
                    this.plotAbsolute(d, d2, stringBuffer);
                    break;
                }
                case 1: {
                    d = dArray[0];
                    d2 = dArray[1];
                    this.plotAbsolute(d, d2, stringBuffer);
                    break;
                }
                case 3: {
                    d = dArray[4];
                    d2 = dArray[5];
                    this.bezierAbsolute(dArray[0], dArray[1], dArray[2], dArray[3], d, d2, stringBuffer);
                    break;
                }
                case 2: {
                    double d3 = d;
                    double d4 = d2;
                    d = dArray[2];
                    d2 = dArray[3];
                    this.quadraticBezierAbsolute(d3, d4, dArray[0], dArray[1], d, d2, stringBuffer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not get here");
                }
            }
            if (bl2) {
                bl2 = false;
                stringBuffer.append("PM;");
            }
            pathIterator.next();
        }
        stringBuffer.append("PM2;");
        this.fillPolygon(pathIterator.getWindingRule(), stringBuffer);
        stringBuffer.append("\n");
        this.gen.writeText(stringBuffer.toString());
    }

    private void fillPolygon(int n, StringBuffer stringBuffer) {
        int n2 = n == 0 ? 0 : 1;
        stringBuffer.append("FP").append(n2).append(";");
    }

    private void plotAbsolute(double d, double d2, StringBuffer stringBuffer) {
        stringBuffer.append("PA").append(this.gen.formatDouble4(d));
        stringBuffer.append(",").append(this.gen.formatDouble4(d2)).append(";");
    }

    private void bezierAbsolute(double d, double d2, double d3, double d4, double d5, double d6, StringBuffer stringBuffer) {
        stringBuffer.append("BZ").append(this.gen.formatDouble4(d));
        stringBuffer.append(",").append(this.gen.formatDouble4(d2));
        stringBuffer.append(",").append(this.gen.formatDouble4(d3));
        stringBuffer.append(",").append(this.gen.formatDouble4(d4));
        stringBuffer.append(",").append(this.gen.formatDouble4(d5));
        stringBuffer.append(",").append(this.gen.formatDouble4(d6)).append(";");
    }

    private void quadraticBezierAbsolute(double d, double d2, double d3, double d4, double d5, double d6, StringBuffer stringBuffer) {
        double d7 = d + 0.6666666666666666 * (d3 - d);
        double d8 = d2 + 0.6666666666666666 * (d4 - d2);
        double d9 = d7 + 0.3333333333333333 * (d5 - d);
        double d10 = d8 + 0.3333333333333333 * (d6 - d2);
        this.bezierAbsolute(d7, d8, d9, d10, d5, d6, stringBuffer);
    }

    private void penDown(StringBuffer stringBuffer) {
        stringBuffer.append("PD;");
    }

    private void penUp(StringBuffer stringBuffer) {
        stringBuffer.append("PU;");
    }

    public void drawString(String string, float f, float f2) {
        Font font = this.getFont();
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.handleUnsupportedFeature("drawString NYI");
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.handleUnsupportedFeature("Bitmap images are not supported");
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.handleUnsupportedFeature("Bitmap images are not supported");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.handleUnsupportedFeature("Bitmap images are not supported");
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.handleUnsupportedFeature("Bitmap images are not supported");
        return false;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.handleUnsupportedFeature("copyArea NYI");
    }

    public void setXORMode(Color color) {
        this.handleUnsupportedFeature("setXORMode NYI");
    }

    protected BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 10);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }
}

