/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.ConfiguredFontCollection;
import org.apache.fop.render.java2d.InstalledFontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.pcl.PCLDocumentHandler;
import org.apache.fop.render.pcl.PCLRenderingMode;
import org.apache.fop.render.pcl.PCLRenderingUtil;

public class PCLRendererConfigurator
extends PrintRendererConfigurator
implements IFDocumentHandlerConfigurator {
    public PCLRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public void configure(Renderer renderer) {
        throw new UnsupportedOperationException();
    }

    private void configure(Configuration configuration, PCLRenderingUtil pCLRenderingUtil) throws FOPException {
        String string;
        String string2 = configuration.getChild("rendering").getValue(null);
        if (string2 != null) {
            try {
                pCLRenderingUtil.setRenderingMode(PCLRenderingMode.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FOPException("Valid values for 'rendering' are 'quality', 'speed' and 'bitmap'. Value found: " + string2);
            }
        }
        if ("bitmap".equalsIgnoreCase(string = configuration.getChild("text-rendering").getValue(null))) {
            pCLRenderingUtil.setAllTextAsBitmaps(true);
        } else if ("auto".equalsIgnoreCase(string)) {
            pCLRenderingUtil.setAllTextAsBitmaps(false);
        } else if (string != null) {
            throw new FOPException("Valid values for 'text-rendering' are 'auto' and 'bitmap'. Value found: " + string);
        }
        pCLRenderingUtil.setPJLDisabled(configuration.getChild("disable-pjl").getValueAsBoolean(false));
    }

    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            PCLDocumentHandler pCLDocumentHandler = (PCLDocumentHandler)iFDocumentHandler;
            PCLRenderingUtil pCLRenderingUtil = pCLDocumentHandler.getPCLUtil();
            this.configure(configuration, pCLRenderingUtil);
        }
    }

    public void setupFontInfo(IFDocumentHandler iFDocumentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        Java2DFontMetrics java2DFontMetrics = new Java2DFontMetrics();
        ArrayList<FontCollection> arrayList = new ArrayList<FontCollection>();
        arrayList.add(new Base14FontCollection(java2DFontMetrics));
        arrayList.add(new InstalledFontCollection(java2DFontMetrics));
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            DefaultFontResolver defaultFontResolver = new DefaultFontResolver(this.userAgent);
            FontEventAdapter fontEventAdapter = new FontEventAdapter(this.userAgent.getEventBroadcaster());
            List<EmbedFontInfo> list = this.buildFontList(configuration, defaultFontResolver, fontEventAdapter);
            arrayList.add(new ConfiguredFontCollection(defaultFontResolver, list, this.userAgent.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, arrayList.toArray(new FontCollection[arrayList.size()]));
        iFDocumentHandler.setFontInfo(fontInfo);
    }
}

