/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;

abstract class AbstractPDFImageHandler
implements ImageHandler {
    AbstractPDFImageHandler() {
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        assert (renderingContext instanceof PDFRenderingContext);
        PDFRenderingContext pDFRenderingContext = (PDFRenderingContext)renderingContext;
        PDFContentGenerator pDFContentGenerator = pDFRenderingContext.getGenerator();
        PDFImage pDFImage = this.createPDFImage(image, image.getInfo().getOriginalURI());
        PDFImageXObject pDFImageXObject = pDFContentGenerator.getDocument().addImage(pDFContentGenerator.getResourceContext(), pDFImage);
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        if (renderingContext.getUserAgent().isAccessibilityEnabled()) {
            PDFLogicalStructureHandler.MarkedContentInfo markedContentInfo = pDFRenderingContext.getMarkedContentInfo();
            pDFContentGenerator.placeImage(f, f2, f3, f4, pDFImageXObject, markedContentInfo.tag, markedContentInfo.mcid);
        } else {
            pDFContentGenerator.placeImage(f, f2, f3, f4, pDFImageXObject);
        }
    }

    abstract PDFImage createPDFImage(Image var1, String var2);
}

