/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.geom.AffineTransform;
import org.apache.fop.area.CTM;
import org.apache.fop.pdf.PDFNumber;

public final class CTMHelper {
    private CTMHelper() {
    }

    public static String toPDFString(CTM cTM) {
        if (null == cTM) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] dArray = CTMHelper.toPDFArray(cTM);
        return CTMHelper.constructPDFArray(dArray);
    }

    public static String toPDFString(AffineTransform affineTransform, boolean bl) {
        if (null == affineTransform) {
            throw new NullPointerException("transform must not be null");
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (bl) {
            dArray[4] = dArray[4] / 1000.0;
            dArray[5] = dArray[5] / 1000.0;
        }
        return CTMHelper.constructPDFArray(dArray);
    }

    private static String constructPDFArray(double[] dArray) {
        return PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " " + PDFNumber.doubleOut(dArray[2], 8) + " " + PDFNumber.doubleOut(dArray[3], 8) + " " + PDFNumber.doubleOut(dArray[4], 8) + " " + PDFNumber.doubleOut(dArray[5], 8);
    }

    public static CTM toPDFCTM(CTM cTM) {
        if (null == cTM) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] dArray = CTMHelper.toPDFArray(cTM);
        return new CTM(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public static double[] toPDFArray(CTM cTM) {
        if (null == cTM) {
            throw new NullPointerException("sourceMatrix must not be null");
        }
        double[] dArray = cTM.toArray();
        return new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4] / 1000.0, dArray[5] / 1000.0};
    }
}

