/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;

public class PDFImageHandlerSVG
implements ImageHandler {
    private static Log log = LogFactory.getLog(PDFImageHandlerSVG.class);

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        Object object;
        GraphicsNode graphicsNode;
        PDFRenderingContext pDFRenderingContext = (PDFRenderingContext)renderingContext;
        PDFContentGenerator pDFContentGenerator = pDFRenderingContext.getGenerator();
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        FOUserAgent fOUserAgent = renderingContext.getUserAgent();
        float f = fOUserAgent.getTargetResolution();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating SVG at " + f + "dpi."));
        }
        float f2 = fOUserAgent.getSourceResolution();
        SVGUserAgent sVGUserAgent = new SVGUserAgent(fOUserAgent, new AffineTransform());
        GVTBuilder gVTBuilder = new GVTBuilder();
        boolean bl = false;
        PDFBridgeContext pDFBridgeContext = new PDFBridgeContext(sVGUserAgent, bl ? null : pDFRenderingContext.getFontInfo(), fOUserAgent.getFactory().getImageManager(), fOUserAgent.getImageSessionContext(), new AffineTransform());
        Document document = BatikUtil.cloneSVGDocument(imageXMLDOM.getDocument());
        try {
            graphicsNode = gVTBuilder.build((BridgeContext)pDFBridgeContext, document);
            gVTBuilder = null;
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt(this, exception, image.getInfo().getOriginalURI());
            return;
        }
        float f3 = image.getSize().getWidthMpt();
        float f4 = image.getSize().getHeightMpt();
        float f5 = (float)rectangle.width / f3;
        float f6 = (float)rectangle.height / f4;
        AffineTransform affineTransform = new AffineTransform(f5, 0.0f, 0.0f, f6, (float)rectangle.x / 1000.0f, (float)rectangle.y / 1000.0f);
        double d = 72.0f / f2;
        affineTransform.scale(d, d);
        AffineTransform affineTransform2 = new AffineTransform();
        double d2 = f2 / f;
        affineTransform2.scale(d2, d2);
        affineTransform2.scale(1.0 / (double)f5, 1.0 / (double)f6);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.concatenate(affineTransform);
        affineTransform3.concatenate(affineTransform2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("nat size: " + f3 + "/" + f4));
            log.trace((Object)("req size: " + rectangle.width + "/" + rectangle.height));
            log.trace((Object)("source res: " + f2 + ", targetRes: " + f + " --> target scaling: " + d2));
            log.trace((Object)image.getSize());
            log.trace((Object)("sx: " + f5 + ", sy: " + f6));
            log.trace((Object)("scaling: " + affineTransform));
            log.trace((Object)("resolution scaling: " + affineTransform2));
            log.trace((Object)("image transform: " + affineTransform2));
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG setup");
        }
        pDFContentGenerator.saveGraphicsState();
        if (renderingContext.getUserAgent().isAccessibilityEnabled()) {
            object = pDFRenderingContext.getMarkedContentInfo();
            pDFContentGenerator.beginMarkedContentSequence(((PDFLogicalStructureHandler.MarkedContentInfo)object).tag, ((PDFLogicalStructureHandler.MarkedContentInfo)object).mcid);
        }
        pDFContentGenerator.updateColor(Color.black, false, null);
        pDFContentGenerator.updateColor(Color.black, true, null);
        if (!affineTransform.isIdentity()) {
            if (log.isTraceEnabled()) {
                pDFContentGenerator.comment("viewbox");
            }
            pDFContentGenerator.add(CTMHelper.toPDFString(affineTransform, false) + " cm\n");
        }
        object = new PDFGraphics2D(true, pDFRenderingContext.getFontInfo(), pDFContentGenerator.getDocument(), pDFContentGenerator.getResourceContext(), pDFRenderingContext.getPage().referencePDF(), "", 0.0f);
        ((PDFGraphics2D)object).setGraphicContext(new GraphicContext());
        if (!affineTransform2.isIdentity()) {
            if (log.isTraceEnabled()) {
                pDFContentGenerator.comment("resolution scaling for " + f2 + " -> " + f);
            }
            pDFContentGenerator.add(CTMHelper.toPDFString(affineTransform2, false) + " cm\n");
            object.scale(1.0 / affineTransform2.getScaleX(), 1.0 / affineTransform2.getScaleY());
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG start");
        }
        pDFContentGenerator.getState().save();
        pDFContentGenerator.getState().concatenate(affineTransform3);
        PDFAElementBridge pDFAElementBridge = (PDFAElementBridge)pDFBridgeContext.getBridge("http://www.w3.org/2000/svg", "a");
        pDFAElementBridge.getCurrentTransform().setTransform(pDFContentGenerator.getState().getTransform());
        ((PDFGraphics2D)object).setPaintingState(pDFContentGenerator.getState());
        ((PDFGraphics2D)object).setOutputStream(pDFContentGenerator.getOutputStream());
        try {
            graphicsNode.paint((Graphics2D)object);
            pDFBridgeContext.dispose();
            pDFContentGenerator.add(((PDFGraphics2D)object).getString());
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgRenderingError(this, exception, image.getInfo().getOriginalURI());
        }
        pDFContentGenerator.getState().restore();
        if (renderingContext.getUserAgent().isAccessibilityEnabled()) {
            pDFContentGenerator.restoreGraphicsStateAccess();
        } else {
            pDFContentGenerator.restoreGraphicsState();
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG end");
        }
    }

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageXMLDOM.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{BatikImageFlavors.SVG_DOM};
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        String string;
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageXMLDOM && image.getFlavor().isCompatible((ImageFlavor)BatikImageFlavors.SVG_DOM)) && renderingContext instanceof PDFRenderingContext;
        if (bl && ImageHandlerUtil.isConversionModeBitmap(string = (String)renderingContext.getHint(ImageHandlerUtil.CONVERSION_MODE))) {
            return false;
        }
        return bl;
    }
}

