/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.print.PageableRenderer;

public class PrintRenderer
extends PageableRenderer {
    public static final String PRINTER_JOB = "printerjob";
    public static final String COPIES = "copies";
    private int copies = 1;
    private PrinterJob printerJob;

    public PrintRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        this.setRendererOptions();
    }

    private void initializePrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
            this.printerJob.setJobName("FOP Document");
            this.printerJob.setCopies(this.copies);
            if (System.getProperty("dialog") != null && !this.printerJob.printDialog()) {
                throw new RuntimeException("Printing cancelled by operator");
            }
            this.printerJob.setPageable(this);
        }
    }

    private void setRendererOptions() {
        Object v;
        Map map = this.getUserAgent().getRendererOptions();
        Object v2 = map.get(PRINTER_JOB);
        if (v2 != null) {
            if (!(v2 instanceof PrinterJob)) {
                throw new IllegalArgumentException("Renderer option printerjob must be an instance of java.awt.print.PrinterJob, but an instance of " + v2.getClass().getName() + " was given.");
            }
            this.printerJob = (PrinterJob)v2;
            this.printerJob.setPageable(this);
        }
        if ((v = map.get(COPIES)) != null) {
            this.copies = this.getPositiveInteger(v);
        }
        this.initializePrinterJob();
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public int getEndNumber() {
        return this.endNumber;
    }

    public void setEndPage(int n) {
        this.endNumber = n;
    }

    public int getStartPage() {
        return this.startNumber;
    }

    public void setStartPage(int n) {
        this.startNumber = n;
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        try {
            this.printerJob.print();
        }
        catch (PrinterException printerException) {
            log.error((Object)printerException);
            throw new IOException("Unable to print: " + printerException.getClass().getName() + ": " + printerException.getMessage());
        }
        this.clearViewportList();
    }
}

