/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSTextHandler;
import org.apache.xmlgraphics.ps.PSGenerator;

public class NativeTextHandler
implements PSTextHandler {
    private PSGraphics2D rootG2D;
    protected FontInfo fontInfo;
    protected org.apache.fop.fonts.Font font;
    protected org.apache.fop.fonts.Font overrideFont = null;
    protected String currentFontName;
    protected int currentFontSize;

    public NativeTextHandler(PSGraphics2D pSGraphics2D, FontInfo fontInfo) {
        this.rootG2D = pSGraphics2D;
        if (fontInfo != null) {
            this.fontInfo = fontInfo;
        } else {
            this.setupFontInfo();
        }
    }

    private void setupFontInfo() {
        this.fontInfo = new FontInfo();
        boolean bl = false;
        FontSetup.setup(this.fontInfo, bl);
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    private PSGenerator getPSGenerator() {
        return this.rootG2D.getPSGenerator();
    }

    public void writeSetup() throws IOException {
        if (this.fontInfo != null) {
            PSFontUtils.writeFontDict(this.getPSGenerator(), this.fontInfo);
        }
    }

    public void writePageSetup() throws IOException {
    }

    public void drawString(Graphics2D graphics2D, String string, float f, float f2) throws IOException {
        Font font;
        PSGraphics2D pSGraphics2D = (PSGraphics2D)graphics2D;
        pSGraphics2D.preparePainting();
        if (this.overrideFont == null) {
            font = pSGraphics2D.getFont();
            this.font = this.createFont(font);
        } else {
            this.font = this.overrideFont;
            this.overrideFont = null;
        }
        pSGraphics2D.establishColor(pSGraphics2D.getColor());
        this.establishCurrentFont();
        font = this.getPSGenerator();
        font.saveGraphicsState();
        Shape shape = pSGraphics2D.getClip();
        pSGraphics2D.writeClip(shape);
        AffineTransform affineTransform = pSGraphics2D.getTransform();
        font.concatMatrix(affineTransform);
        font.writeln(font.formatDouble(f) + " " + font.formatDouble(f2) + " moveto ");
        font.writeln("1 -1 scale");
        StringBuffer stringBuffer = new StringBuffer("(");
        this.escapeText(string, stringBuffer);
        stringBuffer.append(") t ");
        font.writeln(stringBuffer.toString());
        font.restoreGraphicsState();
    }

    private void escapeText(String string, StringBuffer stringBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = this.font.mapChar(c);
            PSGenerator.escapeChar((char)c2, (StringBuffer)stringBuffer);
        }
    }

    private org.apache.fop.fonts.Font createFont(Font font) {
        return this.fontInfo.getFontInstanceForAWTFont(font);
    }

    private void establishCurrentFont() throws IOException {
        if (this.currentFontName != this.font.getFontName() || this.currentFontSize != this.font.getFontSize()) {
            PSGenerator pSGenerator = this.getPSGenerator();
            pSGenerator.writeln("/" + this.font.getFontTriplet().getName() + " " + pSGenerator.formatDouble((double)((float)this.font.getFontSize() / 1000.0f)) + " F");
            this.currentFontName = this.font.getFontName();
            this.currentFontSize = this.font.getFontSize();
        }
    }

    public void setOverrideFont(org.apache.fop.fonts.Font font) {
        this.overrideFont = font;
    }
}

