/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSBorderPainter
extends BorderPainter {
    private static Log log = LogFactory.getLog(PSBorderPainter.class);
    private PSGenerator generator;

    public PSBorderPainter(PSGenerator pSGenerator) {
        this.generator = pSGenerator;
    }

    protected void drawBorderLine(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Color color) throws IOException {
        PSBorderPainter.drawBorderLine(this.generator, PSBorderPainter.toPoints(n), PSBorderPainter.toPoints(n2), PSBorderPainter.toPoints(n3), PSBorderPainter.toPoints(n4), bl, bl2, n5, color);
    }

    private static void drawLine(PSGenerator pSGenerator, float f, float f2, float f3, float f4) throws IOException {
        pSGenerator.writeln(pSGenerator.formatDouble((double)f) + " " + pSGenerator.formatDouble((double)f2) + " " + pSGenerator.mapCommand("moveto") + " " + pSGenerator.formatDouble((double)f3) + " " + pSGenerator.formatDouble((double)f4) + " " + pSGenerator.mapCommand("lineto") + " " + pSGenerator.mapCommand("stroke") + " " + pSGenerator.mapCommand("newpath"));
    }

    public static void drawBorderLine(PSGenerator pSGenerator, float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n, Color color) throws IOException {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        if (f5 < 0.0f || f6 < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (n) {
            case 31: {
                pSGenerator.useColor(color);
                if (bl) {
                    float f7 = Math.abs(2.0f * f6);
                    int n2 = (int)(f5 / f7);
                    if (n2 % 2 == 0) {
                        ++n2;
                    }
                    f7 = f5 / (float)n2;
                    pSGenerator.useDash("[" + f7 + "] 0");
                    pSGenerator.useLineCap(0);
                    pSGenerator.useLineWidth((double)f6);
                    float f8 = f2 + f6 / 2.0f;
                    PSBorderPainter.drawLine(pSGenerator, f, f8, f3, f8);
                    break;
                }
                float f9 = Math.abs(2.0f * f5);
                int n3 = (int)(f6 / f9);
                if (n3 % 2 == 0) {
                    ++n3;
                }
                f9 = f6 / (float)n3;
                pSGenerator.useDash("[" + f9 + "] 0");
                pSGenerator.useLineCap(0);
                pSGenerator.useLineWidth((double)f5);
                float f10 = f + f5 / 2.0f;
                PSBorderPainter.drawLine(pSGenerator, f10, f2, f10, f4);
                break;
            }
            case 36: {
                pSGenerator.useColor(color);
                pSGenerator.useLineCap(1);
                if (bl) {
                    float f11 = Math.abs(2.0f * f6);
                    int n4 = (int)(f5 / f11);
                    if (n4 % 2 == 0) {
                        ++n4;
                    }
                    f11 = f5 / (float)n4;
                    pSGenerator.useDash("[0 " + f11 + "] 0");
                    pSGenerator.useLineWidth((double)f6);
                    float f12 = f2 + f6 / 2.0f;
                    PSBorderPainter.drawLine(pSGenerator, f, f12, f3, f12);
                    break;
                }
                float f13 = Math.abs(2.0f * f5);
                int n5 = (int)(f6 / f13);
                if (n5 % 2 == 0) {
                    ++n5;
                }
                f13 = f6 / (float)n5;
                pSGenerator.useDash("[0 " + f13 + "] 0");
                pSGenerator.useLineWidth((double)f5);
                float f14 = f + f5 / 2.0f;
                PSBorderPainter.drawLine(pSGenerator, f14, f2, f14, f4);
                break;
            }
            case 37: {
                pSGenerator.useColor(color);
                pSGenerator.useDash(null);
                if (bl) {
                    float f15 = f6 / 3.0f;
                    pSGenerator.useLineWidth((double)f15);
                    float f16 = f2 + f15 / 2.0f;
                    float f17 = f16 + f15 + f15;
                    PSBorderPainter.drawLine(pSGenerator, f, f16, f3, f16);
                    PSBorderPainter.drawLine(pSGenerator, f, f17, f3, f17);
                    break;
                }
                float f18 = f5 / 3.0f;
                pSGenerator.useLineWidth((double)f18);
                float f19 = f + f18 / 2.0f;
                float f20 = f19 + f18 + f18;
                PSBorderPainter.drawLine(pSGenerator, f19, f2, f19, f4);
                PSBorderPainter.drawLine(pSGenerator, f20, f2, f20, f4);
                break;
            }
            case 55: 
            case 119: {
                float f21 = n == 55 ? 0.4f : -0.4f;
                pSGenerator.useDash(null);
                if (bl) {
                    Color color2 = ColorUtil.lightenColor(color, -f21);
                    Color color3 = ColorUtil.lightenColor(color, f21);
                    float f22 = f6 / 3.0f;
                    pSGenerator.useLineWidth((double)f22);
                    float f23 = f2 + f22 / 2.0f;
                    pSGenerator.useColor(color2);
                    PSBorderPainter.drawLine(pSGenerator, f, f23, f3, f23);
                    pSGenerator.useColor(color);
                    PSBorderPainter.drawLine(pSGenerator, f, f23 + f22, f3, f23 + f22);
                    pSGenerator.useColor(color3);
                    PSBorderPainter.drawLine(pSGenerator, f, f23 + f22 + f22, f3, f23 + f22 + f22);
                    break;
                }
                Color color4 = ColorUtil.lightenColor(color, -f21);
                Color color5 = ColorUtil.lightenColor(color, f21);
                float f24 = f5 / 3.0f;
                pSGenerator.useLineWidth((double)f24);
                float f25 = f + f24 / 2.0f;
                pSGenerator.useColor(color4);
                PSBorderPainter.drawLine(pSGenerator, f25, f2, f25, f4);
                pSGenerator.useColor(color);
                PSBorderPainter.drawLine(pSGenerator, f25 + f24, f2, f25 + f24, f4);
                pSGenerator.useColor(color5);
                PSBorderPainter.drawLine(pSGenerator, f25 + f24 + f24, f2, f25 + f24 + f24, f4);
                break;
            }
            case 67: 
            case 101: {
                float f26 = n == 101 ? 0.4f : -0.4f;
                pSGenerator.useDash(null);
                if (bl) {
                    Color color6 = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f26);
                    pSGenerator.useLineWidth((double)f6);
                    float f27 = f2 + f6 / 2.0f;
                    pSGenerator.useColor(color6);
                    PSBorderPainter.drawLine(pSGenerator, f, f27, f3, f27);
                    break;
                }
                Color color7 = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f26);
                pSGenerator.useLineWidth((double)f5);
                float f28 = f + f5 / 2.0f;
                pSGenerator.useColor(color7);
                PSBorderPainter.drawLine(pSGenerator, f28, f2, f28, f4);
                break;
            }
            case 57: {
                break;
            }
            default: {
                pSGenerator.useColor(color);
                pSGenerator.useDash(null);
                pSGenerator.useLineCap(0);
                if (bl) {
                    pSGenerator.useLineWidth((double)f6);
                    float f29 = f2 + f6 / 2.0f;
                    PSBorderPainter.drawLine(pSGenerator, f, f29, f3, f29);
                    break;
                }
                pSGenerator.useLineWidth((double)f5);
                float f30 = f + f5 / 2.0f;
                PSBorderPainter.drawLine(pSGenerator, f30, f2, f30, f4);
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IOException {
        if (point.y != point2.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int n2 = n / 2;
        int n3 = point.y - n2;
        switch (ruleStyle.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(point.x, n3, point2.x, n3 + n, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 36: {
                this.clipRect(point.x, n3, point2.x - point.x, n);
                this.generator.concatMatrix(1.0, 0.0, 0.0, 1.0, (double)PSBorderPainter.toPoints(n2), 0.0);
                this.drawBorderLine(point.x, n3, point2.x, n3 + n, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.generator.useColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(point.x, n3);
                this.lineTo(point2.x, n3);
                this.lineTo(point2.x, n3 + 2 * n2);
                this.lineTo(point.x, n3 + 2 * n2);
                this.closePath();
                this.generator.write(" " + this.generator.mapCommand("fill"));
                this.generator.writeln(" " + this.generator.mapCommand("newpath"));
                this.generator.useColor(color);
                if (ruleStyle == RuleStyle.GROOVE) {
                    this.moveTo(point.x, n3);
                    this.lineTo(point2.x, n3);
                    this.lineTo(point2.x, n3 + n2);
                    this.lineTo(point.x + n2, n3 + n2);
                    this.lineTo(point.x, n3 + 2 * n2);
                } else {
                    this.moveTo(point2.x, n3);
                    this.lineTo(point2.x, n3 + 2 * n2);
                    this.lineTo(point.x, n3 + 2 * n2);
                    this.lineTo(point.x, n3 + n2);
                    this.lineTo(point2.x - n2, n3 + n2);
                }
                this.closePath();
                this.generator.write(" " + this.generator.mapCommand("fill"));
                this.generator.writeln(" " + this.generator.mapCommand("newpath"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
    }

    private static float toPoints(int n) {
        return (float)n / 1000.0f;
    }

    protected void moveTo(int n, int n2) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSBorderPainter.toPoints(n)) + " " + this.generator.formatDouble((double)PSBorderPainter.toPoints(n2)) + " " + this.generator.mapCommand("moveto"));
    }

    protected void lineTo(int n, int n2) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSBorderPainter.toPoints(n)) + " " + this.generator.formatDouble((double)PSBorderPainter.toPoints(n2)) + " " + this.generator.mapCommand("lineto"));
    }

    protected void closePath() throws IOException {
        this.generator.writeln("cp");
    }

    private void clipRect(int n, int n2, int n3, int n4) throws IOException {
        this.generator.defineRect((double)PSBorderPainter.toPoints(n), (double)PSBorderPainter.toPoints(n2), (double)PSBorderPainter.toPoints(n3), (double)PSBorderPainter.toPoints(n4));
        this.clip();
    }

    protected void clip() throws IOException {
        this.generator.writeln(this.generator.mapCommand("clip") + " " + this.generator.mapCommand("newpath"));
    }

    protected void saveGraphicsState() throws IOException {
        this.generator.saveGraphicsState();
    }

    protected void restoreGraphicsState() throws IOException {
        this.generator.restoreGraphicsState();
    }
}

