/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSGraphics2DAdapter;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.FormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;

public class PSImageHandlerGraphics2D
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        Graphics2DImagePainter graphics2DImagePainter = imageGraphics2D.getGraphics2DImagePainter();
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        Dimension dimension = graphics2DImagePainter.getImageSize();
        float f5 = (float)dimension.getWidth() / 1000.0f;
        float f6 = (float)dimension.getHeight() / 1000.0f;
        float f7 = f3 / f5;
        float f8 = f4 / f6;
        pSGenerator.commentln("%FOPBeginGraphics2D");
        pSGenerator.saveGraphicsState();
        pSGenerator.concatMatrix((double)f7, 0.0, 0.0, (double)f8, (double)f, (double)f2);
        PSGraphics2D pSGraphics2D = new PSGraphics2D(false, pSGenerator);
        pSGraphics2D.setGraphicContext(new GraphicContext());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        pSGenerator.getCurrentState().concatMatrix(affineTransform);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f5, f6);
        graphics2DImagePainter.paint((Graphics2D)pSGraphics2D, (Rectangle2D)double_);
        pSGenerator.restoreGraphicsState();
        pSGenerator.commentln("%FOPEndGraphics2D");
    }

    public void generateForm(RenderingContext renderingContext, Image image, PSImageFormResource pSImageFormResource) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        ImageInfo imageInfo = image.getInfo();
        FormGenerator formGenerator = this.buildFormGenerator(pSGenerator.getPSLevel(), pSImageFormResource, imageInfo, imageGraphics2D);
        formGenerator.generate(pSGenerator);
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        if (renderingContext instanceof PSRenderingContext) {
            return image == null || image instanceof ImageGraphics2D;
        }
        return false;
    }

    private FormGenerator buildFormGenerator(int n, final PSImageFormResource pSImageFormResource, ImageInfo imageInfo, final ImageGraphics2D imageGraphics2D) {
        String string = imageInfo.getMimeType() + " " + imageInfo.getOriginalURI();
        Dimension2D dimension2D = imageInfo.getSize().getDimensionPt();
        final Dimension dimension = imageInfo.getSize().getDimensionMpt();
        EPSFormGenerator ePSFormGenerator = n <= 2 ? new EPSFormGenerator(pSImageFormResource.getName(), string, dimension2D){

            void doGeneratePaintProc(PSGenerator pSGenerator) throws IOException {
                this.paintImageG2D(imageGraphics2D, dimension, pSGenerator);
            }
        } : new EPSFormGenerator(pSImageFormResource.getName(), string, dimension2D){

            protected void generateAdditionalDataStream(PSGenerator pSGenerator) throws IOException {
                pSGenerator.writeln("/" + pSImageFormResource.getName() + ":Data currentfile <<");
                pSGenerator.writeln("  /Filter /SubFileDecode");
                pSGenerator.writeln("  /DecodeParms << /EODCount 0 /EODString (%FOPEndOfData) >>");
                pSGenerator.writeln(">> /ReusableStreamDecode filter");
                this.paintImageG2D(imageGraphics2D, dimension, pSGenerator);
                pSGenerator.writeln("%FOPEndOfData");
                pSGenerator.writeln("def");
            }

            void doGeneratePaintProc(PSGenerator pSGenerator) throws IOException {
                pSGenerator.writeln(pSImageFormResource.getName() + ":Data 0 setfileposition");
                pSGenerator.writeln(pSImageFormResource.getName() + ":Data cvx exec");
            }
        };
        return ePSFormGenerator;
    }

    private static abstract class EPSFormGenerator
    extends FormGenerator {
        EPSFormGenerator(String string, String string2, Dimension2D dimension2D) {
            super(string, string2, dimension2D);
        }

        protected void paintImageG2D(ImageGraphics2D imageGraphics2D, Dimension2D dimension2D, PSGenerator pSGenerator) throws IOException {
            PSGraphics2DAdapter pSGraphics2DAdapter = new PSGraphics2DAdapter(pSGenerator, false);
            pSGraphics2DAdapter.paintImage(imageGraphics2D.getGraphics2DImagePainter(), null, 0, 0, (int)Math.round(dimension2D.getWidth()), (int)Math.round(dimension2D.getHeight()));
        }

        protected final void generatePaintProc(PSGenerator pSGenerator) throws IOException {
            pSGenerator.getResourceTracker().notifyResourceUsageOnPage(PSProcSets.EPS_PROCSET);
            pSGenerator.writeln("BeginEPSF");
            this.doGeneratePaintProc(pSGenerator);
            pSGenerator.writeln("EndEPSF");
        }

        abstract void doGeneratePaintProc(PSGenerator var1) throws IOException;
    }
}

