/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.ImageHandlerRegistry;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;

public class PSImageUtils
extends org.apache.xmlgraphics.ps.PSImageUtils {
    public static boolean isImageInlined(ImageInfo imageInfo, PSRenderingContext pSRenderingContext) {
        ImageProviderPipeline[] imageProviderPipelineArray;
        String string = imageInfo.getOriginalURI();
        if (string == null || "".equals(string)) {
            return true;
        }
        ImageFlavor[] imageFlavorArray = PSImageUtils.determineSupportedImageFlavors(pSRenderingContext);
        ImageManager imageManager = pSRenderingContext.getUserAgent().getFactory().getImageManager();
        ImageProviderPipeline imageProviderPipeline = imageManager.choosePipeline(imageProviderPipelineArray = imageManager.getPipelineFactory().determineCandidatePipelines(imageInfo, imageFlavorArray));
        ImageFlavor imageFlavor = imageProviderPipeline != null ? imageProviderPipeline.getTargetFlavor() : null;
        PSRenderingContext pSRenderingContext2 = pSRenderingContext.toFormContext();
        ImageFlavor[] imageFlavorArray2 = PSImageUtils.determineSupportedImageFlavors(pSRenderingContext2);
        ImageProviderPipeline[] imageProviderPipelineArray2 = imageManager.getPipelineFactory().determineCandidatePipelines(imageInfo, imageFlavorArray2);
        ImageProviderPipeline imageProviderPipeline2 = imageManager.choosePipeline(imageProviderPipelineArray2);
        ImageFlavor imageFlavor2 = imageProviderPipeline2 != null ? imageProviderPipeline2.getTargetFlavor() : null;
        return imageFlavor2 == null || !imageFlavor2.equals((Object)imageFlavor);
    }

    private static ImageFlavor[] determineSupportedImageFlavors(RenderingContext renderingContext) {
        ImageHandlerRegistry imageHandlerRegistry = renderingContext.getUserAgent().getFactory().getImageHandlerRegistry();
        ImageFlavor[] imageFlavorArray = imageHandlerRegistry.getSupportedFlavors(renderingContext);
        return imageFlavorArray;
    }

    public static void drawForm(PSResource pSResource, ImageInfo imageInfo, Rectangle rectangle, PSGenerator pSGenerator) throws IOException {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.getMinX() / 1000.0, rectangle.getMinY() / 1000.0, rectangle.getWidth() / 1000.0, rectangle.getHeight() / 1000.0);
        pSGenerator.saveGraphicsState();
        PSImageUtils.translateAndScale((PSGenerator)pSGenerator, (Dimension2D)imageInfo.getSize().getDimensionPt(), (Rectangle2D)double_);
        pSGenerator.writeDSCComment("IncludeResource", (Object)pSResource);
        pSGenerator.getResourceTracker().notifyResourceUsageOnPage(pSResource);
        pSGenerator.writeln(pSResource.getName() + " execform");
        pSGenerator.restoreGraphicsState();
    }
}

