/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.render.ps.FontResourceCache;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.svg.NativeTextPainter;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSTextPainter
extends NativeTextPainter {
    private static final boolean DEBUG = false;
    private FontResourceCache fontResources;
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();

    public PSTextPainter(FontInfo fontInfo) {
        super(fontInfo);
        this.fontResources = new FontResourceCache(fontInfo);
    }

    protected boolean isSupported(Graphics2D graphics2D) {
        return graphics2D instanceof PSGraphics2D;
    }

    protected void paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D graphics2D) throws IOException {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (textPaintInfo == null || !textPaintInfo.visible) {
            return;
        }
        if (textPaintInfo != null && textPaintInfo.composite != null) {
            graphics2D.setComposite(textPaintInfo.composite);
        }
        TextSpanLayout textSpanLayout = textRun.getLayout();
        this.logTextRun(attributedCharacterIterator, textSpanLayout);
        CharSequence charSequence = this.collectCharacters(attributedCharacterIterator);
        attributedCharacterIterator.first();
        PSGraphics2D pSGraphics2D = (PSGraphics2D)graphics2D;
        PSGenerator pSGenerator = pSGraphics2D.getPSGenerator();
        pSGraphics2D.preparePainting();
        Object var9_9 = null;
        TextUtil textUtil = new TextUtil(pSGenerator);
        textUtil.setupFonts(attributedCharacterIterator);
        if (!textUtil.hasFonts()) {
            textRun.getLayout().draw(graphics2D);
            return;
        }
        pSGenerator.saveGraphicsState();
        pSGenerator.concatMatrix(graphics2D.getTransform());
        Shape shape = graphics2D.getClip();
        this.clip(pSGraphics2D, shape);
        pSGenerator.writeln("BT");
        AffineTransform affineTransform = new AffineTransform();
        Point2D point2D = null;
        GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
        PSTextRun pSTextRun = new PSTextRun();
        int n = gVTGlyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2;
            Font font;
            boolean bl;
            char c3 = charSequence.charAt(i);
            boolean bl2 = gVTGlyphVector.isGlyphVisible(i) || CharUtilities.isAnySpace(c3) && !CharUtilities.isZeroWidthSpace(c3);
            this.logCharacter(c3, textSpanLayout, i, bl2);
            if (!bl2) continue;
            Point2D point2D2 = gVTGlyphVector.getGlyphPosition(i);
            AffineTransform affineTransform2 = gVTGlyphVector.getGlyphTransform(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("pos " + point2D2 + ", transform " + affineTransform2));
            }
            affineTransform.setToIdentity();
            affineTransform.translate(point2D2.getX(), point2D2.getY());
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(1.0, -1.0);
            boolean bl3 = false;
            if (affineTransform2 != null) {
                bl3 = true;
            }
            if (pSTextRun.getRunLength() >= 128) {
                bl3 = true;
            }
            Point2D.Double double_ = point2D == null ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            if (pSTextRun.vertChanges == 0 && pSTextRun.getHorizRunLength() > 2 && ((Point2D)double_).getY() != 0.0) {
                bl3 = true;
            }
            if (bl = textUtil.isFontChanging(font = textUtil.selectFontForChar(c2 = CharUtilities.isAnySpace(c3) ? (char)' ' : (char)c3), c = font.mapChar(c3))) {
                bl3 = true;
            }
            if (bl3) {
                pSTextRun.paint(pSGraphics2D, textUtil, textPaintInfo);
                pSTextRun.reset();
            }
            pSTextRun.addCharacter(c2, double_);
            pSTextRun.noteStartingTransformation(affineTransform);
            if (bl) {
                textUtil.setCurrentFont(font, c);
            }
            point2D = point2D2;
        }
        pSTextRun.paint(pSGraphics2D, textUtil, textPaintInfo);
        pSGenerator.writeln("ET");
        pSGenerator.restoreGraphicsState();
    }

    private void applyColor(Paint paint, PSGenerator pSGenerator) throws IOException {
        if (paint == null) {
            return;
        }
        if (paint instanceof Color) {
            Color color = (Color)paint;
            pSGenerator.useColor(color);
        } else {
            this.log.warn((Object)("Paint not supported: " + paint.toString()));
        }
    }

    private PSFontResource getResourceForFont(Font font, String string) {
        String string2 = string != null ? font.getFontName() + '_' + string : font.getFontName();
        return this.fontResources.getFontResourceForFontKey(string2);
    }

    private void clip(PSGraphics2D pSGraphics2D, Shape shape) throws IOException {
        if (shape == null) {
            return;
        }
        pSGraphics2D.getPSGenerator().writeln("newpath");
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        pSGraphics2D.processPathIterator(pathIterator);
        pSGraphics2D.getPSGenerator().writeln("clip");
    }

    private class PSTextRun {
        private AffineTransform textTransform;
        private List relativePositions = new LinkedList();
        private StringBuffer currentChars = new StringBuffer();
        private int horizChanges = 0;
        private int vertChanges = 0;

        private PSTextRun() {
        }

        public void reset() {
            this.textTransform = null;
            this.currentChars.setLength(0);
            this.horizChanges = 0;
            this.vertChanges = 0;
            this.relativePositions.clear();
        }

        public int getHorizRunLength() {
            if (this.vertChanges == 0 && this.getRunLength() > 0) {
                return this.getRunLength();
            }
            return 0;
        }

        public void addCharacter(char c, Point2D point2D) {
            this.addRelativePosition(point2D);
            this.currentChars.append(c);
        }

        private void addRelativePosition(Point2D point2D) {
            if (this.getRunLength() > 0) {
                if (point2D.getX() != 0.0) {
                    ++this.horizChanges;
                }
                if (point2D.getY() != 0.0) {
                    ++this.vertChanges;
                }
            }
            this.relativePositions.add(point2D);
        }

        public void noteStartingTransformation(AffineTransform affineTransform) {
            if (this.textTransform == null) {
                this.textTransform = new AffineTransform(affineTransform);
            }
        }

        public int getRunLength() {
            return this.currentChars.length();
        }

        private boolean isXShow() {
            return this.vertChanges == 0;
        }

        private boolean isYShow() {
            return this.horizChanges == 0;
        }

        public void paint(PSGraphics2D pSGraphics2D, TextUtil textUtil, TextPaintInfo textPaintInfo) throws IOException {
            if (this.getRunLength() > 0) {
                boolean bl;
                if (PSTextPainter.this.log.isDebugEnabled()) {
                    PSTextPainter.this.log.debug((Object)("Text run: " + this.currentChars));
                }
                textUtil.writeTextMatrix(this.textTransform);
                if (this.isXShow()) {
                    PSTextPainter.this.log.debug((Object)"Horizontal text: xshow");
                    this.paintXYShow(pSGraphics2D, textUtil, textPaintInfo.fillPaint, true, false);
                } else if (this.isYShow()) {
                    PSTextPainter.this.log.debug((Object)"Vertical text: yshow");
                    this.paintXYShow(pSGraphics2D, textUtil, textPaintInfo.fillPaint, false, true);
                } else {
                    PSTextPainter.this.log.debug((Object)"Arbitrary text: xyshow");
                    this.paintXYShow(pSGraphics2D, textUtil, textPaintInfo.fillPaint, true, true);
                }
                boolean bl2 = bl = textPaintInfo.strokePaint != null && textPaintInfo.strokeStroke != null;
                if (bl) {
                    PSTextPainter.this.log.debug((Object)"Stroked glyph outlines");
                    this.paintStrokedGlyphs(pSGraphics2D, textUtil, textPaintInfo.strokePaint, textPaintInfo.strokeStroke);
                }
            }
        }

        private void paintXYShow(PSGraphics2D pSGraphics2D, TextUtil textUtil, Paint paint, boolean bl, boolean bl2) throws IOException {
            int n;
            PSGenerator pSGenerator = textUtil.gen;
            char c = this.currentChars.charAt(0);
            Font font = textUtil.selectFontForChar(c);
            char c2 = font.mapChar(c);
            textUtil.selectFont(font, c2);
            textUtil.setCurrentFont(font, c2);
            PSTextPainter.this.applyColor(paint, pSGenerator);
            FontMetrics fontMetrics = font.getFontMetrics();
            boolean bl3 = fontMetrics instanceof MultiByteFont || fontMetrics instanceof LazyFont && ((LazyFont)fontMetrics).getRealFont() instanceof MultiByteFont;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bl3 ? (char)'<' : '(');
            int n2 = this.currentChars.length();
            for (n = 0; n < n2; ++n) {
                char c3 = this.currentChars.charAt(n);
                c2 = font.mapChar(c3);
                if (bl3) {
                    stringBuffer.append(HexEncoder.encode(c2));
                    continue;
                }
                char c4 = (char)(c2 % 256);
                PSGenerator.escapeChar((char)c4, (StringBuffer)stringBuffer);
            }
            stringBuffer.append(bl3 ? (char)'>' : ')');
            if (bl || bl2) {
                stringBuffer.append("\n[");
                n = 0;
                for (Point2D point2D : this.relativePositions) {
                    if (n > 0) {
                        if (bl) {
                            stringBuffer.append(this.format(pSGenerator, point2D.getX()));
                        }
                        if (bl2) {
                            if (bl) {
                                stringBuffer.append(' ');
                            }
                            stringBuffer.append(this.format(pSGenerator, -point2D.getY()));
                        }
                        if (n % 8 == 0) {
                            stringBuffer.append('\n');
                        } else {
                            stringBuffer.append(' ');
                        }
                    }
                    ++n;
                }
                if (bl) {
                    stringBuffer.append('0');
                }
                if (bl2) {
                    if (bl) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append('0');
                }
                stringBuffer.append(']');
            }
            stringBuffer.append(' ');
            if (bl) {
                stringBuffer.append('x');
            }
            if (bl2) {
                stringBuffer.append('y');
            }
            stringBuffer.append("show");
            pSGenerator.writeln(stringBuffer.toString());
        }

        private String format(PSGenerator pSGenerator, double d) {
            if (Math.abs(d) < 1.0E-5) {
                return "0";
            }
            return pSGenerator.formatDouble5(d);
        }

        private void paintStrokedGlyphs(PSGraphics2D pSGraphics2D, TextUtil textUtil, Paint paint, Stroke stroke) throws IOException {
            PSGenerator pSGenerator = textUtil.gen;
            PSTextPainter.this.applyColor(paint, pSGenerator);
            PSGraphics2D.applyStroke((Stroke)stroke, (PSGenerator)pSGenerator);
            Font font = null;
            Iterator iterator = this.relativePositions.iterator();
            iterator.next();
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            pSGenerator.writeln("0 0 M");
            int n = this.currentChars.length();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                char c = this.currentChars.charAt(0);
                if (i == 0) {
                    font = textUtil.selectFontForChar(c);
                }
                char c2 = font.mapChar(c);
                if (i == 0) {
                    textUtil.selectFont(font, c2);
                    textUtil.setCurrentFont(font, c2);
                }
                c2 = font.mapChar(this.currentChars.charAt(i));
                FontMetrics fontMetrics = font.getFontMetrics();
                boolean bl2 = bl = fontMetrics instanceof MultiByteFont || fontMetrics instanceof LazyFont && ((LazyFont)fontMetrics).getRealFont() instanceof MultiByteFont;
                if (bl) {
                    pSGenerator.write(60);
                    pSGenerator.write(HexEncoder.encode(c2));
                    pSGenerator.write(62);
                } else {
                    char c3 = (char)(c2 % 256);
                    pSGenerator.write("(" + c3 + ")");
                }
                pSGenerator.writeln(" false charpath");
                if (!iterator.hasNext()) continue;
                Point2D point2D = (Point2D)iterator.next();
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + point2D.getX(), ((Point2D)double_).getY() - point2D.getY());
                pSGenerator.writeln(pSGenerator.formatDouble5(((Point2D)double_).getX()) + " " + pSGenerator.formatDouble5(((Point2D)double_).getY()) + " M");
            }
            pSGenerator.writeln("stroke");
        }
    }

    private class TextUtil {
        private PSGenerator gen;
        private Font[] fonts;
        private Font currentFont;
        private int currentEncoding = -1;

        public TextUtil(PSGenerator pSGenerator) {
            this.gen = pSGenerator;
        }

        public Font selectFontForChar(char c) {
            int n = this.fonts.length;
            for (int i = 0; i < n; ++i) {
                if (!this.fonts[i].hasChar(c)) continue;
                return this.fonts[i];
            }
            return this.fonts[0];
        }

        public void writeTextMatrix(AffineTransform affineTransform) throws IOException {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.gen.writeln(this.gen.formatDouble5(dArray[0]) + " " + this.gen.formatDouble5(dArray[1]) + " " + this.gen.formatDouble5(dArray[2]) + " " + this.gen.formatDouble5(dArray[3]) + " " + this.gen.formatDouble5(dArray[4]) + " " + this.gen.formatDouble5(dArray[5]) + " Tm");
        }

        public boolean isFontChanging(Font font, char c) {
            if (font != this.getCurrentFont()) {
                return true;
            }
            return c / 256 != this.getCurrentFontEncoding();
        }

        public void selectFont(Font font, char c) throws IOException {
            int n = c / 256;
            String string = n == 0 ? null : Integer.toString(n);
            PSFontResource pSFontResource = PSTextPainter.this.getResourceForFont(font, string);
            this.gen.useFont("/" + pSFontResource.getName(), (float)font.getFontSize() / 1000.0f);
            pSFontResource.notifyResourceUsageOnPage(this.gen.getResourceTracker());
        }

        public Font getCurrentFont() {
            return this.currentFont;
        }

        public int getCurrentFontEncoding() {
            return this.currentEncoding;
        }

        public void setCurrentFont(Font font, int n) {
            this.currentFont = font;
            this.currentEncoding = n;
        }

        public void setCurrentFont(Font font, char c) {
            int n = c / 256;
            this.setCurrentFont(font, n);
        }

        public void setupFonts(AttributedCharacterIterator attributedCharacterIterator) {
            this.fonts = PSTextPainter.this.findFonts(attributedCharacterIterator);
        }

        public boolean hasFonts() {
            return this.fonts != null && this.fonts.length > 0;
        }
    }
}

