/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.tools.ImageUtil;

public class RtfExternalGraphic
extends RtfElement {
    protected URL url = null;
    protected int height = -1;
    protected int heightPercent = -1;
    protected int heightDesired = -1;
    protected boolean perCentH = false;
    protected int width = -1;
    protected int widthPercent = -1;
    protected int widthDesired = -1;
    protected boolean perCentW = false;
    protected boolean scaleUniform = false;
    private int[] cropValues = new int[4];
    protected int graphicCompressionRate = 80;
    private byte[] imagedata = null;
    private FormatBase imageformat;

    public RtfExternalGraphic(RtfContainer rtfContainer, Writer writer) throws IOException {
        super(rtfContainer, writer);
    }

    public RtfExternalGraphic(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfContainer, writer, rtfAttributes);
    }

    protected void writeRtfContent() throws IOException {
        try {
            this.writeRtfContentWithException();
        }
        catch (ExternalGraphicException externalGraphicException) {
            this.writeExceptionInRtf(externalGraphicException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRtfContentWithException() throws IOException {
        int n;
        Object object;
        if (this.writer == null) {
            return;
        }
        if (this.url == null && this.imagedata == null) {
            throw new ExternalGraphicException("No image data is available (neither URL, nor in-memory)");
        }
        String string = System.getProperty("jfor_link_to_root");
        if (this.url != null && string != null) {
            this.writer.write("{\\field {\\* \\fldinst { INCLUDEPICTURE \"");
            this.writer.write(string);
            File file = new File(this.url.getFile());
            this.writer.write(file.getName());
            this.writer.write("\" \\\\* MERGEFORMAT \\\\d }}}");
            return;
        }
        if (this.imagedata == null) {
            try {
                object = this.url.openStream();
                try {
                    this.imagedata = IOUtils.toByteArray((InputStream)this.url.openStream());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)object);
                }
            }
            catch (Exception exception) {
                throw new ExternalGraphicException("The attribute 'src' of <fo:external-graphic> has a invalid value: '" + this.url + "' (" + exception + ")");
            }
        }
        if (this.imagedata == null) {
            return;
        }
        object = this.url != null ? this.url.getFile() : "<unknown>";
        this.imageformat = FormatBase.determineFormat(this.imagedata);
        if (this.imageformat != null) {
            this.imageformat = this.imageformat.convert(this.imageformat, this.imagedata);
        }
        if (this.imageformat == null || this.imageformat.getType() == -1 || "".equals(this.imageformat.getRtfTag())) {
            throw new ExternalGraphicException("The tag <fo:external-graphic> does not support " + ((String)object).substring(((String)object).lastIndexOf(".") + 1) + " - image type.");
        }
        this.writeGroupMark(true);
        this.writeStarControlWord("shppict");
        this.writeGroupMark(true);
        this.writeControlWord("pict");
        StringBuffer stringBuffer = new StringBuffer(this.imagedata.length * 3);
        this.writeControlWord(this.imageformat.getRtfTag());
        this.computeImageSize();
        this.writeSizeInfo();
        this.writeAttributes(this.getRtfAttributes(), null);
        for (n = 0; n < this.imagedata.length; ++n) {
            int n2 = this.imagedata[n];
            if (n2 < 0) {
                n2 += 256;
            }
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        this.writer.write(cArray);
        this.writeGroupMark(false);
        this.writeGroupMark(false);
    }

    private void computeImageSize() {
        if (this.imageformat.getType() == 1) {
            this.width = ImageUtil.getIntFromByteArray(this.imagedata, 16, 4, true);
            this.height = ImageUtil.getIntFromByteArray(this.imagedata, 20, 4, true);
        } else if (this.imageformat.getType() == 2) {
            int n = -1;
            byte by = -1;
            byte by2 = -64;
            for (int i = 0; i < this.imagedata.length; ++i) {
                byte by3 = this.imagedata[i];
                if (by3 != by || i == this.imagedata.length - 1 || (by3 = this.imagedata[i + 1]) != by2) continue;
                n = i + 5;
                break;
            }
            if (n != -1) {
                this.width = ImageUtil.getIntFromByteArray(this.imagedata, n + 2, 2, true);
                this.height = ImageUtil.getIntFromByteArray(this.imagedata, n, 2, true);
            }
        } else if (this.imageformat.getType() == 0) {
            int n = 0;
            n = ImageUtil.getIntFromByteArray(this.imagedata, 151, 4, false);
            if (n != 0) {
                this.width = n;
            }
            if ((n = ImageUtil.getIntFromByteArray(this.imagedata, 155, 4, false)) != 0) {
                this.height = n;
            }
        }
    }

    private void writeSizeInfo() throws IOException {
        if (this.width != -1) {
            this.writeControlWord("picw" + this.width);
        }
        if (this.height != -1) {
            this.writeControlWord("pich" + this.height);
        }
        if (this.widthDesired != -1) {
            if (this.perCentW) {
                this.writeControlWord("picscalex" + this.widthDesired);
            } else {
                this.writeControlWord("picwgoal" + this.widthDesired);
            }
        } else if (this.scaleUniform && this.heightDesired != -1) {
            if (this.perCentH) {
                this.writeControlWord("picscalex" + this.heightDesired);
            } else {
                this.writeControlWord("picscalex" + this.heightDesired * 100 / this.height);
            }
        }
        if (this.heightDesired != -1) {
            if (this.perCentH) {
                this.writeControlWord("picscaley" + this.heightDesired);
            } else {
                this.writeControlWord("pichgoal" + this.heightDesired);
            }
        } else if (this.scaleUniform && this.widthDesired != -1) {
            if (this.perCentW) {
                this.writeControlWord("picscaley" + this.widthDesired);
            } else {
                this.writeControlWord("picscaley" + this.widthDesired * 100 / this.width);
            }
        }
        if (this.cropValues[0] != 0) {
            this.writeOneAttribute("piccropl", new Integer(this.cropValues[0]));
        }
        if (this.cropValues[1] != 0) {
            this.writeOneAttribute("piccropt", new Integer(this.cropValues[1]));
        }
        if (this.cropValues[2] != 0) {
            this.writeOneAttribute("piccropr", new Integer(this.cropValues[2]));
        }
        if (this.cropValues[3] != 0) {
            this.writeOneAttribute("piccropb", new Integer(this.cropValues[3]));
        }
    }

    public void setHeight(String string) {
        this.heightDesired = ImageUtil.getInt(string);
        this.perCentH = ImageUtil.isPercent(string);
    }

    public void setWidth(String string) {
        this.widthDesired = ImageUtil.getInt(string);
        this.perCentW = ImageUtil.isPercent(string);
    }

    public void setWidthTwips(int n) {
        this.widthDesired = n;
        this.perCentW = false;
    }

    public void setHeightTwips(int n) {
        this.heightDesired = n;
        this.perCentH = false;
    }

    public void setScaling(String string) {
        this.setUniformScaling("uniform".equalsIgnoreCase(string));
    }

    public void setUniformScaling(boolean bl) {
        this.scaleUniform = bl;
    }

    public void setCropping(int n, int n2, int n3, int n4) {
        this.cropValues[0] = n;
        this.cropValues[1] = n2;
        this.cropValues[2] = n3;
        this.cropValues[3] = n4;
    }

    public void setImageData(byte[] byArray) throws IOException {
        this.imagedata = byArray;
    }

    public void setURL(String string) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                throw new ExternalGraphicException("The attribute 'src' of <fo:external-graphic> has a invalid value: '" + string + "' (" + malformedURLException2 + ")");
            }
        }
        this.url = uRL;
    }

    public int getCompressionRate() {
        return this.graphicCompressionRate;
    }

    public boolean setCompressionRate(int n) {
        if (n < 1 || n > 100) {
            return false;
        }
        this.graphicCompressionRate = n;
        return true;
    }

    public boolean isEmpty() {
        return this.url == null;
    }

    private static class FormatPNG
    extends FormatBase {
        private FormatPNG() {
        }

        public static boolean isFormat(byte[] byArray) {
            byte[] byArray2 = new byte[]{80, 78, 71};
            return ImageUtil.compareHexValues(byArray2, byArray, 1, true);
        }

        public int getType() {
            return 1;
        }

        public String getRtfTag() {
            return "pngblip";
        }
    }

    private static class FormatJPG
    extends FormatBase {
        private FormatJPG() {
        }

        public static boolean isFormat(byte[] byArray) {
            byte[] byArray2 = new byte[]{-1, -40};
            return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
        }

        public int getType() {
            return 2;
        }

        public String getRtfTag() {
            return "jpegblip";
        }
    }

    private static class FormatBMP
    extends FormatBase {
        private FormatBMP() {
        }

        public static boolean isFormat(byte[] byArray) {
            byte[] byArray2 = new byte[]{66, 77};
            return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
        }

        public int getType() {
            return 3;
        }
    }

    private static class FormatEMF
    extends FormatBase {
        private FormatEMF() {
        }

        public static boolean isFormat(byte[] byArray) {
            byte[] byArray2 = new byte[]{1, 0, 0};
            return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
        }

        public int getType() {
            return 0;
        }

        public String getRtfTag() {
            return "emfblip";
        }
    }

    private static class FormatGIF
    extends FormatBase {
        private FormatGIF() {
        }

        public static boolean isFormat(byte[] byArray) {
            byte[] byArray2 = new byte[]{71, 73, 70, 56};
            return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
        }

        public int getType() {
            return 50;
        }
    }

    private static class FormatBase {
        private FormatBase() {
        }

        public static boolean isFormat(byte[] byArray) {
            return false;
        }

        public FormatBase convert(FormatBase formatBase, byte[] byArray) {
            return formatBase;
        }

        public static FormatBase determineFormat(byte[] byArray) {
            if (FormatPNG.isFormat(byArray)) {
                return new FormatPNG();
            }
            if (FormatJPG.isFormat(byArray)) {
                return new FormatJPG();
            }
            if (FormatEMF.isFormat(byArray)) {
                return new FormatEMF();
            }
            if (FormatGIF.isFormat(byArray)) {
                return new FormatGIF();
            }
            if (FormatBMP.isFormat(byArray)) {
                return new FormatBMP();
            }
            return null;
        }

        public int getType() {
            return -1;
        }

        public String getRtfTag() {
            return "";
        }
    }

    public static class ExternalGraphicException
    extends IOException {
        ExternalGraphicException(String string) {
            super(string);
        }
    }
}

