/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfLineBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfHyperLink
extends RtfContainer
implements IRtfTextContainer,
IRtfTextrunContainer {
    protected String url = null;
    protected RtfText mText = null;

    public RtfHyperLink(IRtfTextContainer iRtfTextContainer, Writer writer, String string, RtfAttributes rtfAttributes) throws IOException {
        super((RtfContainer)((Object)iRtfTextContainer), writer, rtfAttributes);
        new RtfText(this, writer, string, rtfAttributes);
    }

    public RtfHyperLink(RtfTextrun rtfTextrun, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfTextrun, writer, rtfAttributes);
    }

    public void writeRtfPrefix() throws IOException {
        super.writeGroupMark(true);
        super.writeControlWord("field");
        super.writeGroupMark(true);
        super.writeStarControlWord("fldinst");
        this.writer.write("HYPERLINK \"" + this.url + "\" ");
        super.writeGroupMark(false);
        super.writeGroupMark(true);
        super.writeControlWord("fldrslt");
        if (this.attrib != null && this.attrib.isSet("cs")) {
            this.writeGroupMark(true);
            this.writeAttributes(this.attrib, new String[]{"cs"});
        }
    }

    public void writeRtfSuffix() throws IOException {
        if (this.attrib != null && this.attrib.isSet("cs")) {
            this.writeGroupMark(false);
        }
        super.writeGroupMark(false);
        super.writeGroupMark(false);
    }

    public RtfText newText(String string) throws IOException {
        return this.newText(string, null);
    }

    public RtfText newText(String string, RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        this.mText = new RtfText(this, this.writer, string, rtfAttributes);
        return this.mText;
    }

    public RtfAttributes getTextContainerAttributes() throws FOPException {
        if (this.attrib == null) {
            return null;
        }
        try {
            return (RtfAttributes)this.attrib.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FOPException(cloneNotSupportedException);
        }
    }

    public void newLineBreak() throws IOException {
        new RtfLineBreak(this, this.writer);
    }

    private void closeCurrentText() throws IOException {
        if (this.mText != null) {
            this.mText.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentText();
    }

    public void setExternalURL(String string) {
        this.url = string;
    }

    public void setInternalURL(String string) {
        int n = string.length();
        int n2 = 40;
        this.url = "#" + string.substring(0, n > n2 ? n2 : n);
        this.url = this.url.replace('.', '_');
        this.url = this.url.replace(' ', '_');
    }

    public boolean isEmpty() {
        return false;
    }

    public RtfTextrun getTextrun() throws IOException {
        RtfTextrun rtfTextrun = RtfTextrun.getTextrun(this, this.writer, null);
        return rtfTextrun;
    }
}

