/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfHyperLinkContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfPageBreakContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfPageNumberCitationContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfPageNumberContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBookmarkContainerImpl;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfLineBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumberCitation;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public class RtfParagraph
extends RtfBookmarkContainerImpl
implements IRtfTextContainer,
IRtfPageBreakContainer,
IRtfHyperLinkContainer,
IRtfExternalGraphicContainer,
IRtfPageNumberContainer,
IRtfPageNumberCitationContainer {
    private RtfText text;
    private RtfHyperLink hyperlink;
    private RtfExternalGraphic externalGraphic;
    private RtfPageNumber pageNumber;
    private RtfPageNumberCitation pageNumberCitation;
    private boolean keepn = false;
    private boolean resetProperties = false;
    private boolean writeForBreak = false;
    private static final String[] PARA_ATTRIBUTES = new String[]{"intbl"};

    RtfParagraph(IRtfParagraphContainer iRtfParagraphContainer, Writer writer) throws IOException {
        super((RtfContainer)((Object)iRtfParagraphContainer), writer);
    }

    RtfParagraph(IRtfParagraphContainer iRtfParagraphContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super((RtfContainer)((Object)iRtfParagraphContainer), writer, rtfAttributes);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setKeepn() {
        this.keepn = true;
    }

    public void setResetProperties() {
        this.resetProperties = true;
    }

    public RtfAttributes getTextContainerAttributes() throws FOPException {
        if (this.attrib == null) {
            return null;
        }
        try {
            return (RtfAttributes)this.attrib.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FOPException(cloneNotSupportedException);
        }
    }

    protected void writeRtfPrefix() throws IOException {
        if (this.resetProperties) {
            this.writeControlWord("pard");
        }
        this.writeAttributes(this.attrib, RtfText.ATTR_NAMES);
        this.writeAttributes(this.attrib, PARA_ATTRIBUTES);
        if (this.attrib.isSet("intbl") && this.mustWriteAttributes()) {
            this.writeAttributes(this.attrib, RtfText.ALIGNMENT);
        }
        if (this.keepn) {
            this.writeControlWord("keepn");
        }
        if (this.mustWriteGroupMark()) {
            this.writeGroupMark(true);
        }
        if (this.mustWriteAttributes()) {
            if (!this.attrib.isSet("intbl")) {
                this.writeAttributes(this.attrib, RtfText.ALIGNMENT);
            }
            this.writeAttributes(this.attrib, RtfText.BORDER);
            this.writeAttributes(this.attrib, RtfText.INDENT);
            this.writeAttributes(this.attrib, RtfText.TABS);
            if (this.writeForBreak) {
                this.writeControlWord("pard\\par");
            }
        }
    }

    protected void writeRtfSuffix() throws IOException {
        boolean bl = true;
        if (this.parent instanceof RtfTableCell) {
            bl = ((RtfTableCell)this.parent).paragraphNeedsPar(this);
        }
        if (bl) {
            this.writeControlWord("par");
        }
        if (this.mustWriteGroupMark()) {
            this.writeGroupMark(false);
        }
    }

    public RtfText newText(String string) throws IOException {
        return this.newText(string, null);
    }

    public RtfText newText(String string, RtfAttributes rtfAttributes) throws IOException {
        this.closeAll();
        this.text = new RtfText(this, this.writer, string, rtfAttributes);
        return this.text;
    }

    public void newPageBreak() throws IOException {
        this.writeForBreak = true;
        new RtfPageBreak(this, this.writer);
    }

    public void newLineBreak() throws IOException {
        new RtfLineBreak(this, this.writer);
    }

    public RtfPageNumber newPageNumber() throws IOException {
        this.pageNumber = new RtfPageNumber(this, this.writer);
        return this.pageNumber;
    }

    public RtfPageNumberCitation newPageNumberCitation(String string) throws IOException {
        this.pageNumberCitation = new RtfPageNumberCitation(this, this.writer, string);
        return this.pageNumberCitation;
    }

    public RtfHyperLink newHyperLink(String string, RtfAttributes rtfAttributes) throws IOException {
        this.hyperlink = new RtfHyperLink(this, this.writer, string, rtfAttributes);
        return this.hyperlink;
    }

    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.externalGraphic = new RtfExternalGraphic(this, this.writer);
        return this.externalGraphic;
    }

    private void closeCurrentText() throws IOException {
        if (this.text != null) {
            this.text.close();
        }
    }

    private void closeCurrentHyperLink() throws IOException {
        if (this.hyperlink != null) {
            this.hyperlink.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentText();
        this.closeCurrentHyperLink();
    }

    protected boolean okToWriteRtf() {
        boolean bl = super.okToWriteRtf();
        if (this.parent.getOptions().ignoreEmptyParagraphs() && this.getChildCount() == 0) {
            bl = false;
        }
        return bl;
    }

    private boolean mustWriteAttributes() {
        boolean bl = false;
        int n = this.getChildCount();
        if (n > 0) {
            List list = this.getChildren();
            for (int i = 0; i < n; ++i) {
                RtfElement rtfElement = (RtfElement)list.get(i);
                if (rtfElement.isEmpty()) continue;
                if (rtfElement.getClass() == RtfText.class) {
                    boolean bl2 = ((RtfText)rtfElement).isNbsp();
                    if (bl2) continue;
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean mustWriteGroupMark() {
        return this.getChildCount() > 0;
    }

    public RtfAttributes getTextAttributes() {
        if (this.text == null) {
            return null;
        }
        return this.text.getTextAttributes();
    }
}

