/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBookmark;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfLeader;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfPageNumberCitation;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraphBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceManager;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSpaceSplitter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTextrun
extends RtfContainer {
    public static final int BREAK_NONE = 0;
    public static final int BREAK_PAGE = 1;
    public static final int BREAK_COLUMN = 2;
    public static final int BREAK_EVEN_PAGE = 3;
    public static final int BREAK_ODD_PAGE = 4;
    private boolean bSuppressLastPar = false;
    private RtfListItem rtfListItem;
    protected static final Log log = LogFactory.getLog(RtfTextrun.class);
    private RtfSpaceManager rtfSpaceManager = new RtfSpaceManager();

    RtfTextrun(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfContainer, writer, rtfAttributes);
    }

    private void addOpenGroupMark(RtfAttributes rtfAttributes) throws IOException {
        RtfOpenGroupMark rtfOpenGroupMark = new RtfOpenGroupMark(this, this.writer, rtfAttributes);
    }

    private void addCloseGroupMark(int n) throws IOException {
        RtfCloseGroupMark rtfCloseGroupMark = new RtfCloseGroupMark(this, this.writer, n);
    }

    private void addCloseGroupMark() throws IOException {
        RtfCloseGroupMark rtfCloseGroupMark = new RtfCloseGroupMark(this, this.writer, 0);
    }

    public void pushBlockAttributes(RtfAttributes rtfAttributes) throws IOException {
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        RtfSpaceSplitter rtfSpaceSplitter = this.rtfSpaceManager.pushRtfSpaceSplitter(rtfAttributes);
        this.addOpenGroupMark(rtfSpaceSplitter.getCommonAttributes());
    }

    public void popBlockAttributes(int n) throws IOException {
        this.rtfSpaceManager.popRtfSpaceSplitter();
        this.rtfSpaceManager.stopUpdatingSpaceBefore();
        this.addCloseGroupMark(n);
    }

    public void pushInlineAttributes(RtfAttributes rtfAttributes) throws IOException {
        this.rtfSpaceManager.pushInlineAttributes(rtfAttributes);
        this.addOpenGroupMark(rtfAttributes);
    }

    public void addPageNumberCitation(String string) throws IOException {
        RtfPageNumberCitation rtfPageNumberCitation = new RtfPageNumberCitation((RtfContainer)this, this.writer, string);
    }

    public void popInlineAttributes() throws IOException {
        this.rtfSpaceManager.popInlineAttributes();
        this.addCloseGroupMark();
    }

    public void addString(String string) throws IOException {
        if (string.equals("")) {
            return;
        }
        RtfAttributes rtfAttributes = this.rtfSpaceManager.getLastInlineAttribute();
        this.rtfSpaceManager.pushRtfSpaceSplitter(rtfAttributes);
        this.rtfSpaceManager.setCandidate(rtfAttributes);
        new RtfString((RtfContainer)this, this.writer, string);
        this.rtfSpaceManager.popRtfSpaceSplitter();
    }

    public RtfFootnote addFootnote() throws IOException {
        return new RtfFootnote(this, this.writer);
    }

    public RtfParagraphBreak addParagraphBreak() throws IOException {
        List list = this.getChildren();
        Stack<Integer> stack = new Stack<Integer>();
        RtfParagraphBreak rtfParagraphBreak = null;
        int n = 0;
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious() && listIterator.previous() instanceof RtfCloseGroupMark) {
            stack.push(((RtfCloseGroupMark)listIterator.next()).getBreakType());
            listIterator.remove();
            ++n;
        }
        if (list.size() != 0) {
            this.setChildren(list);
            rtfParagraphBreak = new RtfParagraphBreak(this, this.writer);
            for (int i = 0; i < n; ++i) {
                this.addCloseGroupMark((Integer)stack.pop());
            }
        }
        return rtfParagraphBreak;
    }

    public void addLeader(RtfAttributes rtfAttributes) throws IOException {
        new RtfLeader(this, this.writer, rtfAttributes);
    }

    public void addPageNumber(RtfAttributes rtfAttributes) throws IOException {
        RtfPageNumber rtfPageNumber = new RtfPageNumber(this, this.writer, rtfAttributes);
    }

    public RtfHyperLink addHyperlink(RtfAttributes rtfAttributes) throws IOException {
        return new RtfHyperLink(this, this.writer, rtfAttributes);
    }

    public void addBookmark(String string) throws IOException {
        if (string != "") {
            new RtfBookmark((RtfContainer)this, this.writer, string);
        }
    }

    public RtfExternalGraphic newImage() throws IOException {
        return new RtfExternalGraphic(this, this.writer);
    }

    public static RtfTextrun getTextrun(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        List list = rtfContainer.getChildren();
        if (list.size() == 0) {
            RtfTextrun rtfTextrun = new RtfTextrun(rtfContainer, writer, rtfAttributes);
            list.add(rtfTextrun);
            return rtfTextrun;
        }
        Object e = list.get(list.size() - 1);
        if (e instanceof RtfTextrun) {
            return (RtfTextrun)e;
        }
        RtfTextrun rtfTextrun = new RtfTextrun(rtfContainer, writer, rtfAttributes);
        list.add(rtfTextrun);
        return rtfTextrun;
    }

    public void setSuppressLastPar(boolean bl) {
        this.bSuppressLastPar = bl;
    }

    protected void writeRtfContent() throws IOException {
        boolean bl = this.getParentOfClass(RtfTableCell.class) != null;
        RtfAttributes rtfAttributes = new RtfAttributes();
        boolean bl2 = false;
        Object object = this.parent.getChildren().iterator();
        while (object.hasNext()) {
            if (object.next() != this) continue;
            bl2 = !object.hasNext();
            break;
        }
        object = null;
        if (bl2) {
            RtfElement rtfElement = null;
            for (RtfElement rtfElement2 : this.getChildren()) {
                if (rtfElement2 instanceof RtfParagraphBreak) {
                    if (!(rtfElement instanceof RtfParagraphBreak) && !(rtfElement instanceof RtfBookmark)) {
                        object = (RtfParagraphBreak)rtfElement2;
                    }
                } else if (!(rtfElement2 instanceof RtfOpenGroupMark) && !(rtfElement2 instanceof RtfCloseGroupMark) && rtfElement2.isEmpty()) {
                    object = null;
                }
                rtfElement = rtfElement2;
            }
        }
        this.writeAttributes(this.attrib, null);
        if (this.rtfListItem != null) {
            this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        for (RtfElement rtfElement : this.getChildren()) {
            boolean bl6 = rtfElement instanceof RtfParagraphBreak;
            if (bl) {
                rtfAttributes.set(rtfElement.getRtfAttributes());
            }
            boolean bl7 = false;
            bl7 = bl6;
            boolean bl8 = bl7 = bl7 && (bl3 || bl5 || this.bSuppressLastPar && bl2 && object != null && rtfElement == object || bl4) && ((RtfParagraphBreak)rtfElement).canHide();
            if (!bl7) {
                this.newLine();
                rtfElement.writeRtf();
                if (this.rtfListItem != null && rtfElement instanceof RtfParagraphBreak) {
                    this.rtfListItem.getRtfListStyle().writeParagraphPrefix(this);
                }
            }
            if (rtfElement instanceof RtfParagraphBreak) {
                bl3 = true;
                continue;
            }
            if (rtfElement instanceof RtfBookmark) {
                bl4 = true;
                continue;
            }
            if (rtfElement instanceof RtfCloseGroupMark || rtfElement instanceof RtfOpenGroupMark) continue;
            bl3 = bl3 && rtfElement.isEmpty();
            bl5 = bl5 && rtfElement.isEmpty();
            bl4 = false;
        }
        if (bl) {
            this.writeAttributes(rtfAttributes, null);
        }
    }

    public void setRtfListItem(RtfListItem rtfListItem) {
        this.rtfListItem = rtfListItem;
    }

    public RtfListItem getRtfListItem() {
        return this.rtfListItem;
    }

    private class RtfCloseGroupMark
    extends RtfElement {
        private int breakType;

        RtfCloseGroupMark(RtfContainer rtfContainer, Writer writer, int n) throws IOException {
            super(rtfContainer, writer);
            this.breakType = 0;
            this.breakType = n;
        }

        public boolean isEmpty() {
            return false;
        }

        public int getBreakType() {
            return this.breakType;
        }

        protected void writeRtfContent() throws IOException {
            boolean bl;
            this.writeGroupMark(false);
            boolean bl2 = bl = this.getParentOfClass(RtfTableCell.class) != null;
            if (this.breakType != 0) {
                if (!bl) {
                    this.writeControlWord("sect");
                    switch (this.breakType) {
                        case 3: {
                            this.writeControlWord("sbkeven");
                            break;
                        }
                        case 4: {
                            this.writeControlWord("sbkodd");
                            break;
                        }
                        case 2: {
                            this.writeControlWord("sbkcol");
                            break;
                        }
                        default: {
                            this.writeControlWord("sbkpage");
                            break;
                        }
                    }
                } else {
                    log.warn((Object)"Cannot create break-after for a paragraph inside a table.");
                }
            }
        }
    }

    private class RtfOpenGroupMark
    extends RtfElement {
        RtfOpenGroupMark(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
            super(rtfContainer, writer, rtfAttributes);
        }

        public boolean isEmpty() {
            return false;
        }

        protected void writeRtfContent() throws IOException {
            this.writeGroupMark(true);
            this.writeAttributes(this.getRtfAttributes(), null);
        }
    }
}

