/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.tools.BuilderContext;

public class TableContext
implements ITableColumnsInfo {
    private final Log log = new SimpleLog("FOP/RTF");
    private final BuilderContext context;
    private final List colWidths = new ArrayList();
    private int colIndex;
    private final List colRowSpanningNumber = new ArrayList();
    private final List colRowSpanningAttrs = new ArrayList();
    private final List colFirstSpanningCol = new ArrayList();
    private boolean bNextRowBelongsToHeader = false;

    public void setNextRowBelongsToHeader(boolean bl) {
        this.bNextRowBelongsToHeader = bl;
    }

    public boolean getNextRowBelongsToHeader() {
        return this.bNextRowBelongsToHeader;
    }

    public TableContext(BuilderContext builderContext) {
        this.context = builderContext;
    }

    public void setNextColumnWidth(Float f) {
        this.colWidths.add(f);
    }

    public RtfAttributes getColumnRowSpanningAttrs() {
        return (RtfAttributes)this.colRowSpanningAttrs.get(this.colIndex);
    }

    public Integer getColumnRowSpanningNumber() {
        return (Integer)this.colRowSpanningNumber.get(this.colIndex);
    }

    public boolean getFirstSpanningCol() {
        Boolean bl = (Boolean)this.colFirstSpanningCol.get(this.colIndex);
        return bl;
    }

    public void setCurrentColumnRowSpanning(Integer n, RtfAttributes rtfAttributes) {
        if (this.colIndex < this.colRowSpanningNumber.size()) {
            this.colRowSpanningNumber.set(this.colIndex, n);
            this.colRowSpanningAttrs.set(this.colIndex, rtfAttributes);
        } else {
            this.colRowSpanningNumber.add(n);
            this.colRowSpanningAttrs.add(this.colIndex, rtfAttributes);
        }
    }

    public void setNextColumnRowSpanning(Integer n, RtfAttributes rtfAttributes) {
        this.colRowSpanningNumber.add(n);
        this.colRowSpanningAttrs.add(this.colIndex, rtfAttributes);
    }

    public void setCurrentFirstSpanningCol(boolean bl) {
        if (this.colIndex < this.colRowSpanningNumber.size()) {
            while (this.colIndex >= this.colFirstSpanningCol.size()) {
                this.setNextFirstSpanningCol(false);
            }
            this.colFirstSpanningCol.set(this.colIndex, new Boolean(bl));
        } else {
            this.colFirstSpanningCol.add(new Boolean(bl));
        }
    }

    public void setNextFirstSpanningCol(boolean bl) {
        this.colFirstSpanningCol.add(new Boolean(bl));
    }

    public void decreaseRowSpannings() {
        for (int i = 0; i < this.colRowSpanningNumber.size(); ++i) {
            Integer n = (Integer)this.colRowSpanningNumber.get(i);
            if (n > 0) {
                n = new Integer(n - 1);
            }
            this.colRowSpanningNumber.set(i, n);
            if (n != 0) continue;
            this.colRowSpanningAttrs.set(i, null);
            this.colFirstSpanningCol.set(i, new Boolean(false));
        }
    }

    public void selectFirstColumn() {
        this.colIndex = 0;
    }

    public void selectNextColumn() {
        ++this.colIndex;
    }

    public float getColumnWidth() {
        if (this.colIndex < 0) {
            throw new IllegalStateException("colIndex must not be negative!");
        }
        if (this.colIndex >= this.getNumberOfColumns()) {
            this.log.warn((Object)("Column width for column " + (this.colIndex + 1) + " is not defined, using " + 200.0f));
            while (this.colIndex >= this.getNumberOfColumns()) {
                this.setNextColumnWidth(new Float(200.0f));
            }
        }
        return ((Float)this.colWidths.get(this.colIndex)).floatValue();
    }

    public void setColumnIndex(int n) {
        this.colIndex = n;
    }

    public int getColumnIndex() {
        return this.colIndex;
    }

    public int getNumberOfColumns() {
        return this.colWidths.size();
    }
}

