/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.txt.Helper;
import org.apache.fop.render.txt.TXTState;
import org.apache.fop.render.txt.TXTStream;
import org.apache.fop.render.txt.border.BorderManager;
import org.apache.xmlgraphics.util.UnitConv;

public class TXTRenderer
extends AbstractPathOrientedRenderer {
    private static final char LIGHT_SHADE = '\u2591';
    private static final char MEDIUM_SHADE = '\u2592';
    private static final char DARK_SHADE = '\u2593';
    private static final char FULL_BLOCK = '\u2588';
    private static final char IMAGE_CHAR = '#';
    private OutputStream outputStream;
    private TXTStream currentStream;
    private StringBuffer[] charData;
    private StringBuffer[] decoData;
    public static final int LINE_LEADING = 1070;
    public static final int CHAR_HEIGHT = 7860;
    public static final int CHAR_WIDTH = 6000;
    private int pageWidth;
    private int pageHeight;
    private final String lineEnding = "\r\n";
    private final String pageEnding = "\f";
    private boolean firstPage = false;
    private BorderManager bm;
    private char fillChar;
    private final TXTState currentState = new TXTState();
    private String encoding;

    public TXTRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public String getMimeType() {
        return "text/plain";
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean isLayInside(int n, int n2) {
        return n >= 0 && n < this.pageWidth && n2 >= 0 && n2 < this.pageHeight;
    }

    protected void addChar(int n, int n2, char c, boolean bl) {
        Point point = this.currentState.transformPoint(n, n2);
        this.putChar(point.x, point.y, c, bl);
    }

    protected void putChar(int n, int n2, char c, boolean bl) {
        if (this.isLayInside(n, n2)) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = bl ? this.charData[n2] : this.decoData[n2];
            while (stringBuffer.length() <= n) {
                stringBuffer.append(' ');
            }
            stringBuffer.setCharAt(n, c);
        }
    }

    protected void addString(int n, int n2, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addChar(n2 + i, n, string.charAt(i), true);
        }
    }

    protected void renderText(TextArea textArea) {
        int n = Helper.ceilPosition(this.currentIPPosition, 6000);
        int n2 = Helper.ceilPosition(this.currentBPPosition - 1070, 10000);
        String string = textArea.getText();
        this.addString(n2, n, string);
        super.renderText(textArea);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        if (this.firstPage) {
            this.firstPage = false;
        } else {
            this.currentStream.add("\f");
        }
        Rectangle rectangle = pageViewport.getViewArea();
        double d = ((RectangularShape)rectangle).getWidth();
        double d2 = ((RectangularShape)rectangle).getHeight();
        this.pageWidth = Helper.ceilPosition((int)d, 6000);
        this.pageHeight = Helper.ceilPosition((int)d2, 10000);
        this.charData = new StringBuffer[this.pageHeight];
        this.decoData = new StringBuffer[this.pageHeight];
        for (int i = 0; i < this.pageHeight; ++i) {
            this.charData[i] = new StringBuffer();
            this.decoData[i] = new StringBuffer();
        }
        this.bm = new BorderManager(this.pageWidth, this.pageHeight, this.currentState);
        super.renderPage(pageViewport);
        this.flushBorderToBuffer();
        this.flushBuffer();
    }

    private void flushBorderToBuffer() {
        for (int i = 0; i < this.pageWidth; ++i) {
            for (int j = 0; j < this.pageHeight; ++j) {
                Character c = this.bm.getCharacter(i, j);
                if (c == null) continue;
                this.putChar(i, j, c.charValue(), false);
            }
        }
    }

    private void flushBuffer() {
        for (int i = 0; i < this.pageHeight; ++i) {
            StringBuffer stringBuffer = this.charData[i];
            StringBuffer stringBuffer2 = this.decoData[i];
            StringBuffer stringBuffer3 = null;
            if (stringBuffer != null && stringBuffer2 == null) {
                stringBuffer3 = stringBuffer;
            } else if (stringBuffer2 != null && stringBuffer == null) {
                stringBuffer3 = stringBuffer2;
            } else if (stringBuffer != null && stringBuffer2 != null) {
                int n = stringBuffer2.length();
                if (stringBuffer.length() > n) {
                    n = stringBuffer.length();
                }
                stringBuffer3 = new StringBuffer();
                for (int j = 0; j < n; ++j) {
                    if (j < stringBuffer.length() && stringBuffer.charAt(j) != ' ') {
                        stringBuffer3.append(stringBuffer.charAt(j));
                        continue;
                    }
                    if (j < stringBuffer2.length()) {
                        stringBuffer3.append(stringBuffer2.charAt(j));
                        continue;
                    }
                    stringBuffer3.append(' ');
                }
            }
            if (stringBuffer3 != null) {
                this.currentStream.add(stringBuffer3.toString());
            }
            if (i >= this.pageHeight) continue;
            this.currentStream.add("\r\n");
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info((Object)"Rendering areas to TEXT.");
        this.outputStream = outputStream;
        this.currentStream = new TXTStream(outputStream);
        this.currentStream.setEncoding(this.encoding);
        this.firstPage = true;
    }

    public void stopRenderer() throws IOException {
        log.info((Object)"writing out TEXT");
        this.outputStream.flush();
        super.stopRenderer();
    }

    protected void restoreStateStackAfterBreakOut(List list) {
    }

    protected List breakOutOfStateStack() {
        return null;
    }

    protected void saveGraphicsState() {
        this.currentState.push(new CTM());
    }

    protected void restoreGraphicsState() {
        this.currentState.pop();
    }

    protected void beginTextObject() {
    }

    protected void endTextObject() {
    }

    protected void clip() {
    }

    protected void clipRect(float f, float f2, float f3, float f4) {
    }

    protected void moveTo(float f, float f2) {
    }

    protected void lineTo(float f, float f2) {
    }

    protected void closePath() {
    }

    private void fillRect(int n, int n2, int n3, int n4, char c) {
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                this.addChar(i, j, c, false);
            }
        }
    }

    protected void fillRect(float f, float f2, float f3, float f4) {
        this.fillRect(this.bm.getStartX(), this.bm.getStartY(), this.bm.getWidth(), this.bm.getHeight(), this.fillChar);
    }

    protected void updateColor(Color color, boolean bl) {
        if (color == null) {
            return;
        }
        double d = 0.0011764707f * (float)color.getRed() + 0.0023137254f * (float)color.getGreen() + 4.3137255E-4f * (float)color.getBlue();
        this.fillChar = (d = 1.0 - d) > (double)0.8f ? (char)9608 : (d > (double)0.6f ? (char)9619 : (d > (double)0.4f ? (char)9618 : (d > (double)0.2f ? (char)9617 : (char)32)));
    }

    protected void drawImage(String string, Rectangle2D rectangle2D, Map map) {
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        int n = Helper.ceilPosition(this.currentIPPosition, 6000);
        int n2 = Helper.ceilPosition(this.currentBPPosition - 1070, 10000);
        int n3 = Helper.ceilPosition((int)rectangle2D.getWidth(), 6000);
        int n4 = Helper.ceilPosition((int)rectangle2D.getHeight(), 10000);
        this.fillRect(n, n2, n3, n4, '#');
    }

    protected int toMilli(float f) {
        return Math.round(f * 1000.0f);
    }

    private void addBitOfBorder(int n, int n2, int n3, int n4) {
        Point point = this.currentState.transformPoint(n, n2);
        if (this.isLayInside(point.x, point.y)) {
            this.bm.addBorderElement(point.x, point.y, n3, n4);
        }
    }

    protected void drawBorderLine(float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n, Color color) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.bm.getHeight();
        int n10 = this.bm.getWidth();
        int n11 = this.bm.getStartX();
        int n12 = this.bm.getStartY();
        if (bl && bl2) {
            n8 = n11;
            n7 = n12;
        } else if (bl && !bl2) {
            n8 = n11;
            n7 = n12 + n9 - 1;
        } else if (!bl && bl2) {
            n8 = n11;
            n7 = n12;
        } else {
            n8 = n11 + n10 - 1;
            n7 = n12;
        }
        if (bl) {
            n6 = n10;
            n5 = 1;
            n4 = 0;
            n3 = 2;
            n2 = 8;
        } else {
            n6 = n9;
            n5 = 0;
            n4 = 1;
            n3 = 4;
            n2 = 1;
        }
        this.addBitOfBorder(n8, n7, n, n3);
        for (int i = 0; i < n6 - 2; ++i) {
            this.addBitOfBorder(n8 += n5, n7 += n4, n, n3 + n2);
        }
        this.addBitOfBorder(n8 += n5, n7 += n4, n, n2);
    }

    protected void drawBackAndBorders(Area area, float f, float f2, float f3, float f4) {
        this.bm.setWidth(Helper.ceilPosition(this.toMilli(f3), 6000));
        this.bm.setHeight(Helper.ceilPosition(this.toMilli(f4), 10000));
        this.bm.setStartX(Helper.ceilPosition(this.toMilli(f), 6000));
        this.bm.setStartY(Helper.ceilPosition(this.toMilli(f2), 10000));
        super.drawBackAndBorders(area, f, f2, f3, f4);
    }

    protected void startVParea(CTM cTM, Rectangle rectangle) {
        this.currentState.push(cTM);
    }

    protected void endVParea() {
        this.currentState.pop();
    }

    protected void concatenateTransformationMatrix(AffineTransform affineTransform) {
        this.currentState.push(new CTM(UnitConv.ptToMpt((AffineTransform)affineTransform)));
    }
}

