/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.fop.area.CTM;
import org.apache.fop.render.txt.Helper;

public class TXTState {
    private LinkedList stackCTM = new LinkedList();
    private CTM resultCTM = new CTM();

    private void updateResultCTM(CTM cTM) {
        this.resultCTM = this.resultCTM.multiply(cTM);
    }

    private void calcResultCTM() {
        this.resultCTM = new CTM();
        Iterator iterator = this.stackCTM.iterator();
        while (iterator.hasNext()) {
            this.updateResultCTM((CTM)iterator.next());
        }
    }

    public void push(CTM cTM) {
        this.stackCTM.addLast(cTM);
        this.updateResultCTM(cTM);
    }

    public void pop() {
        this.stackCTM.removeLast();
        this.calcResultCTM();
    }

    public CTM refineCTM(CTM cTM) {
        double[] dArray = cTM.toArray();
        dArray[4] = Helper.roundPosition((int)dArray[4], 6000);
        dArray[5] = Helper.roundPosition((int)dArray[5], 7860);
        return new CTM(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public Point transformPoint(Point point, CTM cTM) {
        Rectangle2D rectangle2D = new Rectangle2D.Double(point.x, point.y, 0.0, 0.0);
        CTM cTM2 = this.refineCTM(cTM);
        rectangle2D = cTM2.transform(rectangle2D);
        return new Point((int)rectangle2D.getX(), (int)rectangle2D.getY());
    }

    public Point transformPoint(int n, int n2) {
        return this.transformPoint(new Point(n, n2), this.resultCTM);
    }

    public CTM getResultCTM() {
        return this.resultCTM;
    }
}

