/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt.border;

import java.awt.Point;
import java.util.Arrays;
import org.apache.fop.area.CTM;
import org.apache.fop.fo.Constants;
import org.apache.fop.render.txt.TXTState;

public abstract class AbstractBorderElement
implements Constants {
    public static final int UP = 0;
    public static final int RIGHT = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    protected int[] data = new int[]{0, 0, 0, 0};

    public AbstractBorderElement() {
    }

    public AbstractBorderElement(int n) {
        for (int i = 0; i < 4; ++i) {
            this.data[i] = n >> i & 1;
        }
    }

    public int getData(int n) {
        return this.data[n];
    }

    public void setData(int n, int n2) {
        this.data[n] = n2;
    }

    public void transformElement(TXTState tXTState) {
        double[] dArray = tXTState.getResultCTM().toArray();
        CTM cTM = new CTM(dArray[0], -dArray[1], -dArray[2], dArray[3], 0.0, 0.0);
        Point[] pointArray = new Point[]{new Point(0, this.data[0]), new Point(this.data[1], 0), new Point(0, -this.data[2]), new Point(-this.data[3], 0)};
        Arrays.fill(this.data, 0);
        for (int i = 0; i < 4; ++i) {
            Point point = tXTState.transformPoint(pointArray[i], cTM);
            int n = (int)point.distance(0.0, 0.0);
            if (point.x == 0 && point.y > 0) {
                this.data[0] = n;
                continue;
            }
            if (point.x == 0 && point.y < 0) {
                this.data[2] = n;
                continue;
            }
            if (point.x > 0 && point.y == 0) {
                this.data[1] = n;
                continue;
            }
            if (point.x >= 0 || point.y != 0) continue;
            this.data[3] = n;
        }
    }

    public abstract AbstractBorderElement merge(AbstractBorderElement var1);

    public abstract char convert2Char();
}

